/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.AvailableStorageTableModel;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.GenericTableCellRenderer;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.storage.AvailableStorageTableHeader;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.swing.table.SrTableCellTooltip;
import com.sanrad.util.StorageSize;
import java.awt.Component;
import java.awt.Dimension;
import java.math.BigInteger;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class AvailableStorageTablePanel
extends SrClientTablePanel {
    private static final long serialVersionUID = 1L;
    private static final int theVisibleRowsNumber = 5;

    public AvailableStorageTablePanel() {
        super(new AvailableStorageTableModel());
        this.setRenderersAndEditors();
        int rowH = this.getTable().getRowHeight();
        JTableHeader tableHeader = this.getTable().getTableHeader();
        int preferredH = rowH * 5 + tableHeader.getHeight();
        int preferredW = preferredH * 3 / 2;
        this.getTable().setPreferredScrollableViewportSize(new Dimension(preferredW, preferredH));
        this.getTable().getColumn(AvailableStorageTableHeader.TYPE).setPreferredWidth(preferredW / 3);
        this.getTable().getColumn(AvailableStorageTableHeader.TOTAL_SIZE).setPreferredWidth(preferredW / 3);
        this.getTable().getColumn(AvailableStorageTableHeader.NON_ALLOCATED_SPACE).setPreferredWidth(preferredW / 3);
    }

    public void updateTable(ClusterNode aCluster) {
        this.clearDisabledRowsState();
        ((AvailableStorageTableModel)this.getModel()).updateTable(aCluster);
    }

    @Override
    protected Class getTableHeaderClass() {
        return AvailableStorageTableHeader.class;
    }

    private void setRenderersAndEditors() {
        int columnCount = this.getTable().getColumnCount();
        AvailableStorageTableCellRenderer renderer = new AvailableStorageTableCellRenderer();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn tableColumn = this.getTable().getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(renderer);
        }
    }

    public PhysicalStorageDriveTypeConstant getStorageTypeAt(int aRow) {
        AvailableStorageTableModel.RaidParams params = (AvailableStorageTableModel.RaidParams)this.getValueAt(aRow, AvailableStorageTableHeader.TYPE.getIndexInModel());
        return params.getDriveType();
    }

    public PhysicalStorageRaidLevelConstant getRaidLevelAt(int aRow) {
        AvailableStorageTableModel.RaidParams params = (AvailableStorageTableModel.RaidParams)this.getValueAt(aRow, AvailableStorageTableHeader.TYPE.getIndexInModel());
        return params.getRaidLevel();
    }

    public BigInteger getAvailableSpaceAt(int aRow) {
        BigInteger retVal = (BigInteger)this.getValueAt(aRow, AvailableStorageTableHeader.NON_ALLOCATED_SPACE.getIndexInModel());
        return retVal;
    }

    private class AvailableStorageTableCellRenderer
    extends GenericTableCellRenderer
    implements SrTableCellTooltip {
        private static final long serialVersionUID = 1L;
        private static final String EMPTY_VALUE_STR = "-----";

        private AvailableStorageTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int typeCol = AvailableStorageTableHeader.TYPE.getIndexInModel();
            int totalSpaceCol = AvailableStorageTableHeader.TOTAL_SIZE.getIndexInModel();
            int freeSpaceCol = AvailableStorageTableHeader.NON_ALLOCATED_SPACE.getIndexInModel();
            if (value == null || value.toString() == null) {
                this.setText(EMPTY_VALUE_STR);
            } else {
                if (column == totalSpaceCol || column == freeSpaceCol) {
                    this.setText(StorageSize.getSizeAsString((BigInteger)value));
                }
                if (column == typeCol) {
                    AvailableStorageTableModel.RaidParams params = (AvailableStorageTableModel.RaidParams)value;
                    PhysicalStorageDriveTypeConstant type = params.getDriveType();
                    if (PhysicalStorageDriveTypeConstant.PHYS_STOR_DRIVE_TYPE_SAS.equals(type) || PhysicalStorageDriveTypeConstant.PHYS_STOR_DRIVE_TYPE_SATA.equals(type)) {
                        this.setIcon(ClientImageObject.DISK.getImageIcon());
                    } else {
                        this.setIcon(ClientImageObject.GENERAL_SCSI_DEVICE.getImageIcon());
                    }
                    this.setText(this.getTextForRaidParams(params));
                }
            }
            return this;
        }

        private String getTextForRaidParams(AvailableStorageTableModel.RaidParams aParams) {
            if (aParams == null) {
                return "";
            }
            if (aParams.getDriveType() == null) {
                return EMPTY_VALUE_STR;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(aParams.getDriveType());
            PhysicalStorageRaidLevelConstant raidLevel = aParams.getRaidLevel();
            if (raidLevel != null && !PhysicalStorageRaidLevelConstant.NO_RAID.equals(raidLevel)) {
                sb.append(' ');
                sb.append(raidLevel);
            }
            return sb.toString();
        }

        @Override
        public String getTooltipText(int aRow, int aCol) {
            if (AvailableStorageTablePanel.this.isEnabledRow(aRow)) {
                return this.getText();
            }
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_MIRROR_NOT_AVAILABLE);
        }
    }
}

