/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.target.dialogs;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.AclEntryNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.auth.CredentialsValidator;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.lu.LUListener;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.target.TargetListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTabbedPane;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrMultiLineLabel;
import com.sanrad.swing.components.SrPasswordTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;

public class TargetPropertiesDialog
extends SrOKCancelDialog
implements TargetListener,
LUListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private SrClientLabel luLbl;
    private SrTextField realLULbl;
    private SrClientLabel exposedOnVSwitchLbl;
    private SrClientLabel defAccessLbl;
    private SrComboBox exposedOnVSwitchFld;
    private int luNum;
    protected Permission defaultPermission;
    protected SrTextField aliasFld;
    protected SrComboBox<Permission> defAccessCbx;
    protected SrTextField nameFld;
    protected SrClientLabel aliasLabel;
    protected SrClientLabel nameLbl;
    protected SrPasswordTextField passwordFld;
    protected SrClientLabel passwordLbl;
    protected SrClientLabel userNameLbl;
    protected SrTextField userNameFld;
    protected Permission[] permissions = new Permission[]{Permission.N_A, Permission.READ_ONLY, Permission.READ_WRITE};
    private TargetNode targetNode;
    private SrClientLabel m_statusLblKey;
    private SrTextField m_statusLblVal;
    private SrClientLabel m_numOfSCSIPortsLblKey;
    private SrTextField m_numOfSCSIPortsVal;
    private SrClientLabel m_portNameLblKey;
    private SrTextField m_portNameVal;
    private SrClientLabel m_numOfLoginFailuresLblKey;
    private SrTextField m_numOfLoginFailuresVal;
    private SrClientLabel m_lastFailureTimeLblKey;
    private SrTextField m_lastFailureTimeVal;
    private SrClientLabel m_lastFailureTypeLblKey;
    private SrTextField m_lastFailureTypeVal;
    private SrClientLabel m_lastFailedInitiatorNameLblKey;
    private SrTextField m_lastFailedInitiatorNameVal;
    private SrClientLabel m_lastFailedInitiatorIPLblKey;
    private SrTextField m_lastFailedInitiatorIPVal;
    private SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String password;
            String userName;
            CredentialsValidator validator;
            String vsName;
            TargetPropertiesDialog.this.myIsShouldDispose = true;
            Permission permission = (Permission)TargetPropertiesDialog.this.defAccessCbx.getSelectedItem();
            ArrayList<SrFuture<Void>> retVal = new ArrayList<SrFuture<Void>>();
            if (!permission.equals(TargetPropertiesDialog.this.defaultPermission)) {
                String warningMsg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_ACL_CHANGED_WARNING_MSG);
                int answer = SrOptionPaneUtil.showYesNoCancelConfirmDialog(TargetPropertiesDialog.this, warningMsg, TargetPropertiesDialog.this.getTitle());
                if (answer == 0) {
                    ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(TargetPropertiesDialog.this.targetNode);
                    PolicyManager policyMgr = clusterNode.getPolicyManager();
                    retVal.add(policyMgr.editDefaultAclEntry(TargetPropertiesDialog.this.targetNode, permission));
                } else if (answer == 1) {
                    TargetPropertiesDialog.this.defAccessCbx.setSelectedItem(TargetPropertiesDialog.this.defaultPermission);
                } else {
                    TargetPropertiesDialog.this.myIsShouldDispose = false;
                    return Collections.EMPTY_LIST;
                }
            }
            String alias = TargetPropertiesDialog.this.aliasFld.getText();
            String name = TargetPropertiesDialog.this.nameFld.getText();
            HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>();
            if (alias != null && !alias.equals(TargetPropertiesDialog.this.targetNode.getAlias())) {
                params.put(ClientParameterCode.TARGET_ALIAS, alias);
            }
            if (name != null && !name.equals(TargetPropertiesDialog.this.targetNode.getName())) {
                params.put(ClientParameterCode.TARGET_NAME, name);
            }
            if (!(vsName = TargetPropertiesDialog.this.exposedOnVSwitchFld.getSelectedItem().toString()).equalsIgnoreCase(TargetPropertiesDialog.this.targetNode.getExposedOnVSwitchName())) {
                params.put(ClientParameterCode.TARGET_EXPOSED_ON, vsName);
            }
            if (!(validator = new CredentialsValidator(userName = TargetPropertiesDialog.this.userNameFld.getText().trim(), password = new String(TargetPropertiesDialog.this.passwordFld.getPassword()), false)).isValidForCreation()) {
                retVal.add(new FailedFuture(new IllegalValueException(validator.getErrorMessage()), "TargetProperies.OKAction"));
                return retVal;
            }
            if (!userName.equalsIgnoreCase(TargetPropertiesDialog.this.targetNode.getUserName())) {
                params.put(ClientParameterCode.TARGET_USER_NAME, userName);
            }
            if (password.length() > 0) {
                params.put(ClientParameterCode.TARGET_PASSWORD, password);
            }
            if (!params.isEmpty()) {
                retVal.add(ClientAOImpl.getInstance().changeElements(Collections.singleton(TargetPropertiesDialog.this.targetNode.getIdentifier()), params));
            }
            return retVal;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public TargetPropertiesDialog(JFrame owner, TargetNode node) {
        super(owner, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_TITLE), false, SystemRootNode.getInstance().getClusterNodeOfSource(node));
        this.targetNode = node;
        this.luNum = node.getLuCount();
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TargetPropertiesDialog.this.targetNode.setUserObject(null);
            }
        });
        TargetManager.getInstance().addTargetListener(this);
        LUManager.getInstance().addLUListener(this);
        this.fixSizes();
        this.pack();
        this.setOKAction(this.myOKAction);
    }

    private void fixSizes() {
        Dimension dim = this.m_numOfSCSIPortsLblKey.getPreferredSize();
        this.exposedOnVSwitchLbl.setPreferredSize(dim);
        this.aliasLabel.setPreferredSize(dim);
        this.nameLbl.setPreferredSize(dim);
        this.luLbl.setPreferredSize(dim);
        this.defAccessLbl.setPreferredSize(dim);
        this.m_portNameLblKey.setPreferredSize(dim);
        this.m_statusLblKey.setPreferredSize(dim);
        dim = new Dimension(70, this.exposedOnVSwitchFld.getPreferredSize().height);
        this.nameFld.setPreferredSize(dim);
        this.aliasFld.setPreferredSize(dim);
        if (this.exposedOnVSwitchFld.getPreferredSize().width < 70) {
            this.exposedOnVSwitchFld.setPreferredSize(dim);
        }
        if (this.defAccessCbx.getPreferredSize().width < 70) {
            this.defAccessCbx.setPreferredSize(dim);
        }
        dim = this.passwordLbl.getPreferredSize();
        this.userNameLbl.setPreferredSize(dim);
        dim = this.m_lastFailedInitiatorNameLblKey.getPreferredSize();
        this.m_numOfLoginFailuresLblKey.setPreferredSize(dim);
        this.m_lastFailureTimeLblKey.setPreferredSize(dim);
        this.m_lastFailureTypeLblKey.setPreferredSize(dim);
        this.m_lastFailedInitiatorIPLblKey.setPreferredSize(dim);
    }

    private void initComponents() {
        SrTabbedPane tabsPanel = new SrTabbedPane();
        SrPanel generalPanel = this.initGeneralPanel();
        SrPanel authPanel = this.initAuthPanel();
        SrPanel detailsPanel = this.initDetailsPanel();
        this.buttonsPanel.setBackground(LookAndFill.DIALOG_COLOR);
        tabsPanel.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_GENERAL_TAB_CAPTION), generalPanel);
        tabsPanel.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_DETAILS_TAB_CAPTION), detailsPanel);
        tabsPanel.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_AUTHENTICATION_TAB_CAPTION), authPanel);
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)tabsPanel, "Center");
        this.addCenterPanel(mainPanel);
    }

    private SrPanel initDetailsPanel() {
        SrPanel detailsPanel = new SrPanel(new GridLayout(5, 1));
        SrPanel numOfLoginFailuresPanel = new SrPanel(new FlowLayout(0));
        this.m_numOfLoginFailuresLblKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_DETAILS_TAB_NUM_OF_LOGIN_FAILURES));
        this.m_numOfLoginFailuresVal = new SrTextField(20);
        this.m_numOfLoginFailuresVal.setText(String.valueOf(this.targetNode.getNumberOfLoginFailure()));
        this.m_numOfLoginFailuresVal.setEnabled(false);
        numOfLoginFailuresPanel.add(this.m_numOfLoginFailuresLblKey);
        numOfLoginFailuresPanel.add(this.m_numOfLoginFailuresVal);
        detailsPanel.add(numOfLoginFailuresPanel);
        String timeVal = this.targetNode.getNumberOfLoginFailure() > 0 ? this.targetNode.getLastLoginFailureTime() : ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
        SrPanel lastFailureTimePanel = new SrPanel(new FlowLayout(0));
        this.m_lastFailureTimeLblKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_DETAILS_TAB_LAST_FAILURE_TIME));
        this.m_lastFailureTimeVal = new SrTextField(20);
        this.m_lastFailureTimeVal.setText(timeVal);
        this.m_lastFailureTimeVal.setEnabled(false);
        lastFailureTimePanel.add(this.m_lastFailureTimeLblKey);
        lastFailureTimePanel.add(this.m_lastFailureTimeVal);
        detailsPanel.add(lastFailureTimePanel);
        SrPanel lastFailureTypePanel = new SrPanel(new FlowLayout(0));
        this.m_lastFailureTypeLblKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_DETAILS_TAB_LAST_FAILURE_TYPE));
        this.m_lastFailureTypeVal = new SrTextField(20);
        this.m_lastFailureTypeVal.setText(this.targetNode.getLastLoginFailureType().toDisplayString());
        this.m_lastFailureTypeVal.setEnabled(false);
        lastFailureTypePanel.add(this.m_lastFailureTypeLblKey);
        lastFailureTypePanel.add(this.m_lastFailureTypeVal);
        detailsPanel.add(lastFailureTypePanel);
        SrPanel lastFailedInitiatorNamePanel = new SrPanel(new FlowLayout(0));
        this.m_lastFailedInitiatorNameLblKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_DETAILS_TAB_LAST_FAILED_INITIATOR_NAME));
        this.m_lastFailedInitiatorNameVal = new SrTextField(20);
        this.m_lastFailedInitiatorNameVal.setText(this.targetNode.getLastLoginFailureInitiatorName());
        this.m_lastFailedInitiatorNameVal.setEnabled(false);
        lastFailedInitiatorNamePanel.add(this.m_lastFailedInitiatorNameLblKey);
        lastFailedInitiatorNamePanel.add(this.m_lastFailedInitiatorNameVal);
        detailsPanel.add(lastFailedInitiatorNamePanel);
        SrPanel lastFailedInitiatorIPPanel = new SrPanel(new FlowLayout(0));
        this.m_lastFailedInitiatorIPLblKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_DETAILS_TAB_LAST_FAILED_INITIATOR_IP));
        this.m_lastFailedInitiatorIPVal = new SrTextField(20);
        this.m_lastFailedInitiatorIPVal.setText(this.targetNode.getLastLoginFailureInitiatorIP());
        this.m_lastFailedInitiatorIPVal.setEnabled(false);
        lastFailedInitiatorIPPanel.add(this.m_lastFailedInitiatorIPLblKey);
        lastFailedInitiatorIPPanel.add(this.m_lastFailedInitiatorIPVal);
        detailsPanel.add(lastFailedInitiatorIPPanel);
        return detailsPanel;
    }

    private SrPanel initGeneralPanel() {
        SrPanel generalPanel = new SrPanel(new GridLayout(8, 1));
        SrPanel aliasPanel = new SrPanel();
        FlowLayout flowLayout = new FlowLayout(0);
        aliasPanel.setLayout(flowLayout);
        this.aliasLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_GENERAL_TAB_ALIAS));
        this.aliasFld = new SrTextField(15);
        this.aliasFld.setText(this.targetNode.getAlias());
        aliasPanel.add(this.aliasLabel);
        aliasPanel.add(this.aliasFld);
        generalPanel.add(aliasPanel);
        SrPanel namePanel = new SrPanel();
        namePanel.setLayout(new FlowLayout(0));
        this.nameLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_GENERAL_TAB_NAME));
        this.nameFld = new SrTextField(15);
        namePanel.add(this.nameLbl);
        namePanel.add(this.nameFld);
        this.nameFld.setText(this.targetNode.getName());
        this.nameFld.setEnabled(false);
        generalPanel.add(namePanel);
        SrPanel statusPanel = new SrPanel(new FlowLayout(0));
        this.m_statusLblKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_GENERAL_TAB_STATUS));
        this.m_statusLblVal = new SrTextField(15);
        this.m_statusLblVal.setText(String.valueOf(this.targetNode.getTargetStatus()));
        this.m_statusLblVal.setEnabled(false);
        statusPanel.add(this.m_statusLblKey);
        statusPanel.add(this.m_statusLblVal);
        generalPanel.add(statusPanel);
        SrPanel lPanel = new SrPanel(new FlowLayout(0));
        this.luLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_GENERAL_TAB_NUM_OF_LUS));
        this.realLULbl = new SrTextField(15);
        this.realLULbl.setText("" + this.luNum);
        this.realLULbl.setEnabled(false);
        lPanel.add(this.luLbl);
        lPanel.add(this.realLULbl);
        generalPanel.add(lPanel);
        String[] args = new String[]{ClientLoader.VSWITCH_DISPLAY_STRING};
        this.exposedOnVSwitchLbl = new SrClientLabel(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_GENERAL_TAB_EXPOSED_ON, args));
        Vector<VSwitchNode> vs = VSwitchManager.getInstance().getAvailableVSwitches(SystemRootNode.getInstance().getCurrentClusterNode());
        this.exposedOnVSwitchFld = new SrComboBox<VSwitchNode>((List<VSwitchNode>)vs);
        String exposedOn = this.targetNode.getExposedOnVSwitchName();
        this.setVSwitchSelected(exposedOn);
        SrPanel panel = this.createSrPanel(this.exposedOnVSwitchLbl, this.exposedOnVSwitchFld);
        this.defAccessLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_GENERAL_TAB_ACCESS));
        this.defAccessCbx = new SrComboBox<Permission>((T[])this.permissions);
        this.defAccessCbx.setFont(LookAndFill.GENERAL_FONT);
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.targetNode);
        PolicyManager policyMgr = clusterNode.getPolicyManager();
        Vector<AclEntryNode> entries = policyMgr.getAcl(this.targetNode).getAclEntries();
        if (!entries.isEmpty()) {
            AclEntryNode entry = entries.get(0);
            Permission access = entry.getPermission();
            this.defAccessCbx.setSelectedItem(access);
            this.defaultPermission = access;
        }
        SrPanel defAccessPanel = this.createSrPanel(this.defAccessLbl, this.defAccessCbx);
        generalPanel.add(panel);
        generalPanel.add(defAccessPanel);
        SrPanel numOfSCSIPortsPanel = new SrPanel(new FlowLayout(0));
        this.m_numOfSCSIPortsLblKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_GENERAL_TAB_NUM_OF_SCSI_PORTS));
        this.m_numOfSCSIPortsVal = new SrTextField(15);
        this.m_numOfSCSIPortsVal.setText("1");
        this.m_numOfSCSIPortsVal.setEnabled(false);
        numOfSCSIPortsPanel.add(this.m_numOfSCSIPortsLblKey);
        numOfSCSIPortsPanel.add(this.m_numOfSCSIPortsVal);
        generalPanel.add(numOfSCSIPortsPanel);
        SrPanel portNamePanel = new SrPanel(new FlowLayout(0));
        this.m_portNameLblKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_GENERAL_TAB_PORT_NAME));
        this.m_portNameVal = new SrTextField(15);
        this.m_portNameVal.setText(this.targetNode.getSCSIPort() != null ? this.targetNode.getSCSIPort().getName() : "");
        this.m_portNameVal.setEnabled(false);
        portNamePanel.add(this.m_portNameLblKey);
        portNamePanel.add(this.m_portNameVal);
        generalPanel.add(portNamePanel);
        return generalPanel;
    }

    private SrPanel initAuthPanel() {
        SrPanel authPanel = new SrPanel();
        authPanel.setLayout(new GridLayout(3, 1));
        SrPanel userPassPanel = new SrPanel();
        userPassPanel.setLayout(new GridLayout(2, 1));
        String[] args = new String[]{Integer.toString(CredentialsValidator.MIN_PASSWORD_LENGTH), Integer.toString(CredentialsValidator.MAX_PASSWORD_LENGTH)};
        String passwordLabelText = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_AUTHENTICATION_TAB_PASSWORD, args);
        this.passwordLbl = new SrClientLabel(passwordLabelText);
        this.passwordFld = new SrPasswordTextField(15);
        SrPanel passwordPanel = this.createSrPanel(this.passwordLbl, this.passwordFld);
        this.userNameLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_AUTHENTICATION_TAB_USER_NAME));
        this.userNameFld = new SrTextField(15);
        this.userNameFld.setText(this.targetNode.getUserName());
        SrPanel userNamePanel = this.createSrPanel(this.userNameLbl, this.userNameFld);
        userPassPanel.add(userNamePanel);
        userPassPanel.add(passwordPanel);
        SrMultiLineLabel explanatoryTextLbl = new SrMultiLineLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_PROPERTIES_DIALOG_AUTHENTICATION_TAB_EXPLANATORY_TEXT));
        authPanel.add(explanatoryTextLbl);
        authPanel.add(userPassPanel);
        authPanel.add(new SrPanel());
        return authPanel;
    }

    @Override
    public void addListeners() {
        TargetManager.getInstance().addTargetListener(this);
        LUManager.getInstance().addLUListener(this);
    }

    @Override
    public void removeListeners() {
        TargetManager.getInstance().removeTargetListener(this);
        LUManager.getInstance().removeLUListener(this);
    }

    private void setVSwitchSelected(String exposedOn) {
        int size = this.exposedOnVSwitchFld.getItemCount();
        for (int i = 0; i < size; ++i) {
            VSwitchNode vsNode = (VSwitchNode)this.exposedOnVSwitchFld.getItemAt(i);
            if (!vsNode.getName().equalsIgnoreCase(exposedOn)) continue;
            this.exposedOnVSwitchFld.setSelectedIndex(i);
            return;
        }
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
        this.targetNode.setUserObject(null);
    }

    @Override
    public void dispose() {
        this.targetNode.setUserObject(null);
        super.dispose();
    }

    @Override
    public void luRemoved(LUEvent event) {
        this.luNum = this.targetNode.getLuCount();
        this.realLULbl.setText("" + this.luNum);
        if (this.luNum > 0) {
            this.nameFld.setEnabled(false);
        }
    }

    @Override
    public void luCreated(LUEvent event) {
        this.luNum = this.targetNode.getLuCount();
        this.realLULbl.setText("" + this.luNum);
        if (this.luNum > 0) {
            this.nameFld.setEnabled(false);
        }
    }

    @Override
    public void luChanged(LUEvent event) {
    }

    @Override
    public void luStatusChanged(LUEvent event) {
    }

    @Override
    public void newTargetCreate(TargetEvent e) {
    }

    @Override
    public void targetRemove(TargetEvent e) {
        if (e.getStub().equals(this.targetNode.getStub())) {
            theLogger.trace(SrLogCategories.LEGACY, "The target was removed, properties are not valid");
            this.dispose();
        }
    }

    @Override
    public void targetStatusCanged(TargetEvent e) {
    }

    @Override
    public void targetAliasChanged(TargetEvent e) {
        if (e.getStub().equals(this.targetNode.getStub())) {
            theLogger.trace(SrLogCategories.LEGACY, "The target alias changed, changing alias in dialog");
            this.aliasFld.setText(e.getAlias());
            this.repaint();
        }
    }

    @Override
    public void targetVSwitchNameChanged(TargetEvent e) {
        if (e.getStub().equals(this.targetNode.getStub())) {
            theLogger.trace(SrLogCategories.LEGACY, "The target vswitch name changed, changing name in dialog");
            this.setVSwitchSelected(this.targetNode.getExposedOnVSwitchName());
            this.repaint();
        }
    }

    @Override
    public void targetNameChanged(TargetEvent e) {
        if (e.getStub().equals(this.targetNode.getStub())) {
            theLogger.trace(SrLogCategories.LEGACY, "The target name changed");
            this.nameFld.setText(e.getName());
            this.repaint();
        }
    }

    @Override
    public void targetUserNameChanged(TargetEvent e) {
    }
}

