/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.target.dialogs;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class NewTargetDialog
extends SrOKCancelDialog {
    private static SrLogger theLogger = SrLogger.getLogger();
    private SrTextField aliasFld;
    private SrTextField nameFld;
    private SrClientLabel aliasLabel;
    private SrClientLabel nameLbl;
    private SrClientLabel defAccessLbl;
    private SrClientLabel vswitchLbl;
    private SrComboBox<VSwitchNode> vswitchCombo;
    private static final Permission[] permissions = new Permission[]{Permission.READ_WRITE, Permission.N_A, Permission.READ_ONLY};
    private SrComboBox<Permission> defAccessCombo = new SrComboBox<Permission>((T[])permissions);
    private SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String targetAlias = NewTargetDialog.this.aliasFld.getText();
            String targetName = NewTargetDialog.this.nameFld.getText();
            VSwitchNode selectedVswitch = (VSwitchNode)NewTargetDialog.this.vswitchCombo.getSelectedItem();
            Permission defaultAccess = (Permission)NewTargetDialog.this.defAccessCombo.getSelectedItem();
            if (!targetName.equals("") && selectedVswitch != null) {
                StringBuffer sb = new StringBuffer();
                sb.append("NewTargetDialog: creating new target: ");
                sb.append("target alias: ");
                sb.append(targetAlias);
                sb.append(", target name: ");
                sb.append(targetName);
                sb.append(", ");
                sb.append(ClientLoader.VSWITCH_DISPLAY_STRING);
                sb.append(": ");
                sb.append(selectedVswitch.toString());
                theLogger.trace(SrLogCategories.LEGACY, sb);
                StringBuffer msg = new StringBuffer("The target name ");
                if (!TargetManager.getInstance().isTargetNameLegal(targetName, msg)) {
                    return Collections.singleton(new FailedFuture(new IllegalValueException(msg.toString()), "NewTargetDialog.OKAction, illegal name"));
                }
                ClusterNode cluster = NewTargetDialog.this.m_workingCluster != null ? NewTargetDialog.this.m_workingCluster : SystemRootNode.getInstance().getCurrentClusterNode();
                return Collections.singleton(TargetManager.getInstance().createISCSITarget(targetName, targetAlias, selectedVswitch.toString(), defaultAccess, cluster));
            }
            return Collections.singleton(new FailedFuture(new IllegalValueException("The Target name is mandatory. "), "NewTargetDialog.OKAction, empty name"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public NewTargetDialog(JFrame owner, ClusterNode workingCluster) {
        super(owner, "New Target", workingCluster);
        this.init();
    }

    public NewTargetDialog(JDialog owner, ClusterNode workingCluster) {
        super(owner, "New Target", workingCluster);
        this.init();
    }

    private void init() {
        this.initComponents();
        this.fixSizes();
        this.setSizeAndMoveToCenter(370, 240);
        this.setOKAction(this.myOKAction);
        this.show();
    }

    private void fixSizes() {
        Dimension dim = this.vswitchLbl.getPreferredSize();
        this.aliasLabel.setPreferredSize(dim);
        this.nameLbl.setPreferredSize(dim);
        this.defAccessLbl.setPreferredSize(dim);
    }

    private void initComponents() {
        this.initNorthPanel();
        this.initCenterPanel();
        this.buttonsPanel.setBackground(LookAndFill.DIALOG_COLOR);
    }

    private void initNorthPanel() {
        SrPanel northPanel = new SrPanel();
        northPanel.setLayout(new GridLayout(2, 1, 1, 1));
        SrPanel aliasPanel = new SrPanel();
        FlowLayout flowLayout = new FlowLayout(0);
        aliasPanel.setLayout(flowLayout);
        this.aliasLabel = new SrClientLabel("Target Alias: ");
        this.aliasFld = new SrTextField(15);
        aliasPanel.add(this.aliasLabel);
        aliasPanel.add(this.aliasFld);
        northPanel.add(aliasPanel);
        SrPanel namePanel = new SrPanel();
        namePanel.setLayout(new FlowLayout(0));
        this.nameLbl = new SrClientLabel("Target Name: ");
        this.nameFld = new SrTextField(15);
        namePanel.add(this.nameLbl);
        namePanel.add(this.nameFld);
        northPanel.add(namePanel);
        this.getContentPane().add((Component)northPanel, "North");
    }

    protected void initCenterPanel() {
        SrPanel centerPanel = new SrPanel();
        centerPanel.setLayout(new BorderLayout());
        SrPanel innerPanel = new SrPanel();
        innerPanel.setLayout(new GridLayout(2, 1));
        this.vswitchLbl = new SrClientLabel(ClientLoader.VSWITCH_DISPLAY_STRING + " Exposed on: ");
        ClusterNode clusterNode = this.m_workingCluster != null ? this.m_workingCluster : SystemRootNode.getInstance().getCurrentClusterNode();
        Vector<VSwitchNode> vs = VSwitchManager.getInstance().getAvailableVSwitches(clusterNode);
        this.vswitchCombo = new SrComboBox<VSwitchNode>((List<VSwitchNode>)vs);
        SrPanel panel = this.createSrPanel(this.vswitchLbl, this.vswitchCombo);
        this.defAccessLbl = new SrClientLabel("Default Access: ");
        SrPanel defAccessPanel = this.createSrPanel(this.defAccessLbl, this.defAccessCombo);
        innerPanel.add(panel);
        innerPanel.add(defAccessPanel);
        centerPanel.add((Component)innerPanel, "Center");
        this.getContentPane().add((Component)centerPanel, "Center");
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    @Override
    public void removeListeners() {
    }
}

