/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.target;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.target.TargetTableModelCollection;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrExposedVolumeTreePanel;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.target.SrTargetTablePanel;
import com.sanrad.nms.client.gui.target.TargetDetailsViewPanel;
import com.sanrad.nms.client.gui.target.TargetTableViewPanel;
import com.sanrad.swing.DetailsViewPanel;
import com.sanrad.swing.ElementViewPanel;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.TableViewPanel;

public class TargetViewPanel
extends ElementViewPanel {
    private TargetTableViewPanel targetTableViewPanel;
    private TargetDetailsViewPanel targetDetailsViewPanel;

    public TargetViewPanel(MainFrame owner, SrMainTreePanel mainTreePanel) {
        this.targetTableViewPanel = new TargetTableViewPanel(owner);
        this.targetDetailsViewPanel = new TargetDetailsViewPanel(owner, mainTreePanel);
        this.addTablePanel(this.targetTableViewPanel);
        this.addDetailsPanel(this.targetDetailsViewPanel);
        this.setDividerLocation(450);
    }

    @Override
    public TableViewPanel getTableViewPanel() {
        return this.targetTableViewPanel;
    }

    @Override
    public DetailsViewPanel getDetailsViewPanel() {
        return this.targetDetailsViewPanel;
    }

    public void setTargetNode(TargetNode aNode) {
        this.targetTableViewPanel.setTargetNode(aNode);
    }

    public void clear(ClusterNode clusterNode) {
        TargetTableModelCollection.getInstance().clearModelOf(clusterNode);
        this.targetDetailsViewPanel.clear();
    }

    public void newClusterHasBeenSelected() {
        this.targetTableViewPanel.newClusterHasBeenSelected();
        this.targetDetailsViewPanel.newClusterHasBeenSelected();
    }

    void volumeTableSelectionChanged(VolumeTreeNode[] selectedVolumes) {
        SrExposedVolumeTreePanel treePanel = (SrExposedVolumeTreePanel)SrSwingUtils.getChildOfType(SrExposedVolumeTreePanel.class, this);
        treePanel.updateTree(selectedVolumes);
    }

    @Override
    public void removeNotify() {
        SrTargetTablePanel tablePanel = (SrTargetTablePanel)SrSwingUtils.getChildOfType(SrTargetTablePanel.class, this);
        tablePanel.getTable().clearSelection();
        super.removeNotify();
    }
}

