/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupNode;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.SrPopupMenu;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.actions.target.TargetActions;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.actions.TreeView;
import com.sanrad.swing.components.SrCheckBoxMenuItem;
import com.sanrad.swing.components.SrMenu;
import com.sanrad.swing.components.SrMenuItem;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ButtonGroup;

public class TargetPopupMenu
extends SrPopupMenu {
    private static final SrLogger theLogger = SrLogger.getLogger();

    public TargetPopupMenu(SrMainTreePanel workWith) {
        super(workWith);
        this.createIscsiMenu();
        this.addSeparator();
        this.add(this.createScsiMenu());
        this.addSeparator();
        this.add(this.m_iscsiSessionsMenu);
        this.add(this.m_iscsiConnectionsItem);
        this.add(this.m_iscsiConnectedInitiatorsMenu);
        this.addSeparator();
        SrMenu qosMenu = this.createQosMenu();
        SrCheckBoxMenuItem lowQosMenuItem = this.createLowQosMenuItem();
        SrCheckBoxMenuItem highQosMenuItem = this.createHighQosMenuItem();
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(lowQosMenuItem);
        bGroup.add(highQosMenuItem);
        qosMenu.add(highQosMenuItem);
        qosMenu.add(lowQosMenuItem);
        this.add(qosMenu);
        this.addSeparator();
        this.add(this.alarmsMenu);
        this.addSeparator();
        this.add(this.getDeleteItem());
        this.addSeparator();
        this.add(TargetPopupMenu.createPropertiesItem(this.myWorkWith.targetPropertiesAction));
    }

    protected void createIscsiMenu() {
        this.m_iscsiSessionsMenu.add(this.m_iscsiSessionsShowItem);
        this.m_iscsiSessionsMenu.add(this.m_iscsiSessionsStatisticsItem);
        this.m_iscsiConnectedInitiatorsMenu.add(this.m_iscsiConnectedInitiatorsShowItem);
        this.m_iscsiConnectedInitiatorsMenu.add(this.m_iscsiConnectedInitiatorsStatisticsItem);
    }

    protected SrMenu createScsiMenu() {
        SrMenu scsiTargetPortMenu = new SrMenu(new SrClientAction<TargetNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_SCSI_PORT), true, true, new TreeView<TargetNode>(this.myWorkWith.getTreeObject(), TargetNode.class), SrLicenseTreePath.GENERAL_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<TargetNode> arg) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "Running empty actions is not supported");
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource((SrTreeNode)this.myView.getValue().iterator().next());
                for (VSwitchNode vswitchNode : clusterNode.getVSwitches()) {
                    if (!vswitchNode.isConnected()) continue;
                    return null;
                }
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.CLUSTER_NO_CONNECTED_VSWITCHES, clusterNode.getAlias());
            }
        });
        SrMenuItem scsiTargetPortStatisticsItem = new SrMenuItem(this.myWorkWith.openScsiTargetPortsStatisticsAction);
        scsiTargetPortMenu.add(scsiTargetPortStatisticsItem);
        return scsiTargetPortMenu;
    }

    @Override
    public AlarmAction getSpecificAlarmAction() {
        return this.myWorkWith.myOpenSpecificAlarmsAction;
    }

    @Override
    public AlarmAction getPropagatedAlarmAction() {
        return this.myWorkWith.myOpenPropagatedAlarmsAction;
    }

    @Override
    protected DeleteAction getDeleteAction() {
        return this.myWorkWith.myDeleteTargetAction;
    }

    @Override
    protected void innerReset() {
    }

    private SrCheckBoxMenuItem createLowQosMenuItem() {
        return new SrCheckBoxMenuItem(TargetActions.getInstance().getSetLowQosAction());
    }

    private SrCheckBoxMenuItem createHighQosMenuItem() {
        return new SrCheckBoxMenuItem(TargetActions.getInstance().getSetHighQosAction());
    }

    private SrMenu createQosMenu() {
        SrClientAction<TargetNode, Void> a = new SrClientAction<TargetNode, Void>("QoS", true, true, new TreeView<TargetNode>(this.myWorkWith.getTreeObject(), TargetNode.class), SrLicenseTreePath.GENERAL_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<TargetNode> arg) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "Running empty actions is not supported");
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                TargetNode target = (TargetNode)this.myView.getValue().iterator().next();
                if (!TargetPopupMenu.this.isTargetVswitchConnected(target)) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VSWITCH_DISCONNECTED);
                }
                TargetQosGroupNode qosGroup = TargetQosGroupsManager.getInstance().getQosGroup(target.getExposedOnVSwitchNode());
                if (qosGroup == null) {
                    return "QoS not available";
                }
                return null;
            }
        };
        return new SrMenu(a);
    }

    private boolean isTargetVswitchConnected(TargetNode aTarget) {
        VSwitchNode expsoedOnVs = aTarget.getExposedOnVSwitchNode();
        return expsoedOnVs != null && expsoedOnVs.isConnected();
    }
}

