/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.target;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.SrExposedVolumeTreeModel;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrExposedVolumeTreePanel;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.acl.AclViewPanel;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.target.TargetActions;
import com.sanrad.swing.DetailsViewPanel;
import com.sanrad.swing.SrSplitPane;
import com.sanrad.swing.components.SrRadioButtonsPanel;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class TargetDetailsViewPanel
extends DetailsViewPanel {
    private static final String QOS_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TARGET_QOS_TITLE);
    private MainFrame myMainFrame;
    private SrExposedVolumeTreePanel volumesDetailsViewPanel;
    private AclViewPanel aclTablePanel;

    public TargetDetailsViewPanel(MainFrame aMainFrame, SrMainTreePanel mainTreePanel) {
        this.myMainFrame = aMainFrame;
        this.setBorder(null);
        this.setOpaque(false);
        this.aclTablePanel = new AclViewPanel(mainTreePanel);
        this.aclTablePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        final SrSplitPane split1 = new SrSplitPane(0);
        split1.setTopComponent(this.createVolumeTreeDetailsPanel());
        split1.setBottomComponent(this.aclTablePanel);
        split1.setOpaque(false);
        final SrSplitPane split2 = new SrSplitPane(0);
        split2.setTopComponent(split1);
        split2.setBottomComponent(this.createQosViewPanel());
        this.add((Component)split2, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                split1.setDividerLocation(TargetDetailsViewPanel.this.getSize().height / 3);
                split2.setDividerLocation(TargetDetailsViewPanel.this.getSize().height * 2 / 3);
            }
        });
    }

    public void newClusterHasBeenSelected() {
        this.volumesDetailsViewPanel.newClusterHasBeenSelected();
        this.aclTablePanel.newClusterHasBeenSelected();
    }

    public void clear() {
        this.aclTablePanel.clear();
    }

    private DetailsViewPanel createQosViewPanel() {
        SrRadioButtonsPanel radioButtonsPanel = new SrRadioButtonsPanel();
        SrClientAction<TargetNode, Void> lowQosAction = TargetActions.getInstance().getSetLowQosAction();
        SrClientAction<TargetNode, Void> highQosAction = TargetActions.getInstance().getSetHighQosAction();
        radioButtonsPanel.addRadio(highQosAction, highQosAction.getValue("Name"));
        radioButtonsPanel.addRadio(lowQosAction, lowQosAction.getValue("Name"));
        DetailsViewPanel viewPanel = new DetailsViewPanel(QOS_TITLE);
        viewPanel.add((Component)radioButtonsPanel, "Center");
        return viewPanel;
    }

    private DetailsViewPanel createVolumeTreeDetailsPanel() {
        DetailsViewPanel viewPanel = new DetailsViewPanel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.VOLUMES_DETAILS_LABEL));
        this.volumesDetailsViewPanel = new SrExposedVolumeTreePanel(new SrExposedVolumeTreeModel(), (JFrame)this.myMainFrame);
        viewPanel.add((Component)this.volumesDetailsViewPanel, "Center");
        return viewPanel;
    }
}

