/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.target;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.target.SrTargetTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.target.TargetTableModelCollection;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionAdapter;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionEvent;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SynchronizeElementAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.actions.delete.UnexposeAction;
import com.sanrad.nms.client.gui.actions.delete.UnexposeAllTreeAction;
import com.sanrad.nms.client.gui.target.TargetTableHeader;
import com.sanrad.nms.client.gui.target.TargetViewPanel;
import com.sanrad.nms.client.gui.volume.ExposedVolumeCellRenderer;
import com.sanrad.nms.client.gui.volume.ExposedVolumesTableHeader;
import com.sanrad.nms.client.gui.volume.LUTableCellRenderer;
import com.sanrad.nms.client.gui.volume.SrExposedVolumePopupMenu;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SrTargetTablePanel
extends SrClientTablePanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    private JFrame m_owner;
    private LUSelectionAdapter m_luAdapter = new LUSelectionAdapter();
    private View<LUNode> myLUNodeView = new SrTableView<LUNode>((JTable)this.m_table){

        @Override
        public Collection<LUNode> getValue() {
            return Arrays.asList(SrTargetTablePanel.this.getSelectedLus());
        }
    };
    private AlarmAction myOpenSpecificAlarmsAction = new AlarmAction<LUNode>(this.myLUNodeView, true);
    private AlarmAction myOpenPropagatedAlarms = new AlarmAction<LUNode>(this.myLUNodeView, false);
    private final DeleteAction myDeleteAction = new UnexposeAction(this.myLUNodeView, (OperationController)StatusPanel.getInstance());
    private final DeleteAction myUnexposeAction = new UnexposeAllTreeAction(this.myLUNodeView, (OperationController)StatusPanel.getInstance());

    public SrTargetTablePanel(SrTargetTableModel model, JFrame owner) {
        super(model);
        this.m_owner = owner;
        this.setSelectionMode(2);
        AlarmsManager.getInstance().addAlarmSourceSelectionListener(this.m_luAdapter);
        SrExposedVolumePopupMenu popup = new SrExposedVolumePopupMenu(this, this.myLUNodeView, owner, this.myDeleteAction, this.myUnexposeAction, this.myOpenPropagatedAlarms, this.myOpenSpecificAlarmsAction);
        this.setTablePopUpMenuObject(popup);
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SrTargetTablePanel.this.updateTree();
                }
            }
        });
        final TableModelListener tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                SrTargetTablePanel.this.updateTree();
            }
        };
        this.getTable().getModel().addTableModelListener(tableModelListener);
        this.getTable().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent aEvt) {
                if (aEvt.getPropertyName().equals("model")) {
                    ((TableModel)aEvt.getOldValue()).removeTableModelListener(tableModelListener);
                    SrTargetTablePanel.this.getTable().getModel().addTableModelListener(tableModelListener);
                }
            }
        });
        int volumeIndexInModel = TargetTableHeader.VOLUME_NAME.getIndexInModel();
        int storageIndexInModel = TargetTableHeader.STORAGE_NAME.getIndexInModel();
        int luIndexInModel = TargetTableHeader.LUN.getIndexInModel();
        this.getTable().getColumnModel().getColumn(volumeIndexInModel).setCellRenderer(new ExposedVolumeCellRenderer(ExposedVolumesTableHeader.LUN.getColumnName()));
        this.getTable().getColumnModel().getColumn(storageIndexInModel).setCellRenderer(new ExposedVolumeCellRenderer(ExposedVolumesTableHeader.LUN.getColumnName()));
        this.getTable().getColumnModel().getColumn(luIndexInModel).setCellRenderer(new LUTableCellRenderer());
    }

    @Override
    protected Class getTableHeaderClass() {
        return TargetTableHeader.class;
    }

    @Override
    public void removeListeners() {
        AlarmsManager.getInstance().removeAlarmSourceSelectionListener(this.m_luAdapter);
    }

    protected void finalize() throws Throwable {
        this.removeListeners();
        super.finalize();
    }

    private VolumeTreeNode[] getSelectedVolumes() {
        int[] selectedRows = this.getSelectedRows();
        Vector<VolumeTreeNode> volumes = new Vector<VolumeTreeNode>(selectedRows.length);
        int col = this.getModel().getColumnIndex(TargetTableHeader.VOLUME_NAME.getColumnName());
        for (int i = 0; i < selectedRows.length; ++i) {
            if (selectedRows[i] >= this.getModel().getRowCount()) continue;
            VolumeTreeNode volumeNode = (VolumeTreeNode)this.getModel().getValueAt(selectedRows[i], col);
            volumes.add(volumeNode);
        }
        return volumes.toArray(new VolumeTreeNode[volumes.size()]);
    }

    public void setTargetNode(TargetNode aTargetNode) {
        SrTargetTableModel tableModel = (SrTargetTableModel)TargetTableModelCollection.getInstance().getModel((RemoteObject)SystemRootNode.getInstance().getClusterNodeOfSource(aTargetNode).getStub());
        tableModel.setTargetNode(aTargetNode);
        this.getTable().clearSelection();
        this.setModel(tableModel);
        this.repaint();
    }

    public void setModel(SrTargetTableModel tableModel) {
        super.setModel(tableModel);
        TableModelEvent event = new TableModelEvent(tableModel);
        tableModel.fireTableChanged(event);
    }

    public void selectSelectedRows() {
        Integer[] selectedRows = ((SrTargetTableModel)this.getModel()).getSelectedRowIndices();
        if (selectedRows != null && selectedRows.length > 0) {
            this.setRowSelectionSet(selectedRows[0], selectedRows[selectedRows.length - 1]);
            this.scrollToRow(selectedRows[0]);
        } else {
            this.getTable().clearSelection();
        }
    }

    public SynchronizeElementAction getSynchronizeAction() {
        return null;
    }

    public AlarmAction getSpecificAlarmsAction() {
        return this.myOpenSpecificAlarmsAction;
    }

    public AlarmAction getPropagatedAlarmsAction() {
        return this.myOpenPropagatedAlarms;
    }

    public LUNode[] getSelectedLus() {
        int[] selectedRows = this.getSelectedRows();
        LUNode[] lus = new LUNode[selectedRows.length];
        int col = ((SrTargetTableModel)this.getModel()).getColumnIndex(TargetTableHeader.LUN.getColumnName());
        for (int i = 0; i < selectedRows.length; ++i) {
            lus[i] = (LUNode)this.getModel().getValueAt(selectedRows[i], col);
        }
        return lus;
    }

    private void updateTree() {
        TargetViewPanel parentPanel = (TargetViewPanel)SrSwingUtils.getParentOfType(TargetViewPanel.class, this);
        parentPanel.volumeTableSelectionChanged(this.getSelectedVolumes());
    }

    class LUSelectionAdapter
    extends AlarmSourceSelectionAdapter {
        LUSelectionAdapter() {
        }

        @Override
        public void luSelected(AlarmSourceSelectionEvent e) {
            SrTreeNode selected = e.getNode();
            if (selected != null) {
                LUNode node = (LUNode)selected;
                int col = ((SrTargetTableModel)SrTargetTablePanel.this.getModel()).getColumnIndex(TargetTableHeader.LUN.getColumnName());
                int rowCount = SrTargetTablePanel.this.getTable().getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    LUNode lu = (LUNode)SrTargetTablePanel.this.getModel().getValueAt(i, col);
                    Object stub = lu.getStub();
                    if (!stub.equals(node.getStub())) continue;
                    SrTargetTablePanel.this.setRowSelectionSet(i, i);
                }
            }
        }

        @Override
        public void volumeSelected(AlarmSourceSelectionEvent e) {
            SrTreeNode selected = e.getNode();
            if (selected != null) {
                VolumeTreeNode node = (VolumeTreeNode)selected;
                if (!node.isExposed()) {
                    return;
                }
                while (node.getParent() instanceof VolumeTreeNode) {
                    node = (VolumeTreeNode)node.getParent();
                }
                int col = ((SrTargetTableModel)SrTargetTablePanel.this.getModel()).getColumnIndex(ExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
                int rowCount = SrTargetTablePanel.this.getTable().getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    Object vol = SrTargetTablePanel.this.getModel().getValueAt(i, col);
                    VolumeTreeNode volNode = (VolumeTreeNode)vol;
                    if (!volNode.equals(node)) continue;
                    SrTargetTablePanel.this.setRowSelectionSet(i, i);
                    SrTargetTablePanel.this.rowSelectionChanged(new int[]{i});
                    SrTargetTablePanel.this.setRowSelectionSet(i, i);
                    return;
                }
            }
        }
    }
}

