/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.target;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.target.SCSITargetPortNode;
import com.sanrad.nms.client.data.target.SCSITargetsPortsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.target.SCSITargetsPortsStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticChart;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.target.SCSITargetPort;
import java.util.Date;
import java.util.HashMap;

public class SrSCSITargetPortssStatisticsChart
extends SrStatisticChart
implements SCSITargetsPortsStatisticsListener {
    private static final String SERIES_IN_COMMANDS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SCSI_TARGET_PORTS_CHART_IN_COMMANDS);
    private static final String SERIES_READ_MB = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SCSI_TARGET_PORTS_CHART_READ_MB);
    private static final String SERIES_WRITTEN_MB = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SCSI_TARGET_PORTS_CHART_WRITTEN_MB);
    private SCSITargetPortNode m_targetPort;

    public SrSCSITargetPortssStatisticsChart(int aPollingInterval) {
        super(aPollingInterval);
        SCSITargetsPortsManager.getInstance().addSCSITargetsPortsStatisticsListener(this);
        this.addSeries(SERIES_IN_COMMANDS);
        this.addSeries(SERIES_READ_MB);
        this.addSeries(SERIES_WRITTEN_MB);
    }

    public void setPortDisplay(SCSITargetPortNode portNode) {
        this.m_targetPort = portNode;
    }

    @Override
    public void removeListeners() {
        SCSITargetsPortsManager.getInstance().removeSCSITargetsPortsStatisticsListener(this);
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        SCSITargetPortNode statisticsNode = (SCSITargetPortNode)e.getStatisticsNode();
        if (((SCSITargetPort)this.m_targetPort.getStub()).equals(statisticsNode.getStub())) {
            HashMap changedValsMap = statisticsNode.getChangedValues();
            Long inCommands = (Long)changedValsMap.get(ClientParameterCode.SCSI_TARGET_PORT_IN_COMMANDS_PER_SEC);
            Long readMBs = (Long)changedValsMap.get(ClientParameterCode.SCSI_TARGET_PORT_READ_MB_PER_SEC);
            Long writtenMBs = (Long)changedValsMap.get(ClientParameterCode.SCSI_TARGET_PORT_WRITTEN_MB_PER_SEC);
            Date time = new Date();
            if (inCommands != null) {
                this.setSeriesValue(SERIES_IN_COMMANDS, time, inCommands);
            }
            if (readMBs != null) {
                this.setSeriesValue(SERIES_READ_MB, time, readMBs);
            }
            if (writtenMBs != null) {
                this.setSeriesValue(SERIES_WRITTEN_MB, time, writtenMBs);
            }
        }
    }

    public void iscsiSessionStatisticsCreated(StatisticsEvent e) {
    }

    public void iscsiSessionStatisticsRemoved(StatisticsEvent e) {
    }
}

