/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.target;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.target.SCSITargetPortNode;
import com.sanrad.nms.client.data.target.SCSITargetsPortsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.target.SCSITargetsPortsStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.target.SCSITargetPort;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.util.HashMap;

public class SrSCSITargetPortsStatisticsDetailsPanel
extends SrPanel
implements SCSITargetsPortsStatisticsListener {
    private SrClientLabel m_portNameLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SCSI_TARGET_PORT_TABLE_COLUMN_PORT_NAME));
    private SrClientLabel m_portNameValueLabel = new SrClientLabel("");
    private SrClientLabel m_numOfInCommandsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SCSI_TARGET_PORT_TABLE_COLUMN_IN_COMMANDS));
    private SrClientLabel m_numOfInCommandsValueLabel = new SrClientLabel("");
    private SrClientLabel m_numOfReadMBsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SCSI_TARGET_PORT_TABLE_COLUMN_READ_MBS));
    private SrClientLabel m_numOfReadMBsValueLabel = new SrClientLabel("");
    private SrClientLabel m_numOfWrittenMBsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SCSI_TARGET_PORT_TABLE_COLUMN_WRITTEN_MBS));
    private SrClientLabel m_numOfWrittenMBsValueLabel = new SrClientLabel("");
    private SCSITargetPortNode m_targetPort;

    public SrSCSITargetPortsStatisticsDetailsPanel() {
        SCSITargetsPortsManager.getInstance().addSCSITargetsPortsStatisticsListener(this);
        this.initPanelComponents();
    }

    @Override
    public void removeListeners() {
        SCSITargetsPortsManager.getInstance().removeSCSITargetsPortsStatisticsListener(this);
    }

    private void initPanelComponents() {
        Dimension usedDim = this.setSizesOfComponents();
        this.buildAllPanels(usedDim);
    }

    private Dimension setSizesOfComponents() {
        Dimension dim = this.m_numOfInCommandsLabel.getPreferredSize();
        dim.width += 20;
        this.m_portNameLabel.setPreferredSize(dim);
        this.m_numOfReadMBsLabel.setPreferredSize(dim);
        this.m_numOfReadMBsLabel.setPreferredSize(dim);
        return dim;
    }

    private void buildAllPanels(Dimension usedDim) {
        SrPanel panel = this.buildCountersPanel(usedDim);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 10, 0, 10);
        this.add((Component)panel, c);
    }

    private void addDetailRow(SrPanel panelAll, SrClientLabel label, Color backColor, GridBagConstraints c, int gridx, int gridy, Insets insets) {
        SrPanel panel = new SrPanel(new FlowLayout(0, 0, 0));
        panel.setBackground(backColor);
        c.gridx = gridx;
        c.gridy = gridy;
        if (insets != null) {
            c.insets = insets;
        }
        panel.add(label);
        if (panelAll == null) {
            this.add((Component)panel, c);
        } else {
            panelAll.add((Component)panel, c);
        }
    }

    private SrPanel buildCountersPanel(Dimension usedDim) {
        SrPanel panel = new SrPanel(new GridBagLayout());
        Color whiteBackground = LookAndFill.TABLE_BACKGROUND;
        panel.setBackground(whiteBackground);
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.1;
        c.weightx = 0.3;
        c.anchor = 23;
        c.fill = 1;
        this.addDetailRow(panel, this.m_portNameLabel, whiteBackground, c, 0, 0, new Insets(5, 10, 5, 0));
        this.addDetailRow(panel, this.m_portNameValueLabel, whiteBackground, c, 1, 0, new Insets(5, 0, 5, 10));
        this.addDetailRow(panel, this.m_numOfInCommandsLabel, whiteBackground, c, 0, 1, new Insets(0, 10, 5, 0));
        this.addDetailRow(panel, this.m_numOfReadMBsLabel, whiteBackground, c, 0, 2, null);
        this.addDetailRow(panel, this.m_numOfWrittenMBsLabel, whiteBackground, c, 0, 3, null);
        this.addDetailRow(panel, this.m_numOfInCommandsValueLabel, whiteBackground, c, 1, 1, new Insets(0, 0, 5, 10));
        this.addDetailRow(panel, this.m_numOfReadMBsValueLabel, whiteBackground, c, 1, 2, null);
        this.addDetailRow(panel, this.m_numOfWrittenMBsValueLabel, whiteBackground, c, 1, 3, null);
        return panel;
    }

    private void updateLabelFieldWithVal(HashMap statisticsValues, ClientParameterCode code, SrClientLabel label) {
        Object objVal = statisticsValues.get(code);
        if (objVal != null) {
            String text = ((BigInteger)objVal).toString();
            label.setText(text);
        }
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        SCSITargetPortNode statisticsNode = (SCSITargetPortNode)e.getStatisticsNode();
        if (((SCSITargetPort)this.m_targetPort.getStub()).equals(statisticsNode.getStub())) {
            HashMap statisticsValues = statisticsNode.getChangedValues();
            Object objVal = statisticsValues.get(ClientParameterCode.SCSI_TARGET_PORT_NAME);
            if (objVal != null) {
                String text = (String)objVal;
                this.m_portNameValueLabel.setText(text);
            }
            this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.SCSI_TARGET_PORT_IN_COMMANDS, this.m_numOfInCommandsValueLabel);
            this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.SCSI_TARGET_PORT_READ_MB, this.m_numOfReadMBsValueLabel);
            this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.SCSI_TARGET_PORT_WRITTEN_MB, this.m_numOfWrittenMBsValueLabel);
        }
    }

    public void initValues(SCSITargetPortNode targetPortNode) {
        this.m_targetPort = targetPortNode;
        this.m_portNameValueLabel.setText(targetPortNode.getName());
        this.m_numOfInCommandsValueLabel.setText(targetPortNode.getInCommands().toString());
        this.m_numOfReadMBsValueLabel.setText(targetPortNode.getReadMBs().toString());
        this.m_numOfWrittenMBsValueLabel.setText(targetPortNode.getWrittenMBs().toString());
    }
}

