/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.target;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.data.target.SCSITargetPortNode;
import com.sanrad.nms.client.data.target.SCSITargetsPortsManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.target.SCSITargetsPortsStatisticsListener;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticsDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.target.SrSCSITargetPortsStatisticsDetailsPanel;
import com.sanrad.nms.client.gui.target.SrSCSITargetPortssStatisticsChart;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartPanel;

public class SCSITargetPortsStatisticsDialog
extends SrStatisticsDialog
implements SCSITargetsPortsStatisticsListener,
VSwitchListener {
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SCSI_TARGET_PORT_DIALOG_SPECIFIC_TITLE);
    private TargetNode m_targetNode;
    private SCSITargetPortNode m_targetPortStatistics;

    private static VSwitchNode getExposedNotDisconnectedVS(TargetNode aTarget) {
        VSwitchNode retVal = aTarget.getExposedOnVSwitchNode();
        if (retVal == null) {
            throw new IllegalStateException("The target " + aTarget + " has no exposed on VS.");
        }
        if (retVal.isConnected()) {
            return retVal;
        }
        if ((retVal = retVal.getParentCluster().getOtherVSwitchInCluster(retVal)) != null && retVal.isConnected()) {
            return retVal;
        }
        return null;
    }

    public SCSITargetPortsStatisticsDialog(JFrame owner, TargetNode targetNode) {
        super(owner, "", SCSITargetPortsStatisticsDialog.getExposedNotDisconnectedVS(targetNode), null, 3);
        this.m_targetNode = targetNode;
        this.m_targetPortStatistics = this.m_targetNode.getSCSIPort();
        this.setDialogTitle();
        ((SrSCSITargetPortsStatisticsDetailsPanel)this.m_statisticsDetailsPanel).initValues(this.m_targetPortStatistics);
        ((SrSCSITargetPortssStatisticsChart)this.m_statisticChart).setPortDisplay(this.m_targetPortStatistics);
        this.setLocation(100, 100);
        this.setSize(650, 550);
        SrClientAction.blockActions(this.activateDeactivateStatisticsUpdate(true), this);
    }

    @Override
    public void addListeners() {
        SCSITargetsPortsManager.getInstance().addSCSITargetsPortsStatisticsListener(this);
        VSwitchManager.getInstance().addVSwitchListener(this);
    }

    @Override
    public void removeListeners() {
        super.removeListeners();
        SCSITargetsPortsManager.getInstance().removeSCSITargetsPortsStatisticsListener(this);
        VSwitchManager.getInstance().removeVSwitchListener(this);
        if (this.m_statisticsDetailsPanel != null) {
            ((SrSCSITargetPortsStatisticsDetailsPanel)this.m_statisticsDetailsPanel).removeListeners();
        }
        if (this.m_statisticChart != null) {
            ((SrSCSITargetPortssStatisticsChart)this.m_statisticChart).removeListeners();
        }
    }

    @Override
    public void doOnCancel() {
        SrClientAction.blockActions(this.activateDeactivateStatisticsUpdate(false), this);
    }

    private void setDialogTitle() {
        String titlePrefix = "Target " + this.m_targetNode;
        this.setTitle(titlePrefix + " - " + DIALOG_SPECIFIC_TITLE);
        this.setClusterTitle();
    }

    private Collection<SrFuture<Void>> activateDeactivateStatisticsUpdate(boolean mode) {
        return Collections.singleton(StatisticsManager.activateDeactivateStatistics((CommKeyClassId)this.m_targetPortStatistics.getIdentifier(), mode, (CommKeyClassId)this.m_targetPortStatistics.getParent().getIdentifier()));
    }

    @Override
    protected SrTablePanel getStatisticsTablePanel() {
        return null;
    }

    @Override
    protected SrPanel getStatisticsDetailsPanel() {
        SrSCSITargetPortsStatisticsDetailsPanel panel = new SrSCSITargetPortsStatisticsDetailsPanel();
        return panel;
    }

    @Override
    protected SrTablePanel getStatisticsExtendedTablePanel() {
        return null;
    }

    @Override
    protected ChartPanel getStatisticsChartPanel() {
        this.m_statisticChart = new SrSCSITargetPortssStatisticsChart(this.m_vswitchNode.getStatisticsPollInterval());
        return this.m_statisticChart.packChartToPanel();
    }

    @Override
    protected void initDialogPanels() {
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        this.setLastUpdateTime(new GregorianCalendar());
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        VSwitch vswitchStub = (VSwitch)e.getStub();
        VSwitchNode vSwitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(vswitchStub);
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(vSwitchNode);
        if (clusterNode.isUnderTakeover()) {
            SDTakeOverStateConstant state = vSwitchNode.getTakeoverState();
            if (state == null || state.equals(SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER) && !this.m_targetPortStatistics.getParentStub().equals(vSwitchNode.getStub())) {
                this.closeDialog(clusterNode);
            }
        } else if (clusterNode.allAvailableVSwitchesDisconnected()) {
            this.closeDialog(clusterNode);
        }
    }

    private void showCloseDialogAlert(ClusterNode clusterNode) {
        JOptionPane.showMessageDialog(this, "The cluster " + clusterNode.getAlias() + " is under takeover or has no " + ClientLoader.VSWITCHES_DISPLAY_STRING + " connected.\nThe window will be closed due to update process.", "Alert", 2);
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent e) {
    }

    private void closeDialog(ClusterNode clusterNode) {
        this.showCloseDialogAlert(clusterNode);
        this.doOnCancel();
        this.dispose();
    }
}

