/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage.trap.dialog;

import com.sanrad.nms.client.data.storage.traps.SrStorageNotificationTableModel;
import com.sanrad.nms.client.gui.storage.trap.SrStorageNotificationTablePanel;
import com.sanrad.nms.client.gui.storage.trap.dialog.StorageTrapsTextPane;
import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.SrTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.DefaultStyledDocument;

public class StorageTrapsDialog
extends JFrame {
    private static final long serialVersionUID = 8699038733599698477L;
    protected SrTable myTable;
    protected JButton myCloseBtn;
    protected JLabel myTotalRowsLbl;

    public StorageTrapsDialog() {
        super("RAID Events");
        this.setDefaultCloseOperation(2);
        this.init();
    }

    protected void init() {
        this.setIconImage(ImageObject.APP_ICON.getImageIcon().getImage());
        this.layoutComponents();
        this.myTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                StorageTrapsDialog.this.setStatusMessage();
            }
        });
        this.setStatusMessage();
        this.setSize(750, 500);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 4, screenSize.height / 4);
    }

    private void setStatusMessage() {
        this.myTotalRowsLbl.setText("Total " + this.myTable.getRowCount() + " items");
    }

    private void layoutComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        SrPanel storageTrapsPanel = this.createStorageTrapsPanel();
        SrPanel buttonsPanel = this.createButtonsPanel();
        SrPanel tablePanel = this.createTablePanel();
        SrPanel southPanel = new SrPanel();
        southPanel.setLayout(new BorderLayout());
        southPanel.add((Component)storageTrapsPanel, "Center");
        southPanel.add((Component)buttonsPanel, "South");
        this.getContentPane().add((Component)tablePanel, "Center");
        this.getContentPane().add((Component)southPanel, "South");
    }

    protected SrPanel createStorageTrapsPanel() {
        SrPanel panel = new SrPanel();
        StorageTrapsTextPane pane = new StorageTrapsTextPane(new DefaultStyledDocument());
        pane.setEditable(false);
        pane.setBorder(BorderFactory.createLineBorder(Color.gray, 3));
        this.myTotalRowsLbl = new JLabel();
        this.myTotalRowsLbl.setFont(LookAndFill.STATUSBAR_LABEL_FONT);
        this.myTotalRowsLbl.setForeground(LookAndFill.STATUSBAR_LABEL_FOREGROUND);
        SrPanel labelPanel = new SrPanel();
        labelPanel.setLayout(new FlowLayout());
        labelPanel.add(this.myTotalRowsLbl);
        panel.setLayout(new BorderLayout());
        panel.add((Component)pane, "Center");
        panel.add((Component)labelPanel, "South");
        panel.setBorder(new EmptyBorder(3, 3, 3, 3));
        return panel;
    }

    protected SrPanel createButtonsPanel() {
        SrPanel buttonsPanel = new SrPanel();
        buttonsPanel.setLayout(new FlowLayout(2));
        this.myCloseBtn = new JButton("Close");
        this.myCloseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StorageTrapsDialog.this.exit();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StorageTrapsDialog.this.exit();
            }
        });
        buttonsPanel.add(this.myCloseBtn);
        SrPanel labelPanel = this.createLabelPanel();
        SrPanel panel = new SrPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)labelPanel, "West");
        panel.add((Component)buttonsPanel, "East");
        return panel;
    }

    protected SrPanel createLabelPanel() {
        return new SrPanel();
    }

    protected SrPanel createTablePanel() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        SrStorageNotificationTablePanel pan = new SrStorageNotificationTablePanel(new SrStorageNotificationTableModel());
        this.myTable = pan.getTable();
        SrScrollPane scroll = new SrScrollPane(this.myTable);
        scroll.getViewport().setBackground(LookAndFill.TABLE_SCROLL_BACKGROUND_COLOR);
        mainPanel.add((Component)scroll, "Center");
        return mainPanel;
    }

    protected final void exit() {
        this.dispose();
    }
}

