/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage.trap;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.ObjectStatus;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.storage.traps.SrStorageNotificationTableHeader;
import com.sanrad.nms.client.gui.util.Utility;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.swing.LookAndFill;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class StorageTrapsTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 4077133988325693457L;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final String INVALID_IP = "0.0.0.0";

    public StorageTrapsTableRenderer() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object cid;
        this.setHorizontalAlignment(2);
        if (value != null && value.toString() == null) {
            theLogger.error(SrLogCategories.LEGACY, new Exception("Method toString() returned null from class " + value.getClass()), new Object[0]);
            this.setValue(null);
        } else {
            this.setValue(value);
        }
        if (value instanceof SrTreeNode) {
            this.setIcon(((SrTreeNode)value).getNodeIcon());
        }
        if (value instanceof ObjectStatus) {
            this.setIcon(Utility.getInstance().getSeverityIcon(value));
            this.setText(((ObjectStatus)value).getAlias());
            this.setHorizontalAlignment(0);
        }
        if (value instanceof AliasObject && (cid = ((AliasObject)value).getAdditionalValue()) instanceof ClassID) {
            this.setIcon(Utility.getInstance().getIcon((ClassID)cid));
        }
        if (isSelected) {
            this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
        } else {
            this.setBackground(LookAndFill.TABLE_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_FOREGROUND);
        }
        if (SrStorageNotificationTableHeader.DEVICE_HOST_IP.getIndexInModel() == column && INVALID_IP.equals(value)) {
            this.setText("");
        }
        return this;
    }
}

