/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage.panels;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.event.DocumentListener;

public class RaidPanel
extends SrPanel {
    private static final long serialVersionUID = -6311128290233961062L;
    GridBagConstraints myConstraints = new GridBagConstraints();
    private static final String theRaidNameLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_VSWITCH_DLG_RAID_NAME_LABEL);
    private static final String theRaidFirstIpLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_VSWITCH_DLG_RAID_FIRST_IP_LABEL);
    private static final String theRaidSecondIpLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_VSWITCH_DLG_RAID_SECOND_IP_LABEL);
    private SrLabelField myRaidNameLabel = new SrLabelField(theRaidNameLabel);
    private SrLabelField myRaidFirstIPLabel = new SrLabelField(theRaidFirstIpLabel);
    private SrLabelField myRaidSecondIPLabel = new SrLabelField(theRaidSecondIpLabel);
    private SrTextField myRaidNameField = new SrTextField(15);
    private SrIPTextField myRaidFirstIPField = new SrIPTextField();
    private SrIPTextField myRaidSecondIPField = new SrIPTextField();
    private Insets myFieldInsets = new Insets(0, 15, 5, 10);

    public RaidPanel(String aTitle) {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(aTitle));
        this.myConstraints.anchor = 18;
        this.myConstraints.insets = this.myFieldInsets;
        this.myConstraints.weightx = 1.0;
        this.myConstraints.gridx = 0;
        this.myConstraints.gridy = 0;
        this.add((Component)this.myRaidNameLabel, this.myConstraints);
        this.myConstraints.gridy = 1;
        this.add((Component)this.myRaidFirstIPLabel, this.myConstraints);
        this.myConstraints.gridy = 2;
        this.add((Component)this.myRaidSecondIPLabel, this.myConstraints);
        this.myConstraints.gridx = 1;
        this.myConstraints.gridy = 0;
        this.add((Component)this.myRaidNameField, this.myConstraints);
        this.myConstraints.gridy = 1;
        this.add((Component)this.myRaidFirstIPField, this.myConstraints);
        this.myConstraints.gridy = 2;
        this.add((Component)this.myRaidSecondIPField, this.myConstraints);
    }

    public String getRaidName() {
        String name = this.myRaidNameField.getText();
        if (name.isEmpty()) {
            return null;
        }
        return name;
    }

    private String getIpFromField(SrIPTextField aIpField) {
        String ip = aIpField.getText();
        if (ip.isEmpty()) {
            return null;
        }
        return ip;
    }

    public String getRaidFirstIP() {
        return this.getIpFromField(this.myRaidFirstIPField);
    }

    public String getRaidSecondIP() {
        return this.getIpFromField(this.myRaidSecondIPField);
    }

    private void setRaidName(String aName) {
        this.myRaidNameField.setText(aName);
    }

    private void setRaidFirstIP(String aIP) {
        this.myRaidFirstIPField.setText(aIP);
    }

    private void setRaidSecondIP(String aIP) {
        this.myRaidSecondIPField.setText(aIP);
    }

    public void clearAllFields() {
        this.setRaidName("");
        this.setRaidFirstIP("");
        this.setRaidSecondIP("");
    }

    public void updateFieldsFromRaid(RaidSystem aRaid) {
        String ip2;
        this.clearAllFields();
        this.setRaidName(aRaid.getDisplayName());
        String ip1 = aRaid.getCtrlIp1();
        if (ip1 != null) {
            this.setRaidFirstIP(ip1);
        }
        if ((ip2 = aRaid.getCtrlIp2()) != null) {
            this.setRaidSecondIP(ip2);
        }
    }

    public void setAllFieldsEnabled(boolean enabled) {
        this.myRaidNameField.setEnabled(enabled);
        this.myRaidFirstIPField.setEnabled(enabled);
        this.myRaidSecondIPField.setEnabled(enabled);
    }

    public void addDocumentListener(DocumentListener aDocumentListener) {
        this.myRaidNameField.getDocument().addDocumentListener(aDocumentListener);
        this.myRaidFirstIPField.addDocumentListener(aDocumentListener);
        this.myRaidSecondIPField.addDocumentListener(aDocumentListener);
    }

    public boolean validateParameters() {
        if (this.getRaidName() != null && !this.myRaidNameField.isComponentValid()) {
            return false;
        }
        int ipCount = 0;
        if (this.getRaidFirstIP() != null && this.myRaidFirstIPField.isComponentValid() && this.myRaidFirstIPField.isTextSetCorrectly()) {
            ++ipCount;
        }
        if (this.getRaidSecondIP() != null && this.myRaidSecondIPField.isComponentValid() && this.myRaidSecondIPField.isTextSetCorrectly()) {
            ++ipCount;
        }
        return ipCount != 0;
    }

    public boolean isEmpty() {
        return this.getRaidName() == null && this.getRaidFirstIP() == null && this.getRaidSecondIP() == null;
    }
}

