/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage.dialogs;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.SrTextPane;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.util.StorageSize;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.tree.TreeNode;

public class SubdiskPropertiesDialog
extends SrOKCancelDialog
implements SubDirectAccessDeviceListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private SubDirectAccessDeviceNode node;
    private JLabel diskAliasLbl;
    private JLabel aliasLbl;
    private JLabel infoLbl;
    private JLabel totalSpaceLbl;
    private JLabel exposedLbl;
    private JLabel volumeLbl;
    private JLabel blockSizeLbl;
    private JLabel startAddressLbl;
    private JLabel endAddressLbl;
    private JTextField realStartAddLbl;
    private JTextField aliasFld;
    private JTextField endFld;
    private JTextField realBlockSizeFld;
    private JTextField diskAliasFld;
    private JTextField capacityFld;
    private JTextArea infoFld;
    private String alias;
    private String info;
    private SrClientLabel volumeStateLbl = new SrClientLabel("Volume State: ");
    private SrTextPane volState = new SrTextPane();
    private SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String newAlias = SubdiskPropertiesDialog.this.aliasFld.getText();
            String newInfo = SubdiskPropertiesDialog.this.infoFld.getText();
            HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>();
            if (!newAlias.equals(SubdiskPropertiesDialog.this.alias)) {
                params.put(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, newAlias);
                theLogger.trace(SrLogCategories.LEGACY, "NEW ALIAS  --- ", newAlias);
            }
            if (!SubdiskPropertiesDialog.this.info.equalsIgnoreCase(newInfo)) {
                params.put(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, newInfo);
                theLogger.trace(SrLogCategories.LEGACY, "NEW INFO  --- ", newInfo);
            }
            return Collections.singleton(SubDirectAccessDeviceManager.getInstance().editSubDirectAccessDevice(SubdiskPropertiesDialog.this.node, params));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public SubdiskPropertiesDialog(JFrame owner, SubDirectAccessDeviceNode node) {
        super(owner, "Subdisk Properties", false, SystemRootNode.getInstance().getClusterNodeOfSource(node));
        this.initDialog(node);
    }

    public SubdiskPropertiesDialog(JDialog owner, SubDirectAccessDeviceNode node) {
        super(owner, "Subdisk Properties", false, SystemRootNode.getInstance().getClusterNodeOfSource(node));
        this.initDialog(node);
    }

    private void initDialog(SubDirectAccessDeviceNode subdiskNode) {
        this.node = subdiskNode;
        this.setModal(false);
        this.initComponents();
        this.setBackgroundColor(this.buttonsPanel);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this);
        this.setSizeAndMoveToCenter(325, 445);
        this.fixSizes();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SubdiskPropertiesDialog.this.node.setUserObject(null);
            }
        });
        this.setOKAction(this.myOKAction);
    }

    @Override
    public void removeListeners() {
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this);
    }

    @Override
    public void addListeners() {
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this);
    }

    @Override
    public void dispose() {
        this.node.setUserObject(null);
        super.dispose();
    }

    private void fixSizes() {
        Dimension dim = this.startAddressLbl.getPreferredSize();
        this.diskAliasLbl.setPreferredSize(dim);
        this.aliasLbl.setPreferredSize(dim);
        this.blockSizeLbl.setPreferredSize(dim);
        this.totalSpaceLbl.setPreferredSize(dim);
        this.infoLbl.setPreferredSize(dim);
        this.volumeLbl.setPreferredSize(dim);
        this.exposedLbl.setPreferredSize(dim);
        this.endAddressLbl.setPreferredSize(dim);
        dim = this.aliasFld.getPreferredSize();
        this.endFld.setPreferredSize(dim);
        this.realBlockSizeFld.setPreferredSize(dim);
        this.diskAliasFld.setPreferredSize(dim);
        this.realStartAddLbl.setPreferredSize(dim);
        this.capacityFld.setPreferredSize(dim);
    }

    private void initComponents() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(11, 1));
        this.setBackgroundColor(mainPanel);
        SrPanel diskAliasPanel = this.createDiskAliasPanel();
        this.setBackgroundColor(diskAliasPanel);
        SrPanel aliasPanel = this.createAliasPanel();
        this.setBackgroundColor(aliasPanel);
        SrPanel infoPanel = this.createInfoPanel();
        this.setBackgroundColor(infoPanel);
        SrPanel totalSpacePanel = this.createTotalSpacePanel();
        this.setBackgroundColor(totalSpacePanel);
        SrPanel blockSizePanel = this.createBlockSizePanel();
        this.setBackgroundColor(blockSizePanel);
        SrPanel startAddressPanel = this.createStartAddressPanel();
        this.setBackgroundColor(startAddressPanel);
        SrPanel volumePanel = this.createVolumePanel();
        this.setBackgroundColor(volumePanel);
        SrPanel exposedPanel = this.createExposedPanel();
        this.setBackgroundColor(exposedPanel);
        SrPanel endAddressPanel = this.createEndAddressPanel();
        SrPanel p1 = new SrPanel();
        this.setBackgroundColor(p1);
        mainPanel.add(p1);
        mainPanel.add(diskAliasPanel);
        mainPanel.add(aliasPanel);
        mainPanel.add(totalSpacePanel);
        mainPanel.add(blockSizePanel);
        mainPanel.add(startAddressPanel);
        mainPanel.add(endAddressPanel);
        mainPanel.add(volumePanel);
        SrScrollPane stateScroll = new SrScrollPane(this.volState);
        stateScroll.setMaximumSize(new Dimension(15, 3));
        SrPanel statePanel = this.createSrPanel(this.volumeStateLbl, stateScroll);
        this.setStateLabel();
        this.volState.setEditable(false);
        mainPanel.add(statePanel);
        mainPanel.add(exposedPanel);
        mainPanel.add(infoPanel);
        SrPanel p = new SrPanel();
        this.setBackgroundColor(p);
        this.getContentPane().add((Component)mainPanel, "Center");
    }

    private SrPanel createDiskAliasPanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        DirectAccessDeviceNode parentNode = this.node.getDirectAccessDeviceParent();
        this.diskAliasLbl = new JLabel("Disk Alias: ");
        this.diskAliasLbl.setFont(LookAndFill.GENERAL_FONT);
        this.diskAliasFld = new JTextField();
        if (parentNode != null) {
            this.diskAliasFld.setText(parentNode.toString());
        }
        this.diskAliasFld.setEditable(false);
        this.diskAliasFld.setForeground(Color.gray);
        this.diskAliasFld.setFont(LookAndFill.GENERAL_FONT);
        panel.add(this.diskAliasLbl);
        panel.add(this.diskAliasFld);
        return panel;
    }

    private SrPanel createAliasPanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.aliasLbl = new JLabel("Subdisk Alias: ");
        this.aliasLbl.setFont(LookAndFill.GENERAL_FONT);
        this.aliasFld = new JTextField(12);
        this.alias = this.node.getAlias();
        this.aliasFld.setText(this.alias);
        this.aliasFld.setFont(LookAndFill.GENERAL_FONT);
        panel.add(this.aliasLbl);
        panel.add(this.aliasFld);
        return panel;
    }

    private SrPanel createInfoPanel() {
        SrPanel panel = new SrPanel();
        SrPanel panel2 = new SrPanel();
        panel2.setLayout(new GridLayout(3, 1));
        this.setBackgroundColor(panel2);
        panel.setLayout(new FlowLayout(0));
        this.infoLbl = new JLabel("Information: ");
        this.infoLbl.setFont(LookAndFill.GENERAL_FONT);
        panel2.add(this.infoLbl);
        this.infoFld = new JTextArea(2, 20);
        this.info = this.node.getInfo();
        this.infoFld.setText(this.info);
        this.infoFld.setFont(LookAndFill.GENERAL_FONT);
        SrScrollPane scroll = new SrScrollPane(this.infoFld);
        this.infoLbl.setAlignmentY(scroll.getAlignmentY());
        panel.add(panel2);
        panel.add(scroll);
        return panel;
    }

    private SrPanel createTotalSpacePanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        String capacity = StorageSize.getSizeAsString(this.node.getTotalSpace());
        this.totalSpaceLbl = new JLabel("Capacity: ");
        this.totalSpaceLbl.setFont(LookAndFill.GENERAL_FONT);
        this.capacityFld = new JTextField();
        this.capacityFld.setText(capacity);
        this.capacityFld.setFont(LookAndFill.GENERAL_FONT);
        this.capacityFld.setEditable(false);
        this.capacityFld.setForeground(Color.gray);
        panel.add(this.totalSpaceLbl);
        panel.add(this.capacityFld);
        return panel;
    }

    private SrPanel createBlockSizePanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.blockSizeLbl = new JLabel("Block Size: ");
        this.blockSizeLbl.setFont(LookAndFill.GENERAL_FONT);
        this.realBlockSizeFld = new JTextField();
        this.realBlockSizeFld.setText("" + this.node.getBlockSize().toString());
        this.realBlockSizeFld.setFont(LookAndFill.GENERAL_FONT);
        this.realBlockSizeFld.setForeground(Color.gray);
        this.realBlockSizeFld.setEditable(false);
        panel.add(this.blockSizeLbl);
        panel.add(this.realBlockSizeFld);
        return panel;
    }

    private SrPanel createStartAddressPanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.startAddressLbl = new JLabel("Start Address: ");
        this.startAddressLbl.setFont(LookAndFill.GENERAL_FONT);
        this.realStartAddLbl = new JTextField();
        this.realStartAddLbl.setText("0x" + this.node.getStartAddress().toString(16).toUpperCase());
        this.realStartAddLbl.setEditable(false);
        this.realStartAddLbl.setFont(LookAndFill.GENERAL_FONT);
        this.realStartAddLbl.setForeground(Color.gray);
        panel.add(this.startAddressLbl);
        panel.add(this.realStartAddLbl);
        return panel;
    }

    private SrPanel createEndAddressPanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.setBackgroundColor(panel);
        this.endAddressLbl = new JLabel("End Address: ");
        this.endAddressLbl.setFont(LookAndFill.GENERAL_FONT);
        this.endFld = new JTextField();
        this.endFld.setText("0x" + this.node.getEndAddress().toString(16).toUpperCase());
        this.endFld.setEditable(false);
        this.endFld.setForeground(Color.gray);
        this.endFld.setFont(LookAndFill.GENERAL_FONT);
        panel.add(this.endAddressLbl);
        panel.add(this.endFld);
        return panel;
    }

    private SrPanel createVolumePanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.volumeLbl = new JLabel("Volume: ");
        this.volumeLbl.setFont(LookAndFill.GENERAL_FONT);
        JCheckBox isVolumeCheckbox = new JCheckBox();
        isVolumeCheckbox.setEnabled(false);
        boolean isVol = false;
        TreeNode parent = this.node.getParent();
        if (parent != null && parent instanceof VolumeNode) {
            isVol = true;
        }
        if (this.node.isExposed()) {
            isVol = true;
        }
        isVolumeCheckbox.setSelected(isVol);
        this.setBackgroundColor(isVolumeCheckbox);
        panel.add(this.volumeLbl);
        panel.add(isVolumeCheckbox);
        return panel;
    }

    private SrPanel createExposedPanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.exposedLbl = new JLabel("Exposed: ");
        this.exposedLbl.setFont(LookAndFill.GENERAL_FONT);
        JCheckBox exposedCheckbox = new JCheckBox();
        this.setBackgroundColor(exposedCheckbox);
        exposedCheckbox.setSelected(this.node.isExposed());
        exposedCheckbox.setEnabled(false);
        panel.add(this.exposedLbl);
        panel.add(exposedCheckbox);
        return panel;
    }

    private void setStateLabel() {
        String state = this.node.getVolStateStr();
        this.volState.setText(state == null ? ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE) : state);
    }

    @Override
    public void doOnCancel() {
        this.node.setUserObject(null);
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    @Override
    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
        if (event.getStub().equals(this.node.getStub())) {
            this.dispose();
        }
    }

    @Override
    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        if (event.getStub().equals(this.node.getStub())) {
            this.aliasFld.setText(event.getAlias());
        }
    }

    @Override
    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
        if (event.getStub().equals(this.node.getStub())) {
            this.infoFld.setText(event.getInfo());
        }
    }

    private void setBackgroundColor(JComponent com) {
        com.setBackground(LookAndFill.DIALOG_COLOR);
    }
}

