/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage.dialogs;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.dialogs.SubDirectAccessDevicesListModel;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SynchronizeElementAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.storage.SrDRStorageTablePopupMenu;
import com.sanrad.nms.client.gui.storage.SrStorageComponentInterface;
import com.sanrad.nms.client.gui.storage.dialogs.SubDirectAccessDeviceListRenderer;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.SwingUtilities;

public class SubDirectAccessDevicesList
extends JList
implements SrStorageComponentInterface {
    private SrDRStorageTablePopupMenu m_popup;
    private JFrame frameOwner;
    private final DeleteAction myDeleteAction;
    private View<SubDirectAccessDeviceNode> myView = new SrTableView<SubDirectAccessDeviceNode>(this.getSelectionModel()){

        @Override
        public Collection<SubDirectAccessDeviceNode> getValue() {
            Vector<SubDirectAccessDeviceNode> retVal = new Vector<SubDirectAccessDeviceNode>();
            for (Object selValue : SubDirectAccessDevicesList.this.getSelectedValues()) {
                retVal.add((SubDirectAccessDeviceNode)selValue);
            }
            return retVal;
        }
    };
    private final AlarmAction<SubDirectAccessDeviceNode> myOpenSpecificAlarmsAction = new AlarmAction<SubDirectAccessDeviceNode>(this.myView, true);
    private final AlarmAction<SubDirectAccessDeviceNode> myOpenPropagatedAlarmsAction = new AlarmAction<SubDirectAccessDeviceNode>(this.myView, true);

    public SubDirectAccessDevicesList(List list, DirectAccessDeviceNode node, OperationController controller, JDialog owner, JFrame frameOwner) {
        this.setModel(new SubDirectAccessDevicesListModel(list, node));
        this.setCellRenderer(new SubDirectAccessDeviceListRenderer());
        this.setFont(new Font("Verdana", 0, 9));
        this.frameOwner = frameOwner;
        this.myDeleteAction = new DeleteAction<SubDirectAccessDeviceNode>(this.myView, controller, new DeleteAction.Confirmator());
        this.m_popup = new SrDRStorageTablePopupMenu<SubDirectAccessDeviceNode>(this, this.myView, frameOwner);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SubDirectAccessDevicesList.this.showPopup(e);
            }
        });
    }

    private void showPopup(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) && this.getSelectedIndex() > -1) {
            SubDirectAccessDevicesListModel model = (SubDirectAccessDevicesListModel)this.getModel();
            this.m_popup.show(e, SystemRootNode.getInstance().getClusterNodeOfSource(model.getParentDirectAccessDeviceNode()));
        }
    }

    @Override
    public AlarmAction getSpecificAlarmsAction() {
        return this.myOpenSpecificAlarmsAction;
    }

    @Override
    public AlarmAction getPropagatedAlarmsAction() {
        return this.myOpenPropagatedAlarmsAction;
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.myDeleteAction;
    }

    public SynchronizeElementAction getSynchronizeAction() {
        return null;
    }

    @Override
    public Object getDevice(int index) {
        return this.getModel().getElementAt(index);
    }

    @Override
    public JComponent getMyComponent() {
        return this;
    }

    @Override
    public Object[] getSelectedFreeAndNotExposedAliases() {
        Object[] selected = this.getSelectedValues();
        ArrayList<Object> finalSelection = new ArrayList<Object>();
        if (selected != null && selected.length > 0) {
            for (int i = 0; i < selected.length; ++i) {
                boolean isFreeAndExposed = ((SubDirectAccessDevicesListModel)this.getModel()).isFree(selected[i]);
                if (!isFreeAndExposed) continue;
                finalSelection.add(selected[i]);
            }
        }
        return finalSelection.toArray();
    }

    @Override
    public int[] getSelectedIndexes() {
        return this.getSelectedIndices();
    }
}

