/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.raid.NexsanManagedRaidSystem;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.raid.UnmanagedRaidSystem;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrCloseDialog;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;

public class RaidPropertiesDialog
extends SrCloseDialog {
    private static final long serialVersionUID = 6341004019599100379L;
    private static final String RAID_STATUS_NORMAL_STRING = "NORMAL";
    private static final String theRaidNameLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_VSWITCH_DLG_RAID_NAME_LABEL);
    private static final String theRaidFirstIpLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_VSWITCH_DLG_RAID_FIRST_IP_LABEL);
    private static final String theRaidSecondIpLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_VSWITCH_DLG_RAID_SECOND_IP_LABEL);
    private static final String theRaidWWNLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RAID_PROPERTIES_RAID_WWN_LABEL);
    private static final String theRaidSystemNameLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RAID_PROPERTIES_RAID_SYSTEM_NAME_LABEL);
    private static final String theRaidModelLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RAID_PROPERTIES_RAID_MODEL_LABEL);
    private static final String theRaidLevelLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RAID_PROPERTIES_RAID_LEVEL_LABEL);
    private static final String theRaidFwRevisionLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RAID_PROPERTIES_RAID_FW_REV_LABEL);
    private static final String theRaidStatusLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RAID_PROPERTIES_RAID_STATUS_LABEL);
    private static final String theRaidCreationTimeLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RAID_PROPERTIES_RAID_CREATION_TIME_LABEL);
    private static final String theRaidCtrlIpLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RAID_PROPERTIES_RAID_CTRL_IP_LABEL);
    private static final String theTransportTypeLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CREATE_STORAGE_DLG_TRANSPORTTYPE_LBL);
    private RaidSystem myRaid = null;
    private SrPanel myMainPanel = new SrPanel();

    public RaidPropertiesDialog(JFrame aOwner, String aTitle, RaidSystem aRaid) {
        super(aOwner, aTitle, aRaid.getClusters().get(0));
        this.myRaid = aRaid;
        this.initComponents();
        this.pack();
        this.setVisible(true);
    }

    public static SrPanel createRaidPropertiesPanel(RaidSystem aRaid) {
        switch (aRaid.getType()) {
            case GENERAL_UNMANAGED_RAID: {
                return RaidPropertiesDialog.createGeneralRaidPropertiesPanel((UnmanagedRaidSystem)aRaid);
            }
            case GENERAL_MANAGED_RAID: 
            case NEXSAN_MANAGED_RAID: {
                return RaidPropertiesDialog.createGeneralManagedRaidPropertiesPanel(aRaid);
            }
        }
        throw new IllegalArgumentException("The raid type: " + (Object)((Object)aRaid.getType()) + " is not supported.");
    }

    private void initComponents() {
        SrPanel raidPanel = RaidPropertiesDialog.createRaidPropertiesPanel(this.myRaid);
        if (raidPanel == null) {
            throw new IllegalStateException("The Raid Subsystem type provided for the Raid Properties Dialog is invalid");
        }
        this.myMainPanel.add(raidPanel);
        this.addCenterPanel(this.myMainPanel);
    }

    public static SrPanel createGeneralManagedRaidPropertiesPanel(RaidSystem aRaid) {
        String ip2;
        String ip1;
        BigInteger creationTime;
        GridBagConstraints constraints = new GridBagConstraints();
        Insets fieldInsets = new Insets(0, 5, 5, 10);
        constraints.anchor = 23;
        constraints.insets = fieldInsets;
        constraints.weightx = 1.0;
        SrPanel raidPanel = new SrPanel(new GridBagLayout());
        SrLabelField raidSysNameLabel = new SrLabelField(theRaidSystemNameLabel + ": ");
        SrTextField raidSysNameField = new SrTextField(20);
        raidSysNameField.setEnabled(false);
        SrLabelField raidModelLabel = new SrLabelField(theRaidModelLabel + ": ");
        SrTextField raidModelField = new SrTextField(20);
        raidModelField.setEnabled(false);
        SrLabelField raidFwRevLabel = new SrLabelField(theRaidFwRevisionLabel + ": ");
        SrTextField raidFwRevField = new SrTextField(20);
        raidFwRevField.setEnabled(false);
        SrLabelField raidStatusLabel = new SrLabelField(theRaidStatusLabel + ": ");
        SrTextField raidStatusField = new SrTextField(20);
        raidStatusField.setEnabled(false);
        SrLabelField raidCreationTimeLabel = new SrLabelField(theRaidCreationTimeLabel + ": ");
        SrTextField raidCreationTimeField = new SrTextField(20);
        raidCreationTimeField.setEnabled(false);
        SrLabelField raidCtrlUrl1Label = new SrLabelField(theRaidCtrlIpLabel + " 1: ");
        SrTextField raidCtrlUrl1Field = new SrTextField(20);
        raidCtrlUrl1Field.setEnabled(false);
        SrLabelField raidCtrlUrl2Label = new SrLabelField(theRaidCtrlIpLabel + " 2: ");
        SrTextField raidCtrlUrl2Field = new SrTextField(20);
        raidCtrlUrl2Field.setEnabled(false);
        SrLabelField transportTypeLabel = new SrLabelField(theTransportTypeLabel + ": ");
        SrTextField transportTypeField = new SrTextField(20);
        transportTypeField.setEnabled(false);
        NexsanManagedRaidSystem raidSys = (NexsanManagedRaidSystem)aRaid;
        raidSysNameField.setText(raidSys.getDisplayName());
        raidModelField.setText(raidSys.getModelName());
        raidFwRevField.setText(raidSys.getFirmwareRevision());
        SrBITSConstant raidStatus = raidSys.getStatus();
        if (raidStatus != null) {
            String status = RAID_STATUS_NORMAL_STRING;
            if (raidStatus.getBitNumber() != 0) {
                status = raidStatus.toString();
            }
            raidStatusField.setText(status);
        }
        if ((creationTime = raidSys.getCreationTime()) != null) {
            Long longVal = new Long(creationTime.toString());
            longVal = longVal * 1000L;
            String textToSet = DateFormat.getDateTimeInstance(1, 3, Locale.ENGLISH).format(new Date(longVal));
            raidCreationTimeField.setText(textToSet);
        }
        if ((ip1 = raidSys.getCtrlIp1()) != null) {
            raidCtrlUrl1Field.setText(ip1);
        }
        if ((ip2 = raidSys.getCtrlIp2()) != null) {
            raidCtrlUrl2Field.setText(ip2);
        }
        raidCtrlUrl1Field.setEnabled(false);
        raidCtrlUrl2Field.setEnabled(false);
        List<DirectAccessDeviceNode> raidDisks = raidSys.getDisks();
        if (raidDisks != null && !raidDisks.isEmpty()) {
            transportTypeField.setText(raidDisks.get(0).getTransportType());
        }
        constraints.gridy = 0;
        constraints.gridx = 0;
        raidPanel.add((Component)raidSysNameLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        raidPanel.add((Component)raidSysNameField, constraints);
        constraints.gridy = 1;
        constraints.gridx = 0;
        raidPanel.add((Component)raidModelLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raidModelField, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        raidPanel.add((Component)raidFwRevLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raidFwRevField, constraints);
        constraints.gridy = 3;
        constraints.gridx = 0;
        raidPanel.add((Component)raidStatusLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raidStatusField, constraints);
        constraints.gridy = 4;
        constraints.gridx = 0;
        raidPanel.add((Component)raidCreationTimeLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raidCreationTimeField, constraints);
        constraints.gridy = 5;
        constraints.gridx = 0;
        raidPanel.add((Component)raidCtrlUrl1Label, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raidCtrlUrl1Field, constraints);
        constraints.gridy = 6;
        constraints.gridx = 0;
        constraints.weighty = 1.0;
        raidPanel.add((Component)raidCtrlUrl2Label, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raidCtrlUrl2Field, constraints);
        constraints.gridy = 7;
        constraints.gridx = 0;
        raidPanel.add((Component)transportTypeLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)transportTypeField, constraints);
        return raidPanel;
    }

    public static SrPanel createGeneralRaidPropertiesPanel(UnmanagedRaidSystem aRaid) {
        String ip2;
        String ip1;
        DirectAccessDeviceNode disk;
        GridBagConstraints constraints = new GridBagConstraints();
        Insets fieldInsets = new Insets(0, 5, 5, 10);
        constraints.anchor = 23;
        constraints.insets = fieldInsets;
        constraints.weightx = 1.0;
        SrPanel raidPanel = new SrPanel(new GridBagLayout());
        SrLabelField raidNameLabel = new SrLabelField(theRaidNameLabel);
        SrLabelField raidFWLabel = new SrLabelField(theRaidFwRevisionLabel);
        SrLabelField raidWWNLabel = new SrLabelField(theRaidWWNLabel);
        SrLabelField raidFirstIPLabel = new SrLabelField(theRaidFirstIpLabel);
        SrLabelField raidSecondIPLabel = new SrLabelField(theRaidSecondIpLabel);
        SrTextField raidNameField = new SrTextField(15);
        SrTextField raiFwField = new SrTextField(15);
        SrTextField raidWWNField = new SrTextField(15);
        SrIPTextField raidFirstIPField = new SrIPTextField();
        SrIPTextField raidSecondIPField = new SrIPTextField();
        SrLabelField transportTypeLabel = new SrLabelField(theTransportTypeLabel + ": ");
        SrTextField transportTypeField = new SrTextField(20);
        transportTypeField.setEnabled(false);
        raidNameField.setEnabled(false);
        raidNameField.setText(aRaid.getDisplayName());
        raiFwField.setEnabled(false);
        raiFwField.setText(aRaid.getFirmwareRevision());
        raidWWNField.setEnabled(false);
        List<DirectAccessDeviceNode> raidDisks = aRaid.getDisks();
        if (raidDisks != null && !raidDisks.isEmpty() && (disk = raidDisks.get(0)) != null) {
            transportTypeField.setText(disk.getTransportType().toString());
            raidWWNField.setText(disk.getEntityName());
        }
        if ((ip1 = aRaid.getCtrlIp1()) != null) {
            raidFirstIPField.setText(ip1);
        }
        if ((ip2 = aRaid.getCtrlIp2()) != null) {
            raidSecondIPField.setText(ip2);
        }
        raidFirstIPField.setEnabled(false);
        raidSecondIPField.setEnabled(false);
        constraints.gridy = 0;
        constraints.gridx = 0;
        raidPanel.add((Component)raidNameLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raidNameField, constraints);
        constraints.gridy = 1;
        constraints.gridx = 0;
        raidPanel.add((Component)raidFWLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raiFwField, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        raidPanel.add((Component)raidWWNLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raidWWNField, constraints);
        constraints.gridy = 3;
        constraints.gridx = 0;
        raidPanel.add((Component)raidFirstIPLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raidFirstIPField, constraints);
        constraints.gridy = 4;
        constraints.gridx = 0;
        raidPanel.add((Component)raidSecondIPLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)raidSecondIPField, constraints);
        constraints.gridy = 5;
        constraints.gridx = 0;
        raidPanel.add((Component)transportTypeLabel, constraints);
        constraints.gridx = 1;
        raidPanel.add((Component)transportTypeField, constraints);
        return raidPanel;
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }
}

