/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage.dialogs;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceSpace;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrRadioButton;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrDecimalTextField;
import com.sanrad.swing.components.SrHexAddressTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.StorageSize;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;

public class NewSubdiskDialog
extends SrOKCancelDialog {
    private static SrLogger theLogger = SrLogger.getLogger();
    private SrComboBox<DirectAccessDeviceNode> entityCombobox;
    private SrComboBox<StorageSize> unitsCombobox;
    private SrClientLabel unitsNumOfBlocksLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.NUM_OF_BLOCKS));
    private SrTextField nameField;
    private SrDecimalTextField sizeField;
    private SrClientLabel entityLbl;
    private SrHexAddressTextField addressField;
    private SrClientLabel fromLbl;
    private SrClientLabel totalSizeLbl;
    private SrClientLabel nameLbl;
    private SrClientLabel sizeRequiredLbl;
    private SrRadioButton withStartAddBtn;
    private SrRadioButton withoutStartAddBtn;
    private SrRadioButton endOfDiskBtn;
    private SrRadioButton supplySizeBtn;
    private List<DirectAccessDeviceNode> storageData;
    private SrClientLabel availableSizeLbl;
    private final StorageSize[] UNITS = new StorageSize[]{StorageSize.MEGA, StorageSize.GIGA, StorageSize.TERA};
    private SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            DirectAccessDeviceNode diskNode = (DirectAccessDeviceNode)NewSubdiskDialog.this.entityCombobox.getSelectedItem();
            String subdiskName = NewSubdiskDialog.this.nameField.getText();
            if (NewSubdiskDialog.this.endOfDiskBtn.isSelected()) {
                theLogger.trace(SrLogCategories.LEGACY, "creating subdisk: from last end address to the end of the disk. name=", NewSubdiskDialog.this.nameField.getText());
                return Collections.singleton(SubDirectAccessDeviceManager.getInstance().createSubDirectAccessDevice(diskNode, subdiskName, null, null));
            }
            String startAdress = NewSubdiskDialog.this.addressField.toHexString();
            BigDecimal subdiskSize = NewSubdiskDialog.this.getBytes();
            if (subdiskSize == null) {
                return Collections.singleton(new FailedFuture(new IllegalValueException("You must supply Subdisk size."), "NewSubdiskDialog.OKAction, size not set"));
            }
            if (NewSubdiskDialog.this.withStartAddBtn.isSelected() && startAdress.equals("")) {
                return Collections.singleton(new FailedFuture(new IllegalValueException("You must supply the 'Start Address'."), "NewSubdiskDialog.OKAction, start address not set"));
            }
            if (NewSubdiskDialog.this.withStartAddBtn.isSelected() && startAdress != null && !startAdress.equals("")) {
                BigInteger startAdd = new BigInteger(startAdress, 16);
                theLogger.trace(SrLogCategories.LEGACY, "creating subdisk: name=", NewSubdiskDialog.this.nameField.getText(), ", size=", subdiskSize, ", startAddress=", startAdress);
                return Collections.singleton(SubDirectAccessDeviceManager.getInstance().createSubDirectAccessDevice(diskNode, subdiskName, startAdd, subdiskSize.toBigInteger()));
            }
            theLogger.trace(SrLogCategories.LEGACY, "creating subdisk: name=", NewSubdiskDialog.this.nameField.getText(), ", size=", subdiskSize);
            return Collections.singleton(SubDirectAccessDeviceManager.getInstance().createSubDirectAccessDevice(diskNode, subdiskName, null, subdiskSize.toBigInteger()));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public NewSubdiskDialog(JFrame frame, DirectAccessDeviceNode item, ClusterNode workingCluster) {
        super(frame, "Create Subdisk", true, workingCluster);
        this.storageData = StorageManager.getInstance().getDisksOfCluster(this.m_workingCluster);
        this.initComponents();
        this.supplySizeBtn.setSelected(true);
        this.withoutStartAddBtn.setSelected(true);
        if (item != null) {
            this.entityCombobox.setSelectedItem(item);
            this.showStorageDeviceDetails();
        }
        this.setOKAction(this.myOKAction);
        this.fixSizes();
        this.pack();
        this.setSize(new Dimension(this.getWidth() + 30, this.getHeight()));
        this.show();
    }

    protected void fixSizes() {
        Dimension dimension = this.entityCombobox.getPreferredSize();
        this.nameField.setPreferredSize(dimension);
        this.sizeField.setPreferredSize(dimension);
        dimension = this.nameLbl.getPreferredSize();
        this.entityLbl.setPreferredSize(dimension);
        this.fromLbl.setPreferredSize(dimension);
        this.sizeRequiredLbl.setPreferredSize(dimension);
    }

    private void initRadioButtons() {
        this.withoutStartAddBtn = new SrRadioButton("Automatic Start Address");
        this.withoutStartAddBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    NewSubdiskDialog.this.setStartAddressPanelEnabled(false);
                }
            }
        });
        this.withStartAddBtn = new SrRadioButton("Supply Start Address");
        this.withStartAddBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    NewSubdiskDialog.this.setStartAddressPanelEnabled(true);
                }
            }
        });
        this.endOfDiskBtn = new SrRadioButton("Automatic to End of disk");
        this.endOfDiskBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    NewSubdiskDialog.this.setSupplySizePanelEnabled(false);
                }
            }
        });
        this.supplySizeBtn = new SrRadioButton("Supply Size: ");
        this.supplySizeBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    NewSubdiskDialog.this.setSupplySizePanelEnabled(true);
                }
            }
        });
        ButtonGroup addressGroup = new ButtonGroup();
        addressGroup.add(this.withStartAddBtn);
        addressGroup.add(this.withoutStartAddBtn);
        ButtonGroup sizeGroup = new ButtonGroup();
        sizeGroup.add(this.supplySizeBtn);
        sizeGroup.add(this.endOfDiskBtn);
    }

    private void initComponents() {
        this.initRadioButtons();
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        SrPanel entityPanel = this.createEntityPanel();
        this.availableSizeLbl = new SrClientLabel("Available Size: ");
        this.totalSizeLbl = new SrClientLabel("Total Size: ");
        SrPanel availableSizePanel = this.createSrPanel(this.availableSizeLbl, this.totalSizeLbl);
        this.nameLbl = new SrClientLabel("Subdisk Alias:");
        this.nameField = new SrTextField();
        SrPanel namePanel = this.createSrPanel(this.nameLbl, this.nameField);
        SrPanel sizeChoicePanel = this.createSizeChoicePanel();
        SrPanel topPanel = new SrPanel();
        topPanel.setLayout(new GridLayout(3, 1));
        topPanel.add(entityPanel);
        topPanel.add(availableSizePanel);
        topPanel.add(namePanel);
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)sizeChoicePanel, "Center");
        this.setComponentBgColor(this.buttonsPanel);
        this.addCenterPanel(mainPanel);
    }

    private SrPanel createSupplySizePanel() {
        SrPanel supplySizePanel = new SrPanel();
        supplySizePanel.setLayout(new BorderLayout());
        SrPanel btnPanel = new SrPanel();
        btnPanel.setLayout(new FlowLayout(0));
        btnPanel.add(this.supplySizeBtn);
        supplySizePanel.add((Component)btnPanel, "North");
        SrPanel panel = this.createSizeAndAddressPanel();
        supplySizePanel.add((Component)panel, "Center");
        return supplySizePanel;
    }

    private SrPanel createStartAddressPanel() {
        SrPanel withPanel = new SrPanel();
        withPanel.setLayout(new FlowLayout(0));
        withPanel.add(this.withStartAddBtn);
        return withPanel;
    }

    private SrPanel createAddressPanel() {
        this.fromLbl = new SrClientLabel("From:");
        this.addressField = new SrHexAddressTextField();
        SrPanel addressPanel = this.createSrPanel(this.fromLbl, this.addressField);
        addressPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        return addressPanel;
    }

    private SrPanel createNonStartAddressPanel() {
        SrPanel withoutPanel = new SrPanel();
        withoutPanel.setLayout(new FlowLayout(0));
        withoutPanel.add(this.withoutStartAddBtn);
        return withoutPanel;
    }

    private SrPanel createAutoSizePanel() {
        SrPanel autoSizePanel = new SrPanel();
        autoSizePanel.setLayout(new FlowLayout(0));
        autoSizePanel.add(this.endOfDiskBtn);
        return autoSizePanel;
    }

    private SrPanel createSizeChoicePanel() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        SrPanel centerPanel = this.createSupplySizePanel();
        SrPanel bottomPanel = this.createAutoSizePanel();
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)bottomPanel, "South");
        return mainPanel;
    }

    private SrPanel createEntityPanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.entityLbl = new SrClientLabel("Disk Alias:");
        this.entityLbl.setFont(LookAndFill.GENERAL_FONT);
        this.entityCombobox = new SrComboBox<DirectAccessDeviceNode>(this.storageData);
        this.entityCombobox.setFont(LookAndFill.GENERAL_FONT);
        this.entityCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NewSubdiskDialog.this.showStorageDeviceDetails();
            }
        });
        panel.add(this.entityLbl);
        panel.add(this.entityCombobox);
        return panel;
    }

    private void showStorageDeviceDetails() {
        DirectAccessDeviceNode device = (DirectAccessDeviceNode)this.entityCombobox.getSelectedItem();
        BigInteger totalSize = device.getTotalSpace();
        BigInteger availableSize = device.getNonAllocatedSpace();
        StorageDeviceSpace available = new StorageDeviceSpace(availableSize);
        StorageDeviceSpace total = new StorageDeviceSpace(totalSize);
        this.totalSizeLbl.setText("  Total Size: " + total.toString());
        this.availableSizeLbl.setText("Available Size: " + available.toString());
        this.setStorageUnits(device);
        this.endOfDiskBtn.setEnabled(!device.isConfigured());
        if (!this.endOfDiskBtn.isEnabled()) {
            this.supplySizeBtn.setSelected(true);
        }
        this.supplySizeBtn.setEnabled(!device.isConfigured());
    }

    private void setStorageUnits(DirectAccessDeviceNode device) {
        Integer blockSize = device.getBlockSize();
        if (blockSize == 1) {
            this.unitsCombobox.setVisible(false);
            this.unitsNumOfBlocksLbl.setVisible(true);
        } else {
            this.unitsCombobox.setVisible(true);
            this.unitsNumOfBlocksLbl.setVisible(false);
        }
    }

    private SrPanel createSizePanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.sizeRequiredLbl = new SrClientLabel("Size Required: ");
        this.sizeRequiredLbl.setFont(LookAndFill.GENERAL_FONT);
        this.sizeField = new SrDecimalTextField();
        this.unitsCombobox = new SrComboBox<StorageSize>((T[])this.UNITS);
        this.unitsCombobox.setFont(LookAndFill.GENERAL_FONT);
        this.unitsCombobox.setSelectedItem(StorageSize.GIGA);
        panel.add(this.sizeRequiredLbl);
        panel.add(this.sizeField);
        panel.add(this.unitsCombobox);
        this.unitsNumOfBlocksLbl.setVisible(false);
        panel.add(this.unitsNumOfBlocksLbl);
        return panel;
    }

    private SrPanel createSizeAndAddressPanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new GridLayout(4, 1));
        SrPanel sizePanel = this.createSizePanel();
        SrPanel withStartAddressPanel = this.createStartAddressPanel();
        SrPanel withoutStartAddressPanel = this.createNonStartAddressPanel();
        SrPanel addressPanel = this.createAddressPanel();
        panel.add(sizePanel);
        panel.add(withoutStartAddressPanel);
        panel.add(withStartAddressPanel);
        panel.add(addressPanel);
        panel.setBorder(new EmptyBorder(15, 15, 15, 15));
        return panel;
    }

    private BigDecimal getBytes() {
        String sizeTxt = this.sizeField.getText().trim();
        if (sizeTxt == null || sizeTxt.equals("")) {
            return null;
        }
        boolean isBlockSizeOne = this.unitsNumOfBlocksLbl.isVisible();
        BigDecimal bytes = new BigDecimal(sizeTxt);
        if (!isBlockSizeOne) {
            StorageSize unit = (StorageSize)this.unitsCombobox.getSelectedItem();
            BigDecimal biUnit = unit.getDecimalValue();
            bytes = bytes.multiply(biUnit);
        }
        return bytes;
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    private void setStartAddressPanelEnabled(boolean enabled) {
        this.fromLbl.setEnabled(enabled);
        this.addressField.setEnabled(enabled);
    }

    private void setSizePanelEnabled(boolean enabled) {
        this.sizeField.setEnabled(enabled);
        this.sizeRequiredLbl.setEnabled(enabled);
        this.unitsCombobox.setEnabled(enabled);
    }

    private void setSupplySizePanelEnabled(boolean enabled) {
        this.setSizePanelEnabled(enabled);
        this.setAddressPanelEnabled(enabled);
    }

    private void setAddressPanelEnabled(boolean enabled) {
        this.withStartAddBtn.setEnabled(enabled);
        this.withoutStartAddBtn.setEnabled(enabled);
        this.setStartAddressPanelEnabled(this.withStartAddBtn.isSelected() && enabled);
    }

    @Override
    public void removeListeners() {
    }
}

