/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrHexAddressTextField;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrLengthLimitedTextField;
import com.sanrad.swing.components.SrMultiTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.components.SrWidget;
import com.sanrad.swing.text.IntegerDocument;
import com.sanrad.swing.text.LengthLimitedDocument;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class NewPhysStorageDeviceDialog
extends SrOKCancelDialog {
    private NewStoragePropertyPanel panel = new NewStoragePropertyPanel();

    public NewPhysStorageDeviceDialog(JFrame owner) {
        this(owner, "", (PhysStorTransportTypeConstant)null);
    }

    public NewPhysStorageDeviceDialog(JFrame owner, String targetName, PhysStorTransportTypeConstant transType) {
        super(owner, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CREATE_STORAGE_DLG_TITLE), true);
        if (transType != null) {
            this.panel.entityNamePanel.setFieldByTransportType(transType);
            this.panel.transTypeWidget.getComponent().setValue(transType);
            this.panel.transTypeWidget.getComponent().setEnableComponent(false);
        }
        this.panel.entityNamePanel.setValue(targetName);
        this.addCenterPanel(this.panel);
        this.setOKAction();
        this.pack();
    }

    protected void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                ClusterNode cluster = SystemRootNode.getInstance().getCurrentClusterNode();
                if (cluster != null) {
                    PhysStorTransportTypeConstant transType = NewPhysStorageDeviceDialog.this.panel.getTransportType();
                    DirectAccessDeviceManager mgr = DirectAccessDeviceManager.getInstance();
                    SrFuture<Void> future = null;
                    PhysicalStorageTypeConstant type = NewPhysStorageDeviceDialog.this.panel.getStorageType();
                    String alias = NewPhysStorageDeviceDialog.this.panel.getAlias();
                    int lun = -1;
                    try {
                        lun = NewPhysStorageDeviceDialog.this.panel.getLUN();
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    String serialNumber = NewPhysStorageDeviceDialog.this.panel.getSerialNumber();
                    if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.equals(transType)) {
                        future = mgr.createISCSIPhysicalStorage(cluster, type, alias, NewPhysStorageDeviceDialog.this.panel.getTargetName(), lun, serialNumber);
                    } else if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI.equals(transType)) {
                        future = mgr.createPSCSIPhysicalStorage(cluster, type, alias, NewPhysStorageDeviceDialog.this.panel.getParallelScsiPort(), NewPhysStorageDeviceDialog.this.panel.getParallelScsiBus(), lun, serialNumber);
                    } else if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_FCP.equals(transType)) {
                        future = mgr.createFiberChannelStorage(cluster, type, alias, NewPhysStorageDeviceDialog.this.panel.getFiberChannelTargetName(), lun, serialNumber);
                    }
                    if (future != null) {
                        return Collections.singleton(future);
                    }
                }
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }
        };
        this.setOKAction(myOKAction);
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }

    private static class PhysStorageEntityNamePanel
    extends SrPanel
    implements SrComponent {
        SrHexAddressTextField fibreChannelTextField = null;
        SrMultiTextField parallelScsiTextField = null;
        SrLengthLimitedTextField iscsiTextField = null;
        PhysStorTransportTypeConstant type = null;
        FocusListener focusListener = null;
        final CardLayout layout = new CardLayout();
        private SrEventListenerManager m_listeners = new SrEventListenerManager();
        SrEventListenerManager.Informer propertyChangeInformer = new SrEventListenerManager.Informer<SrPropertyPanel.SrListener, PropertyChangeEvent>(){

            @Override
            public void inform(SrPropertyPanel.SrListener listener, PropertyChangeEvent event) {
                listener.propertyChange(event);
            }
        };

        PhysStorageEntityNamePanel() {
            this.setLayout(this.layout);
            this.fibreChannelTextField = new SrHexAddressTextField();
            SrTextField[] parallelScsiFields = new SrIntegerTextField[2];
            int maxPortValue = 4;
            parallelScsiFields[0] = new SrIntegerTextField(1, 1, 4);
            parallelScsiFields[0].setDocument(new IntegerDocument(){

                @Override
                protected boolean isValid(String currentValue, int addedValue, int offset) {
                    String leftValue = currentValue.substring(0, offset);
                    String rightValue = currentValue.substring(offset, currentValue.length());
                    String newStrValue = leftValue + addedValue + rightValue;
                    int newValue = Integer.parseInt(newStrValue);
                    return newValue >= 1 && newValue <= 4;
                }
            });
            parallelScsiFields[1] = new SrIntegerTextField(2, 15);
            this.parallelScsiTextField = new SrMultiTextField(parallelScsiFields, " / ");
            this.iscsiTextField = new SrLengthLimitedTextField(255);
            this.add((Component)this.fibreChannelTextField, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_FCP.toString());
            this.add((Component)this.parallelScsiTextField, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI.toString());
            this.add((Component)this.iscsiTextField, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.toString());
        }

        String getEnetityName() {
            return this.iscsiTextField.getText();
        }

        byte[] getFiberChannelTargetName() {
            if (this.type == PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_FCP) {
                return this.fibreChannelTextField.getBytes();
            }
            return null;
        }

        int getParallelScsiPort() {
            if (this.type == PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI) {
                return Integer.parseInt(this.parallelScsiTextField.getText(0));
            }
            return 0;
        }

        int getParallelScsiBus() {
            if (this.type == PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI) {
                return Integer.parseInt(this.parallelScsiTextField.getText(1));
            }
            return 0;
        }

        void setFieldByTransportType(PhysStorTransportTypeConstant type) {
            this.m_listeners.fireEvent(SrPropertyPanel.SrListener.class, null, this.propertyChangeInformer);
            this.type = type;
            this.layout.show(this, type.toString());
        }

        @Override
        public int compareTo(SrComponent com) {
            return 0;
        }

        @Override
        public Component getComponent() {
            return this;
        }

        public Object getValue() {
            return null;
        }

        @Override
        public boolean isComponentEnabled() {
            return true;
        }

        @Override
        public boolean isComponentValid() {
            if (this.type == PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI) {
                return this.iscsiTextField.isComponentValid();
            }
            if (this.type == PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI) {
                return this.parallelScsiTextField.isComponentValid();
            }
            if (this.type == PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_FCP) {
                return this.fibreChannelTextField.isComponentValid();
            }
            return false;
        }

        @Override
        public void addComponentFocusListener(FocusListener fl) {
            this.iscsiTextField.addComponentFocusListener(fl);
            this.parallelScsiTextField.addComponentFocusListener(fl);
            this.fibreChannelTextField.addComponentFocusListener(fl);
        }

        @Override
        public void addComponentValidListener(EventListener l) {
            this.m_listeners.add(l);
            this.iscsiTextField.addComponentValidListener(l);
            this.parallelScsiTextField.addComponentValidListener(l);
            this.fibreChannelTextField.addComponentValidListener(l);
        }

        @Override
        public void removeComponentFocusListener(FocusListener fl) {
            this.iscsiTextField.removeComponentFocusListener(fl);
            this.parallelScsiTextField.removeComponentFocusListener(fl);
            this.fibreChannelTextField.removeComponentFocusListener(fl);
        }

        @Override
        public void removeComponentValidListener(EventListener l) {
            this.m_listeners.remove(l);
            this.iscsiTextField.removeComponentValidListener(l);
            this.parallelScsiTextField.removeComponentValidListener(l);
            this.fibreChannelTextField.removeComponentValidListener(l);
        }

        @Override
        public void setEnableComponent(boolean enable) {
            this.iscsiTextField.setEnabled(enable);
            this.parallelScsiTextField.setEnabled(enable);
            this.fibreChannelTextField.setEnabled(enable);
        }

        public void setValue(Object value) {
            if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.equals(this.type)) {
                this.iscsiTextField.setValue(value);
            } else if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI.equals(this.type)) {
                this.parallelScsiTextField.setValue(value);
            } else if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_FCP.equals(this.type)) {
                this.fibreChannelTextField.setValue(value);
            }
        }
    }

    private static class NewStoragePropertyPanel
    extends SrPropertyPanel {
        private SrWidget storTypeWidget = new SrWidget();
        private SrWidget aliasWidget = new SrWidget();
        private SrWidget targetNameWidget = new SrWidget();
        private SrWidget lunWidget = new SrWidget();
        private SrWidget transTypeWidget = new SrWidget();
        private SrWidget serialNumberWidget = new SrWidget();
        private SrWidget targetNameLabel;
        private static final String TARGET_NAME = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CREATE_STORAGE_DLG_TARGET_LBL);
        private static final String PSCSI_PORT_BUS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CREATE_STORAGE_DLG_PSCSI_PORT_BUS_LBL);
        GridBagConstraints grid_0_0 = new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 0, this.m_leftInsets, 0, 0);
        GridBagConstraints grid_0_1 = new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 0, this.m_leftInsets, 0, 0);
        GridBagConstraints grid_0_2 = new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 17, 0, this.m_leftInsets, 0, 0);
        GridBagConstraints grid_0_3 = new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 17, 0, this.m_leftInsets, 0, 0);
        GridBagConstraints grid_0_4 = new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 0, this.m_leftInsets, 0, 0);
        GridBagConstraints grid_0_5 = new GridBagConstraints(1, 5, 1, 1, 0.1, 0.0, 17, 0, this.m_leftInsets, 0, 0);
        GridBagConstraints grid_1_0 = new GridBagConstraints(2, 0, 1, 1, 0.7, 0.0, 17, 2, this.m_rightInsets, 0, 0);
        GridBagConstraints grid_1_1 = new GridBagConstraints(2, 1, 1, 1, 0.7, 0.0, 17, 0, this.m_rightInsets, 0, 0);
        GridBagConstraints grid_1_2 = new GridBagConstraints(2, 2, 1, 1, 0.7, 0.0, 17, 0, this.m_rightInsets, 0, 0);
        GridBagConstraints grid_1_3 = new GridBagConstraints(2, 3, 1, 1, 0.7, 0.0, 17, 0, this.m_rightInsets, 0, 0);
        GridBagConstraints grid_1_4 = new GridBagConstraints(2, 4, 1, 1, 0.7, 0.0, 17, 0, this.m_rightInsets, 0, 0);
        GridBagConstraints grid_1_5 = new GridBagConstraints(2, 5, 1, 1, 0.7, 0.0, 17, 2, this.m_rightInsets, 0, 0);
        PhysStorageEntityNamePanel entityNamePanel = new PhysStorageEntityNamePanel();

        NewStoragePropertyPanel() {
            super("mainPanel");
            this.addMyComponents();
        }

        PhysicalStorageTypeConstant getStorageType() {
            return (PhysicalStorageTypeConstant)this.storTypeWidget.getComponent().getValue();
        }

        String getAlias() {
            return (String)this.aliasWidget.getComponent().getValue();
        }

        String getTargetName() {
            return this.entityNamePanel.getEnetityName();
        }

        byte[] getFiberChannelTargetName() {
            return this.entityNamePanel.getFiberChannelTargetName();
        }

        int getParallelScsiPort() {
            return this.entityNamePanel.getParallelScsiPort();
        }

        int getParallelScsiBus() {
            return this.entityNamePanel.getParallelScsiBus();
        }

        int getLUN() {
            int lunInt = Integer.parseInt((String)this.lunWidget.getComponent().getValue());
            return lunInt;
        }

        PhysStorTransportTypeConstant getTransportType() {
            return (PhysStorTransportTypeConstant)this.transTypeWidget.getComponent().getValue();
        }

        String getSerialNumber() {
            return (String)this.serialNumberWidget.getComponent().getValue();
        }

        private void addMyComponents() {
            SrWidget aliasLabel = this.createLabelWidget(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CREATE_STORAGE_DLG_ALIAS_LBL));
            this.aliasWidget.setName("alias");
            this.aliasWidget.setMandatory(true);
            SrTextField aliasField = new SrTextField();
            aliasField.setDocument(new LengthLimitedDocument(80));
            this.aliasWidget.setComponent(aliasField);
            this.addProperty(aliasLabel, this.aliasWidget);
            SrWidget storTypeLabel = this.createLabelWidget(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CREATE_STORAGE_DLG_STORAGETYPE_LBL));
            this.storTypeWidget.setName("Storage Type");
            this.storTypeWidget.setComponent(this.createComboBoxForStorageType());
            this.storTypeWidget.setConstraints(this.grid_1_1);
            this.addProperty(storTypeLabel, this.storTypeWidget);
            SrWidget transTypeLabel = this.createLabelWidget(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CREATE_STORAGE_DLG_TRANSPORTTYPE_LBL));
            this.transTypeWidget.setName("Transport type");
            this.transTypeWidget.setComponent(this.createComboBoxForTrsportType());
            this.transTypeWidget.setConstraints(this.grid_1_2);
            this.addProperty(transTypeLabel, this.transTypeWidget);
            this.entityNamePanel.setFieldByTransportType((PhysStorTransportTypeConstant)this.transTypeWidget.getComponent().getValue());
            this.targetNameLabel = this.createLabelWidget(TARGET_NAME);
            this.targetNameWidget.setName("targetName");
            this.targetNameWidget.setComponent(this.entityNamePanel);
            this.targetNameWidget.setMandatory(true);
            this.addProperty(this.targetNameLabel, this.targetNameWidget);
            SrWidget lunLabel = this.createLabelWidget(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CREATE_STORAGE_DLG_LUN_LBL));
            this.lunWidget.setName("lun");
            SrIntegerTextField lunTF = new SrIntegerTextField();
            lunTF.setMaxValue(Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.MAX_LUN_VALUE)));
            this.lunWidget.setComponent(lunTF);
            this.lunWidget.setMandatory(true);
            this.lunWidget.setConstraints(this.grid_1_4);
            this.addProperty(lunLabel, this.lunWidget);
            SrWidget serialNumberLabel = this.createLabelWidget(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CREATE_STORAGE_DLG_SERIAL_NUMBER_LBL));
            this.serialNumberWidget.setName("serialNumber");
            this.serialNumberWidget.setComponent(new SrTextField());
            this.addProperty(serialNumberLabel, this.serialNumberWidget);
        }

        private SrComboBox createComboBoxForStorageType() {
            SrComboBox<PhysicalStorageTypeConstant> cb = new SrComboBox<PhysicalStorageTypeConstant>((T[])new PhysicalStorageTypeConstant[]{PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE});
            cb.setEnabled(false);
            return cb;
        }

        private SrComboBox createComboBoxForTrsportType() {
            PhysStorTransportTypeConstant[] objs = new PhysStorTransportTypeConstant[]{PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_FCP, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI};
            SrComboBox<PhysStorTransportTypeConstant> cb = new SrComboBox<PhysStorTransportTypeConstant>((T[])objs);
            cb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        PhysStorTransportTypeConstant type = (PhysStorTransportTypeConstant)e.getItem();
                        if (type == PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI) {
                            ((JLabel)((Object)NewStoragePropertyPanel.this.targetNameLabel.getComponent())).setText(PSCSI_PORT_BUS);
                        } else {
                            ((JLabel)((Object)NewStoragePropertyPanel.this.targetNameLabel.getComponent())).setText(TARGET_NAME);
                        }
                        NewStoragePropertyPanel.this.entityNamePanel.setFieldByTransportType(type);
                        NewStoragePropertyPanel.this.onUpdateEvent(e);
                    }
                }
            });
            return cb;
        }
    }
}

