/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceAdapter;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientCheckBox;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.storage.dialogs.SubDirectAccessDevicesList;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.license.LicenseManager;
import com.sanrad.nms.server.license.SrFeatureNameConstant;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.SrTextPane;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.StorageSize;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class DirectAccessDevicePropertiesDialog
extends SrOKCancelDialog {
    private static final SrLicenseTreePath createSubdiskPath = new SrLicenseTreePath(SrLicenseTreePath.SUBDISK_PATH, SrFeatureNameConstant.CREATE);
    private static final String RAID_STATUS_NORMAL_STRING = "NORMAL";
    private SrClientLabel diskAliasLbl;
    private SrClientLabel serialNumberLbl;
    private SrClientLabel scsiVersionLbl;
    private SrClientLabel productIdLbl;
    private SrClientLabel revisionLevelLbl;
    private SrClientLabel entityNameLbl;
    private SrClientLabel lunLbl;
    private SrClientLabel typeLbl;
    private SrClientLabel transportTypeLbl;
    private SrClientLabel vendorLbl;
    private SrClientLabel infoLbl;
    private SrClientLabel capacityLbl;
    private SrClientLabel blockSizeLbl;
    private SrClientLabel freeSpaceLbl;
    private SrClientLabel volumeLbl;
    private SrClientLabel exposedLbl;
    private SrClientLabel wceLbl;
    private SrClientLabel wpLbl;
    private SrTextField diskAliasFld;
    private SrTextField serialNumberFld;
    private SrTextField scsiVersionFld;
    private SrTextField productIdFld;
    private SrTextField revisionLevelFld;
    private SrTextField entityNameFld;
    private SrIntegerTextField lunFld;
    private SrTextField typeFld;
    private SrTextField transportTypeFld;
    private SrTextField vendorFld;
    private JTextArea infoFld;
    private SrTextField capacityFld;
    private SrTextField blockSizeFld;
    private SrTextField freeSpaceBtn;
    private JCheckBox volumeBtn;
    private JCheckBox exposedBtn;
    private JTabbedPane tabs;
    private SubDirectAccessDevicesList list;
    private JComponent wceBtn = null;
    private JComponent wpBtn = null;
    protected SrClientLabel volumeStateLbl = new SrClientLabel("State: ");
    protected SrTextPane volState = new SrTextPane();
    private DiskPropertiesListener m_listener;
    private StorageDeviceNode<?> m_storageNode;
    private JFrame ownerFrame;
    private boolean nodeIsDirectAccessDevice;
    private SrClientLabel m_isAllocableLabel;
    private SrClientCheckBox m_isAllocableCheckBox;

    public DirectAccessDevicePropertiesDialog(JFrame owner, StorageDeviceNode disknode, SubDirectAccessDeviceNode subdisk) {
        this(owner, disknode);
        this.showSelectedSubdisk(subdisk);
    }

    public DirectAccessDevicePropertiesDialog(JFrame owner, StorageDeviceNode disknode) {
        super(owner, "Disk Properties", false, SystemRootNode.getInstance().getClusterNodeOfSource(disknode));
        this.ownerFrame = owner;
        this.m_storageNode = disknode;
        this.nodeIsDirectAccessDevice = this.m_storageNode instanceof DirectAccessDeviceNode;
        this.m_listener = new DiskPropertiesListener();
        this.initComponents();
        this.setSizeAndMoveToCenter(370, 495);
        this.fixSizes();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DirectAccessDevicePropertiesDialog.this.m_storageNode.setUserObject(null);
            }
        });
        this.pack();
        SrClientAction<Void, Void> okAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                boolean wce;
                String info;
                String al = DirectAccessDevicePropertiesDialog.this.diskAliasFld.getText();
                HashMap<ClientParameterCode, Object> params = new HashMap<ClientParameterCode, Object>();
                if (!al.equalsIgnoreCase(DirectAccessDevicePropertiesDialog.this.m_storageNode.getAlias())) {
                    params.put(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS, al);
                }
                if (!(info = DirectAccessDevicePropertiesDialog.this.infoFld.getText()).equalsIgnoreCase(DirectAccessDevicePropertiesDialog.this.m_storageNode.getInfo())) {
                    params.put(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_INFO, info);
                }
                if (DirectAccessDevicePropertiesDialog.this.wceBtn instanceof JCheckBox && (wce = ((JCheckBox)DirectAccessDevicePropertiesDialog.this.wceBtn).isSelected()) != ((DirectAccessDeviceNode)DirectAccessDevicePropertiesDialog.this.m_storageNode).isWriteCacheEnabled()) {
                    params.put(ClientParameterCode.DIRECT_ACCESS_DEVICE_WCE_ENABLE_STATE, new Boolean(wce));
                }
                if (DirectAccessDevicePropertiesDialog.this.m_storageNode instanceof DirectAccessDeviceNode) {
                    boolean isAllocableCurrentState = ((DirectAccessDeviceNode)DirectAccessDevicePropertiesDialog.this.m_storageNode).isAllocable();
                    boolean isAllocableInCheckBox = DirectAccessDevicePropertiesDialog.this.m_isAllocableCheckBox.isSelected();
                    if (isAllocableInCheckBox != isAllocableCurrentState) {
                        params.put(ClientParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE, new Boolean(isAllocableInCheckBox));
                    }
                }
                if (!params.isEmpty()) {
                    return Collections.singleton(ClientAOImpl.getInstance().changeElements(Collections.singleton(DirectAccessDevicePropertiesDialog.this.m_storageNode.getIdentifier()), params));
                }
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String al = DirectAccessDevicePropertiesDialog.this.diskAliasFld.getText();
                if (al.equals("")) {
                    return "Device alias isn't valid.";
                }
                return null;
            }
        };
        this.setOKAction(okAction);
    }

    @Override
    public void dispose() {
        this.m_storageNode.setUserObject(null);
        super.dispose();
    }

    private void initComponents() {
        boolean bSplitsPanel;
        SrPanel generalPanel = this.createGeneralTab();
        SrPanel subdisksPanel = null;
        List<RemoteObject> splits = null;
        if (this.m_storageNode instanceof DirectAccessDeviceNode) {
            splits = ((DirectAccessDeviceNode)this.m_storageNode).getSplits();
        }
        boolean bl = bSplitsPanel = splits != null && splits.size() > 0;
        if (bSplitsPanel) {
            subdisksPanel = this.createSubdiksTab(splits);
        }
        this.tabs = new JTabbedPane();
        this.tabs.setBackground(LookAndFill.DIALOG_COLOR);
        this.tabs.addTab("General", generalPanel);
        SrPanel raidDetailsPanel = this.createRaidDetailsTab();
        this.tabs.addTab("RAID Details", raidDetailsPanel);
        boolean isSubdiskTabVisible = LicenseManager.getInstance().isVisible(SrLicenseTreePath.SUBDISK_PATH, this.m_workingCluster.getCapability());
        if (isSubdiskTabVisible && subdisksPanel != null) {
            this.tabs.addTab("Subdisks", subdisksPanel);
        }
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.tabs, "Center");
        this.buttonsPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.addCenterPanel(mainPanel);
    }

    private void showSelectedSubdisk(SubDirectAccessDeviceNode subdisk) {
        if (this.tabs.getTabCount() > 1) {
            this.tabs.setSelectedIndex(1);
            this.list.setSelectedValue(subdisk, true);
        }
    }

    private SrPanel createSubdiksTab(List splits) {
        SrPanel panel = new SrPanel();
        panel.setLayout(new BorderLayout());
        if (splits != null) {
            ArrayList<SrTreeNode> subdisks = new ArrayList<SrTreeNode>();
            for (int i = 0; i < splits.size(); ++i) {
                SrTreeNode sd = SystemRootNode.getInstance().getRefByStub((RemoteObject)splits.get(i));
                if (sd == null) continue;
                subdisks.add(sd);
            }
            if (subdisks.size() == 0) {
                return null;
            }
            if (splits != null) {
                this.list = new SubDirectAccessDevicesList(subdisks, (DirectAccessDeviceNode)this.m_storageNode, this, this, this.ownerFrame);
                SrScrollPane scroll = new SrScrollPane(this.list);
                panel.add((Component)scroll, "Center");
            }
            return panel;
        }
        return null;
    }

    private SrPanel createRaidDetailsTab() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        SrLabelField titleLabel = new SrLabelField("Storage RAID Information:");
        SrLabelField raidLevelLabel = new SrLabelField("Raid Level: ");
        SrTextField raidLevelField = new SrTextField(20);
        raidLevelField.setEnabled(false);
        SrLabelField raidStatusLabel = new SrLabelField("Raid Status: ");
        SrTextField raidStatusField = new SrTextField(20);
        raidStatusField.setEnabled(false);
        SrLabelField raidCreationTimeLabel = new SrLabelField("Raid Creation Time: ");
        SrTextField raidCreationTimeField = new SrTextField(20);
        raidCreationTimeField.setEnabled(false);
        SrLabelField raidSysNameLabel = new SrLabelField("Raid System Name: ");
        SrTextField raidSysNameField = new SrTextField(20);
        raidSysNameField.setEnabled(false);
        SrLabelField raidModelLabel = new SrLabelField("Raid Model: ");
        SrTextField raidModelField = new SrTextField(20);
        raidModelField.setEnabled(false);
        SrLabelField raidFwRevLabel = new SrLabelField("Raid Firmware Rev.: ");
        SrTextField raidFwRevField = new SrTextField(20);
        raidFwRevField.setEnabled(false);
        SrLabelField raidCtrlUrl1Label = new SrLabelField("Raid Controller URL 1: ");
        SrTextField raidCtrlUrl1Field = new SrTextField(20);
        raidCtrlUrl1Field.setEnabled(false);
        SrLabelField raidCtrlUrl2Label = new SrLabelField("Raid Controller URL 2: ");
        SrTextField raidCtrlUrl2Field = new SrTextField(20);
        raidCtrlUrl2Field.setEnabled(false);
        if (this.m_storageNode instanceof DirectAccessDeviceNode) {
            BigInteger creationTime;
            SrBITSConstant raidStatus;
            DirectAccessDeviceNode curDisk = (DirectAccessDeviceNode)this.m_storageNode;
            PhysicalStorageRaidLevelConstant raidLevel = curDisk.getRaidLevel();
            if (raidLevel != null) {
                raidLevelField.setText(raidLevel.toString());
            }
            if ((raidStatus = curDisk.getRaidStatus()) != null) {
                String status = RAID_STATUS_NORMAL_STRING;
                if (raidStatus.getBitNumber() != 0) {
                    status = raidStatus.toString();
                }
                raidStatusField.setText(status);
            }
            if ((creationTime = curDisk.getRaidCreationTime()) != null) {
                Long longVal = new Long(creationTime.toString());
                longVal = longVal * 1000L;
                String textToSet = DateFormat.getDateTimeInstance(1, 3, Locale.ENGLISH).format(new Date(longVal));
                raidCreationTimeField.setText(textToSet);
            }
            raidSysNameField.setText(curDisk.getRaidSysName());
            raidModelField.setText(curDisk.getRaidSysModelName());
            raidFwRevField.setText(curDisk.getRevisionLevel());
            raidCtrlUrl1Field.setText(curDisk.getRaidUrlCtrl1());
            raidCtrlUrl2Field.setText(curDisk.getRaidUrlCtrl2());
        }
        c.insets.top = 8;
        c.insets.right = 8;
        c.insets.left = 8;
        c.insets.bottom = 15;
        c.anchor = 23;
        c.weightx = 0.0;
        c.gridy = 1;
        c.gridx = 0;
        mainPanel.add((Component)titleLabel, c);
        c.gridy = 2;
        c.gridx = 0;
        mainPanel.add((Component)raidSysNameLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        mainPanel.add((Component)raidSysNameField, c);
        c.gridy = 3;
        c.gridx = 0;
        mainPanel.add((Component)raidModelLabel, c);
        c.gridx = 1;
        mainPanel.add((Component)raidModelField, c);
        c.gridy = 4;
        c.gridx = 0;
        mainPanel.add((Component)raidLevelLabel, c);
        c.gridx = 1;
        mainPanel.add((Component)raidLevelField, c);
        c.gridy = 5;
        c.gridx = 0;
        mainPanel.add((Component)raidFwRevLabel, c);
        c.gridx = 1;
        mainPanel.add((Component)raidFwRevField, c);
        c.gridy = 6;
        c.gridx = 0;
        mainPanel.add((Component)raidStatusLabel, c);
        c.gridx = 1;
        mainPanel.add((Component)raidStatusField, c);
        c.gridy = 7;
        c.gridx = 0;
        mainPanel.add((Component)raidCreationTimeLabel, c);
        c.gridx = 1;
        mainPanel.add((Component)raidCreationTimeField, c);
        c.gridy = 8;
        c.gridx = 0;
        mainPanel.add((Component)raidCtrlUrl1Label, c);
        c.gridx = 1;
        mainPanel.add((Component)raidCtrlUrl1Field, c);
        c.gridy = 9;
        c.gridx = 0;
        c.weighty = 1.0;
        mainPanel.add((Component)raidCtrlUrl2Label, c);
        c.gridx = 1;
        mainPanel.add((Component)raidCtrlUrl2Field, c);
        return mainPanel;
    }

    private SrPanel createGeneralTab() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(12, 1));
        this.diskAliasLbl = new SrClientLabel("Alias: ");
        this.diskAliasFld = new SrTextField();
        this.diskAliasFld.setText(this.m_storageNode.getAlias());
        SrPanel aliasPanel = this.createSrPanel(this.diskAliasLbl, this.diskAliasFld);
        String nexsanStr = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.NEXSAN_STRING);
        if (nexsanStr.equalsIgnoreCase(this.m_storageNode.getVendor())) {
            this.diskAliasFld.setEditable(false);
        }
        this.serialNumberLbl = new SrClientLabel("Serial No.: ");
        this.serialNumberFld = new SrTextField();
        this.serialNumberFld.setText(this.m_storageNode.getSerialNumber());
        this.serialNumberFld.setEnabled(false);
        SrPanel serialNumberPanel = this.createSrPanel(this.serialNumberLbl, this.serialNumberFld);
        this.scsiVersionLbl = new SrClientLabel("SCSI Ver.: ");
        this.scsiVersionFld = new SrTextField();
        this.scsiVersionFld.setText(String.valueOf(this.m_storageNode.getSCSIVersion()));
        this.scsiVersionFld.setEnabled(false);
        SrPanel scsiVersionPanel = this.createSrPanel(this.scsiVersionLbl, this.scsiVersionFld);
        this.productIdLbl = new SrClientLabel("Product ID: ");
        this.productIdFld = new SrTextField();
        this.productIdFld.setText(this.m_storageNode.getProductId());
        this.productIdFld.setEnabled(false);
        SrPanel productIdPanel = this.createSrPanel(this.productIdLbl, this.productIdFld);
        this.revisionLevelLbl = new SrClientLabel("Revision level: ");
        this.revisionLevelFld = new SrTextField();
        this.revisionLevelFld.setText(this.m_storageNode.getRevisionLevel());
        this.revisionLevelFld.setEnabled(false);
        SrPanel revisionLevelPanel = this.createSrPanel(this.revisionLevelLbl, this.revisionLevelFld);
        this.entityNameLbl = new SrClientLabel("Target Name: ");
        this.entityNameFld = new SrTextField();
        this.entityNameFld.setText(this.m_storageNode.getEntityName());
        this.entityNameFld.setEnabled(false);
        SrPanel entityPanel = this.createSrPanel(this.entityNameLbl, this.entityNameFld);
        this.lunLbl = new SrClientLabel("LUN: ");
        this.lunFld = new SrIntegerTextField(20);
        this.lunFld.setFont(LookAndFill.GENERAL_FONT);
        String lun = this.m_storageNode.getRemoteLU();
        this.lunFld.setText(lun);
        this.lunFld.setEnabled(false);
        SrPanel lunPanel = this.createSrPanel(this.lunLbl, this.lunFld);
        this.typeLbl = new SrClientLabel("Type: ");
        this.typeFld = new SrTextField();
        this.typeFld.setText(this.m_storageNode.getDeviceType());
        this.typeFld.setEnabled(false);
        SrPanel typePanel = this.createSrPanel(this.typeLbl, this.typeFld);
        this.transportTypeLbl = new SrClientLabel("Transport Type: ");
        this.transportTypeFld = new SrTextField(this.m_storageNode.getTransportType());
        this.transportTypeFld.setEnabled(false);
        SrPanel transportTypePanel = this.createSrPanel(this.transportTypeLbl, this.transportTypeFld);
        this.vendorLbl = new SrClientLabel("Vendor: ");
        this.vendorFld = new SrTextField();
        this.vendorFld.setText(this.m_storageNode.getVendor());
        this.vendorFld.setEnabled(false);
        SrPanel vendorPanel = this.createSrPanel(this.vendorLbl, this.vendorFld);
        this.infoLbl = new SrClientLabel("Information: ");
        this.infoFld = new JTextArea(2, 20);
        this.infoFld.setText(this.m_storageNode.getInfo());
        this.infoFld.setFont(LookAndFill.GENERAL_FONT);
        SrScrollPane scroll = new SrScrollPane(this.infoFld);
        this.infoLbl.setAlignmentY(scroll.getAlignmentY());
        SrPanel infoPanel = this.createSrPanel(this.infoLbl, scroll);
        this.capacityLbl = new SrClientLabel("Capacity: ");
        this.capacityFld = new SrTextField();
        String capacity = "";
        if (this.nodeIsDirectAccessDevice) {
            capacity = StorageSize.getSizeAsString(((DirectAccessDeviceNode)this.m_storageNode).getTotalSpace());
        }
        this.capacityFld.setText(capacity);
        this.capacityFld.setEnabled(false);
        SrPanel capacityPanel = this.createSrPanel(this.capacityLbl, this.capacityFld);
        this.blockSizeLbl = new SrClientLabel("Block Size: ");
        this.blockSizeFld = new SrTextField();
        if (this.m_storageNode.isProcessor()) {
            this.blockSizeFld.setText("----");
        } else if (this.m_storageNode.getBlockSize() != null) {
            String blockSize = this.m_storageNode.getBlockSize().toString();
            this.blockSizeFld.setText(blockSize + " Bytes");
        } else {
            this.blockSizeFld.setText(" N/A ");
        }
        this.blockSizeFld.setEnabled(false);
        SrPanel blockSizePanel = this.createSrPanel(this.blockSizeLbl, this.blockSizeFld);
        this.freeSpaceLbl = new SrClientLabel("Free Space: ");
        this.freeSpaceBtn = new SrTextField();
        String freeSpace = "";
        if (this.nodeIsDirectAccessDevice) {
            freeSpace = StorageSize.getSizeAsString(((DirectAccessDeviceNode)this.m_storageNode).getNonAllocatedSpace());
        }
        this.freeSpaceBtn.setText(freeSpace);
        this.freeSpaceBtn.setEnabled(false);
        SrPanel freeSpacePanel = this.createSrPanel(this.freeSpaceLbl, this.freeSpaceBtn);
        this.exposedLbl = new SrClientLabel("Exposed: ");
        this.exposedBtn = new JCheckBox();
        this.exposedBtn.setFont(LookAndFill.GENERAL_FONT);
        this.exposedBtn.setBackground(LookAndFill.DIALOG_COLOR);
        boolean isExposed = this.m_storageNode.isExposed();
        this.exposedBtn.setSelected(isExposed);
        this.exposedBtn.setEnabled(false);
        SrPanel exposedPanel = this.createSrPanel(this.exposedLbl, this.exposedBtn);
        this.volumeLbl = new SrClientLabel("Used: ");
        this.volumeBtn = new JCheckBox();
        this.volumeBtn.setFont(LookAndFill.GENERAL_FONT);
        this.volumeBtn.setBackground(LookAndFill.DIALOG_COLOR);
        boolean selected = this.m_storageNode.getParent() instanceof VolumeTreeNode || isExposed;
        boolean hasSubdisk = this.hasSubdisk();
        this.volumeBtn.setSelected(selected || hasSubdisk);
        this.volumeBtn.setEnabled(false);
        SrPanel volumePanel = this.createSrPanel(this.volumeLbl, this.volumeBtn);
        mainPanel.add(aliasPanel);
        mainPanel.add(serialNumberPanel);
        mainPanel.add(productIdPanel);
        mainPanel.add(revisionLevelPanel);
        mainPanel.add(scsiVersionPanel);
        mainPanel.add(entityPanel);
        mainPanel.add(lunPanel);
        mainPanel.add(typePanel);
        mainPanel.add(vendorPanel);
        mainPanel.add(transportTypePanel);
        mainPanel.add(blockSizePanel);
        mainPanel.add(capacityPanel);
        mainPanel.add(freeSpacePanel);
        mainPanel.add(exposedPanel);
        mainPanel.add(volumePanel);
        mainPanel.add(infoPanel);
        SrScrollPane stateScroll = new SrScrollPane(this.volState);
        stateScroll.setMaximumSize(new Dimension(15, 3));
        SrPanel statePanel = this.createSrPanel(this.volumeStateLbl, stateScroll);
        this.setStateLabel();
        this.volState.setEditable(false);
        mainPanel.add(statePanel);
        if (this.nodeIsDirectAccessDevice) {
            Boolean isWCE = ((DirectAccessDeviceNode)this.m_storageNode).isWriteCacheEnabled();
            this.wceLbl = new SrClientLabel("Write Cache Enabled: ");
            if (isWCE != null) {
                this.wceBtn = new JCheckBox();
                ((JCheckBox)this.wceBtn).setFont(LookAndFill.GENERAL_FONT);
                this.wceBtn.setBackground(LookAndFill.DIALOG_COLOR);
                ((JCheckBox)this.wceBtn).setSelected(isWCE);
            } else {
                this.wceBtn = this.getUnknownTextField();
            }
            SrPanel wcePanel = this.createSrPanel(this.wceLbl, this.wceBtn);
            Boolean isWP = ((DirectAccessDeviceNode)this.m_storageNode).isWriteProtected();
            this.wpLbl = new SrClientLabel("Write Protected: ");
            if (isWP != null) {
                this.wpBtn = new JCheckBox();
                this.wpBtn.setFont(LookAndFill.GENERAL_FONT);
                this.wpBtn.setBackground(LookAndFill.DIALOG_COLOR);
                ((JCheckBox)this.wpBtn).setSelected(isWP);
                ((JCheckBox)this.wpBtn).setEnabled(false);
            } else {
                this.wpBtn = this.getUnknownTextField();
            }
            SrPanel wpPanel = this.createSrPanel(this.wpLbl, this.wpBtn);
            this.m_isAllocableLabel = new SrClientLabel("VSS Allocable: "){

                @Override
                public SrLicenseTreePath getLicensePath() {
                    return createSubdiskPath;
                }
            };
            this.m_isAllocableCheckBox = new SrClientCheckBox(){

                @Override
                public SrLicenseTreePath getLicensePath() {
                    return createSubdiskPath;
                }
            };
            this.m_isAllocableCheckBox.setFont(LookAndFill.GENERAL_FONT);
            this.m_isAllocableCheckBox.setBackground(LookAndFill.DIALOG_COLOR);
            boolean isAllocable = ((DirectAccessDeviceNode)this.m_storageNode).isAllocable();
            this.m_isAllocableCheckBox.setSelected(isAllocable);
            this.m_isAllocableCheckBox.setEnabled(true);
            SrPanel isAllocablePanel = this.createSrPanel(this.m_isAllocableLabel, this.m_isAllocableCheckBox);
            mainPanel.add(wpPanel);
            mainPanel.add(wcePanel);
            mainPanel.add(isAllocablePanel);
        }
        return mainPanel;
    }

    private void setStateLabel() {
        String state = this.m_storageNode.getVolStateStr();
        this.volState.setText(state == null ? ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE) : state);
    }

    private boolean hasSubdisk() {
        List<RemoteObject> splits;
        if (this.nodeIsDirectAccessDevice && (splits = ((DirectAccessDeviceNode)this.m_storageNode).getSplits()) != null) {
            for (RemoteObject obj : splits) {
                if (!(obj instanceof SubDirectAccessDevice)) continue;
                return true;
            }
        }
        return false;
    }

    private void fixSizes() {
        Dimension dim = this.transportTypeLbl.getPreferredSize();
        this.entityNameLbl.setPreferredSize(dim);
        this.diskAliasLbl.setPreferredSize(dim);
        this.infoLbl.setPreferredSize(dim);
        this.revisionLevelLbl.setPreferredSize(dim);
        this.typeLbl.setPreferredSize(dim);
        this.lunLbl.setPreferredSize(dim);
        this.vendorLbl.setPreferredSize(dim);
        this.capacityLbl.setPreferredSize(dim);
        this.blockSizeLbl.setPreferredSize(dim);
        this.freeSpaceLbl.setPreferredSize(dim);
        this.volumeLbl.setPreferredSize(dim);
        this.exposedLbl.setPreferredSize(dim);
        if (this.nodeIsDirectAccessDevice) {
            this.m_isAllocableLabel.setPreferredSize(dim);
        }
        this.serialNumberLbl.setPreferredSize(dim);
        this.scsiVersionLbl.setPreferredSize(dim);
        this.productIdLbl.setPreferredSize(dim);
        dim = new Dimension(this.entityNameFld.getPreferredSize().width, this.entityNameFld.getPreferredSize().height);
        if (dim.getWidth() < this.lunFld.getPreferredSize().getWidth()) {
            dim = new Dimension(this.lunFld.getPreferredSize().width, this.lunFld.getPreferredSize().height);
        }
        this.entityNameFld.setPreferredSize(dim);
        this.lunFld.setPreferredSize(dim);
        this.blockSizeFld.setPreferredSize(dim);
        this.typeFld.setPreferredSize(dim);
        this.vendorFld.setPreferredSize(dim);
        this.capacityFld.setPreferredSize(dim);
        this.transportTypeFld.setPreferredSize(dim);
        this.diskAliasFld.setPreferredSize(dim);
        this.freeSpaceBtn.setPreferredSize(dim);
        this.serialNumberFld.setPreferredSize(dim);
        this.scsiVersionFld.setPreferredSize(dim);
        this.productIdFld.setPreferredSize(dim);
        this.revisionLevelFld.setPreferredSize(dim);
    }

    @Override
    public void doOnCancel() {
        this.m_storageNode.setUserObject(null);
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    @Override
    public void removeListeners() {
        DirectAccessDeviceManager.getInstance().removeDirectAccessDeviceListener(this.m_listener);
    }

    @Override
    public void addListeners() {
        DirectAccessDeviceManager.getInstance().addDirectAccessDeviceListener(this.m_listener);
    }

    class DiskPropertiesListener
    extends DirectAccessDeviceAdapter {
        DiskPropertiesListener() {
        }

        @Override
        public void directAccessDeviceAliasChanged(DirectAccessDeviceEvent event) {
            if (((LogicObject)DirectAccessDevicePropertiesDialog.this.m_storageNode.getStub()).equals(event.getStub())) {
                DirectAccessDevicePropertiesDialog.this.diskAliasFld.setText(event.getAlias());
            }
        }

        @Override
        public void directAccessDeviceInfoChanged(DirectAccessDeviceEvent event) {
            if (((LogicObject)DirectAccessDevicePropertiesDialog.this.m_storageNode.getStub()).equals(event.getStub())) {
                DirectAccessDevicePropertiesDialog.this.infoFld.setText(event.getAlias());
            }
        }
    }
}

