/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage.dialogs;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrRadioButton;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;

public class BlinkDurationDialog
extends SrOKCancelDialog {
    private StorageDeviceNode[] myNodes;
    private SrIntegerTextField durationFld;
    private SrRadioButton foreverButton;
    private SrRadioButton durationButton;
    private SrClientLabel limitedTimeLbl;
    private SrClientLabel foreverLbl;
    private SrClientLabel durationLbl;

    public BlinkDurationDialog(JFrame frame, StorageDeviceNode[] nodes) {
        super(frame, "Duration", true, SystemRootNode.getInstance().getClusterNodeOfSource(nodes[0]));
        this.myNodes = nodes;
        this.initComponents();
        this.enableDurationPanel();
        this.setSizeAndMoveToCenter(300, 200);
        SrClientAction<Void, Void> okAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                HashMap<ClientParameterCode, Comparable<Boolean>> params = new HashMap<ClientParameterCode, Comparable<Boolean>>();
                params.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE, new Boolean(true));
                if (BlinkDurationDialog.this.foreverButton.isSelected()) {
                    params.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_DURATION, new Integer(0));
                } else {
                    String text = BlinkDurationDialog.this.durationFld.getText();
                    Integer duration = Integer.decode(text);
                    params.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_DURATION, duration);
                }
                return DirectAccessDeviceManager.getInstance().blinkDisks(BlinkDurationDialog.this.myNodes, params);
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                if (!BlinkDurationDialog.this.foreverButton.isSelected() && BlinkDurationDialog.this.durationFld.getText().equals("")) {
                    return "You must enter the duration (in seconds) or select Forever duration.";
                }
                return null;
            }
        };
        this.foreverButton.addItemListener(new View.ToggleButtonListener(okAction));
        this.durationFld.getDocument().addDocumentListener(new View.ViewTextListener(okAction));
        this.setOKAction(okAction);
    }

    protected void initComponents() {
        SrPanel limitedTimePanel = this.createLimitedTimePanel();
        SrPanel foreverPanel = this.createForeverPanel();
        this.durationLbl = new SrClientLabel("Duration [in seconds] :");
        this.durationFld = new SrIntegerTextField(15);
        SrPanel durationPanel = this.createSrPanel(this.durationLbl, this.durationFld);
        ButtonGroup group = new ButtonGroup();
        group.add(this.durationButton);
        group.add(this.foreverButton);
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(3, 1));
        mainPanel.add(limitedTimePanel);
        mainPanel.add(durationPanel);
        mainPanel.add(foreverPanel);
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
    }

    private SrPanel createLimitedTimePanel() {
        this.limitedTimeLbl = new SrClientLabel("Limited Time:");
        this.durationButton = new SrRadioButton();
        this.durationButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BlinkDurationDialog.this.enableDurationPanel();
            }
        });
        return this.createSrPanel(this.durationButton, this.limitedTimeLbl);
    }

    private SrPanel createForeverPanel() {
        this.foreverLbl = new SrClientLabel("Forever");
        this.foreverButton = new SrRadioButton();
        this.foreverButton.setSelected(true);
        return this.createSrPanel(this.foreverButton, this.foreverLbl);
    }

    private void enableDurationPanel() {
        boolean isDurationSelected = this.durationButton.isSelected();
        this.durationLbl.setEnabled(isDurationSelected);
        this.durationFld.setEnabled(isDurationSelected);
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    @Override
    public void removeListeners() {
    }
}

