/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SequentialAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SrVolOperStorageTableModel;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.storage.StorageTableCellRenderer;
import com.sanrad.nms.client.gui.storage.StorageTableHeader;
import com.sanrad.nms.client.gui.storage.VolOperStorageTableHeader;
import com.sanrad.swing.SrSwingUtils;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class VolOperStorageTableCellRenderer
extends StorageTableCellRenderer {
    private VolumeOperationHandler volOperHandler;
    private static SrLogger theLogger = SrLogger.getLogger();

    public VolOperStorageTableCellRenderer(VolumeOperationHandler volOperHandler) {
        super(StorageTableHeader.DISK_ALIAS);
        this.volOperHandler = volOperHandler;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Font currentFont;
        if (value == null) {
            this.setText("--------");
        } else if (value.toString() == null) {
            theLogger.error(SrLogCategories.LEGACY, new Exception("Method toString() returned null from class " + value.getClass()), new Object[0]);
            this.setText("");
        } else {
            this.setText(value.toString());
        }
        SrVolOperStorageTableModel model = (SrVolOperStorageTableModel)table.getModel();
        StorageDeviceNode node = model.getDisk(row);
        int diskcol = model.getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
        int subdiskCol = model.getColumnIndex(VolOperStorageTableHeader.SUBDISK_ALIAS.getColumnName());
        boolean isSubDisk = node instanceof SubDirectAccessDeviceNode;
        boolean isExposed = node.isExposed();
        boolean isFree = this.isFree(node);
        this.setForgroundColor(isExposed, isFree);
        this.setSelectionColor(isSelected);
        if (column == diskcol) {
            StorageDeviceNode testNode = node;
            if (node instanceof SubDirectAccessDeviceNode) {
                testNode = ((SubDirectAccessDeviceNode)node).getDirectAccessDeviceParent();
            }
            this.blinkCell(table, testNode.isBlinking(), node, row, column, isExposed, isFree, isSelected);
            ImageIcon nodeIcon = null;
            if (node instanceof DirectAccessDeviceNode) {
                nodeIcon = ClientImageObject.DISK.getImageIcon();
            } else if (node instanceof SequentialAccessDeviceNode) {
                nodeIcon = ClientImageObject.TAPE.getImageIcon();
            } else if (node instanceof StorageDeviceNode) {
                nodeIcon = ClientImageObject.GENERAL_SCSI_DEVICE.getImageIcon();
            }
            ImageIcon icon = nodeIcon;
            if (!isSubDisk) {
                icon = SrSwingUtils.horizontallyJoinTwoIcons((ImageIcon)node.getAlarmIcon(), nodeIcon, 1);
            }
            this.setIcon(icon);
        } else if (column == subdiskCol) {
            if (!isSubDisk) {
                this.setIcon(ClientImageObject.SUB_DISK.getImageIcon());
                this.setText("--------");
            } else {
                ImageIcon icon = SrSwingUtils.horizontallyJoinTwoIcons((ImageIcon)node.getAlarmIcon(), node.getNodeIcon(), 1);
                this.setIcon(icon);
            }
        }
        if (this.volOperHandler != null && this.volOperHandler.isOperationLegitimate(node) != null && !(currentFont = this.getFont()).isPlain()) {
            this.setFont(new Font(currentFont.getName(), 0, currentFont.getSize()));
        }
        return this;
    }
}

