/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage;

import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.RaidNode;
import com.sanrad.nms.client.data.storage.StorageNode;
import com.sanrad.nms.client.data.storage.StorageTableModelCollection;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.storage.DiskGraphicViewPanel;
import com.sanrad.nms.client.gui.storage.StorageDetailsViewPanel;
import com.sanrad.nms.client.gui.storage.StorageTableViewPanel;
import com.sanrad.nms.client.gui.storage.panels.NexsanMgmtViewPanel;
import com.sanrad.nms.client.gui.volume.VolumeOperationFrame;
import com.sanrad.swing.DetailsViewPanel;
import com.sanrad.swing.ElementViewPanel;
import com.sanrad.swing.TableViewPanel;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.TreeModelAdapter;

public class StorageViewPanel
extends ElementViewPanel {
    private MainFrame myMainFrame;
    private StorageTableViewPanel storageTableViewPanel;
    private StorageDetailsViewPanel storageDetailsViewPanel = new StorageDetailsViewPanel();
    private DiskGraphicViewPanel diskGraphicViewPanel;
    private VolumeOperationFrame volumeOperationFrame;
    private NexsanMgmtViewPanel myNexsanMgmtPanel = new NexsanMgmtViewPanel();

    public StorageViewPanel(MainFrame aMainFrame) {
        if (aMainFrame == null) {
            throw new IllegalArgumentException("MainFrame must not be null");
        }
        this.myMainFrame = aMainFrame;
        this.storageTableViewPanel = new StorageTableViewPanel(aMainFrame);
        this.diskGraphicViewPanel = DiskGraphicViewPanel.getInstance(aMainFrame);
        this.addTablePanel(this.storageTableViewPanel);
        this.addDetailsPanel(this.storageDetailsViewPanel);
        this.storageTableViewPanel.setDiskGraphicViewPanel(this.diskGraphicViewPanel);
        this.storageDetailsViewPanel.addDiskGraphicViewPanel(this.diskGraphicViewPanel);
        SrMainTreeModel.getInstance().addTreeModelListener(new TreeModelAdapter(){

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                StorageViewPanel.this.updateStorageTable();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                StorageViewPanel.this.updateStorageTable();
            }
        });
        aMainFrame.getMainTreePanel().getTreeObject().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                StorageViewPanel.this.updateStorageTable();
            }
        });
    }

    @Override
    public TableViewPanel getTableViewPanel() {
        return this.storageTableViewPanel;
    }

    @Override
    public DetailsViewPanel getDetailsViewPanel() {
        return this.storageDetailsViewPanel;
    }

    public void showNexsanPanel(String aURL) {
        this.splitPanel.setOneTouchExpandable(true);
        this.splitPanel.remove(this.myNexsanMgmtPanel);
        this.splitPanel.remove(this.storageDetailsViewPanel);
        if (aURL != null) {
            this.myNexsanMgmtPanel.loadWebPage(aURL);
        }
        this.splitPanel.add((Component)this.myNexsanMgmtPanel, "right");
    }

    public void showSubdisksPanel() {
        this.splitPanel.setOneTouchExpandable(false);
        this.splitPanel.remove(this.myNexsanMgmtPanel);
        this.splitPanel.remove(this.storageDetailsViewPanel);
        this.splitPanel.add((Component)this.storageDetailsViewPanel, "right");
    }

    private void updateStorageTable() {
        TreeNode selectedNode = this.myMainFrame.getMainTreePanel().getSelectedNode();
        if (selectedNode instanceof StorageNode || selectedNode instanceof RaidNode) {
            this.storageTableViewPanel.updateStorageTable((SrTreeNode)selectedNode);
        } else {
            this.storageTableViewPanel.updateStorageTable(null);
        }
    }

    public void clearTable(ClusterNode clusterNode) {
        if (clusterNode.isCurrentCluster()) {
            this.clearTable();
        } else {
            StorageTableModelCollection.getInstance().clearModelOf(clusterNode);
        }
    }

    public void clearTable() {
        this.storageTableViewPanel.clear();
    }

    public void closeVolumeCreationFrame() {
        if (this.volumeOperationFrame != null) {
            this.volumeOperationFrame.dispose();
            this.volumeOperationFrame = null;
        }
    }

    public boolean isVolumeCreationFrameShown() {
        if (this.volumeOperationFrame != null) {
            return this.volumeOperationFrame.isShowing();
        }
        return false;
    }

    public JFrame getVolumeCreationFrame() {
        return this.volumeOperationFrame;
    }

    public void newClusterHasBeenSelected() {
        this.storageTableViewPanel.newClusterHasBeenSelected();
        this.storageDetailsViewPanel.newClusterHasBeenSelected();
        this.diskGraphicViewPanel.newClusterHasBeenSelected();
        if (this.volumeOperationFrame != null) {
            this.volumeOperationFrame.newClusterHasBeenSelected();
        }
    }
}

