/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SequentialAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.LookAndFill;
import com.sanrad.nms.client.gui.SrClientTableHeader;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.SrTableCellRenderer;
import com.sanrad.swing.SrTableModel;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class StorageTableCellRenderer
extends SrTableCellRenderer {
    private static final String EMPTY_VALUE_STR = "-----";
    private static SrLogger theLogger = SrLogger.getLogger();
    private HashMap m_blinkStatus = new HashMap();
    private SrClientTableHeader myAliasHeader;

    public StorageTableCellRenderer(SrClientTableHeader aAliasHeader) {
        this.myAliasHeader = aAliasHeader;
        this.setHorizontalAlignment(2);
    }

    public StorageTableCellRenderer(SrClientTableHeader aAliasHeader, int aAlignment) {
        this(aAliasHeader);
        this.setHorizontalAlignment(aAlignment);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        SrTableModel model = (SrTableModel)table.getModel();
        int aliasColInModel = model.getColumnIndex(this.myAliasHeader.getColumnName());
        int aliasColInTable = table.convertColumnIndexToView(aliasColInModel);
        AliasObject aliasObj = (AliasObject)model.getValueAt(row, aliasColInModel);
        if (aliasObj == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        StorageDeviceNode node = (StorageDeviceNode)aliasObj.getValue();
        boolean isExposed = node.isExposed();
        boolean isFree = this.isFree(node);
        this.setForgroundColor(isExposed, isFree);
        if (column != aliasColInTable) {
            if (value != null) {
                if (value.toString() == null) {
                    theLogger.error(SrLogCategories.LEGACY, new Exception("Method toString() returned null from class " + value.getClass()), new Object[0]);
                    this.setText("");
                } else {
                    this.setText(value.toString());
                }
            } else {
                this.setText(EMPTY_VALUE_STR);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value.toString() == null) {
            theLogger.error(SrLogCategories.LEGACY, new Exception("Method toString() returned null from class " + value.getClass()), new Object[0]);
            this.setText("");
        } else {
            this.setText(value.toString());
        }
        this.blinkCell(table, node.isBlinking(), node, row, aliasColInTable, isExposed, isFree, isSelected);
        ImageIcon alarmIcon = (ImageIcon)node.getAlarmIcon();
        ImageIcon nodeIcon = null;
        nodeIcon = node instanceof DirectAccessDeviceNode ? ClientImageObject.DISK.getImageIcon() : (node instanceof SequentialAccessDeviceNode ? ClientImageObject.TAPE.getImageIcon() : ClientImageObject.GENERAL_SCSI_DEVICE.getImageIcon());
        this.setIcon(SrSwingUtils.horizontallyJoinTwoIcons(alarmIcon, nodeIcon, 3));
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    protected boolean isFree(StorageDeviceNode node) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
        boolean isSnapSrc = clusterNode == null ? false : VolumeManager.getInstance().getClusterSnapshotMap().isSourceOfSnapshot(clusterNode, node);
        return !(node.getParent() instanceof VolumeTreeNode) && (!(node instanceof DirectAccessDeviceNode) || !((DirectAccessDeviceNode)node).hasSubdisks()) && !node.isPartOfPair() && !CopyOperManager.getInstance().isInvolvedInActiveOfflineCopy(node) && !isSnapSrc;
    }

    protected void blinkCell(JTable table, boolean isBlinking, StorageDeviceNode node, int row, int col, boolean isExposed, boolean isFree, boolean isSelected) {
        if (isBlinking) {
            boolean blinkColor = false;
            if (this.m_blinkStatus.containsKey(node)) {
                blinkColor = (Boolean)this.m_blinkStatus.get(node) == false;
            }
            this.m_blinkStatus.put(node, new Boolean(blinkColor));
            if (blinkColor) {
                this.setForgroundColor(isExposed, isFree);
                this.setSelectionColor(isSelected);
            } else {
                this.setForeground(com.sanrad.swing.LookAndFill.TABLE_HIGHLIGHT_COLOR);
                Font font = this.getFont();
                this.setFont(new Font(font.getName(), 1, font.getSize()));
            }
        } else {
            this.m_blinkStatus.remove(node);
            this.setForgroundColor(isExposed, isFree);
            this.setSelectionColor(isSelected);
        }
    }

    protected void setForgroundColor(boolean isExposed, boolean isFree) {
        if (isExposed) {
            this.setForeground(LookAndFill.EXPOSED_DISK_COLOR);
            Font currentFont = this.getFont();
            this.setFont(new Font(currentFont.getName(), 0, currentFont.getSize()));
        } else if (!isFree) {
            this.setForeground(LookAndFill.SPLIT_OR_VOLUMIZED_DISK_COLOR);
            Font currentFont = this.getFont();
            this.setFont(new Font(currentFont.getName(), 0, currentFont.getSize()));
        } else {
            this.setForeground(LookAndFill.FREE_DISK_COLOR);
            Font currentFont = this.getFont();
            this.setFont(new Font(currentFont.getName(), 1, currentFont.getSize()));
        }
    }

    protected void setSelectionColor(boolean isSelected) {
        if (isSelected) {
            this.setBackground(com.sanrad.swing.LookAndFill.TABLE_SELECTION_BACKGROUND);
            this.setForeground(com.sanrad.swing.LookAndFill.TABLE_SELECTION_FOREGROUND);
        } else {
            this.setBackground(com.sanrad.swing.LookAndFill.TABLE_BACKGROUND);
        }
    }
}

