/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SrVolOperStorageTableModel;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceSpace;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.VolumeCreationSelectionEvent;
import com.sanrad.nms.client.event.VolumeCreationSelectionListener;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionAdapter;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionEvent;
import com.sanrad.nms.client.event.storage.StorageTableModelEvent;
import com.sanrad.nms.client.gui.SrTableCellEditor;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.storage.SrStorageTablePanel;
import com.sanrad.nms.client.gui.storage.VolOperStorageTableCellRenderer;
import com.sanrad.nms.client.gui.storage.VolOperStorageTableHeader;
import com.sanrad.nms.client.gui.volume.VolumeOperationFrame;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.table.event.TableCellEditAdapter;
import com.sanrad.swing.table.event.TableCellEditEvent;
import com.sanrad.util.SrEventListenerManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;

public class SrVolOperStorageTablePanel
extends SrStorageTablePanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer<VolumeCreationSelectionListener, VolumeCreationSelectionEvent> clearTreeSelectionInformer = new SrEventListenerManager.Informer<VolumeCreationSelectionListener, VolumeCreationSelectionEvent>(){

        @Override
        public void inform(VolumeCreationSelectionListener listener, VolumeCreationSelectionEvent event) {
            listener.clearTreeSelection(event);
        }
    };
    private VolumeOperationHandler m_volOperHandler;
    private View<StorageDeviceNode> operVolView;

    public SrVolOperStorageTablePanel(SrVolOperStorageTableModel model, VolumeOperationFrame owner) {
        super((SrTableModel)model, owner);
        VolOperMouseAdapter listener = new VolOperMouseAdapter();
        this.getTable().addMouseListener(listener);
        this.getScrollPane().addMouseListener(listener);
        for (int k = 0; k < this.getModel().getColumnCount(); ++k) {
            TableColumn column = this.getTable().getColumnModel().getColumn(k);
            column.setPreferredWidth(89);
        }
    }

    @Override
    protected void setRenderersAndEditors() {
        TableColumn tableColumn;
        if (this.m_volOperHandler == null) {
            return;
        }
        int columnCount = this.getTable().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            tableColumn = this.getTable().getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new VolOperStorageTableCellRenderer(this.m_volOperHandler));
        }
        int ind = ((SrVolOperStorageTableModel)this.getModel()).getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
        tableColumn = this.getTable().getColumnModel().getColumn(ind);
        tableColumn.setCellEditor(new SrTableCellEditor());
        ind = ((SrVolOperStorageTableModel)this.getModel()).getColumnIndex(VolOperStorageTableHeader.SUBDISK_ALIAS.getColumnName());
        TableColumn sdTableColumn = this.getTable().getColumnModel().getColumn(ind);
        sdTableColumn.setCellEditor(new SrTableCellEditor());
        this.addTableCellEditListener(new EditorListener());
    }

    public void setVolOperHandler(VolumeOperationHandler handler) {
        this.m_volOperHandler = handler;
        this.setRenderersAndEditors();
        this.activateTimerRefreshViewIfHasABlinkingStorageDevice(-1);
    }

    @Override
    protected void readStorageFromServer() {
    }

    private void printTable() {
        if (this.DEBUG) {
            SrVolOperStorageTableModel model = (SrVolOperStorageTableModel)this.getModel();
            int col = model.getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
            int size = this.getTable().getRowCount();
            theLogger.trace(SrLogCategories.LEGACY, "Storage table after sorting: ");
            for (int i = 0; i < size; ++i) {
                theLogger.trace(SrLogCategories.LEGACY, model.getValueAt(i, col));
            }
        }
    }

    @Override
    public void storageElementsInserted(StorageTableModelEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "StorageTable: storageElementsInserted. sorting table.");
        this.sortByAlias();
    }

    private void sortByAlias() {
        SrVolOperStorageTableModel model = (SrVolOperStorageTableModel)this.getModel();
        int col = model.getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
        this.invokeColumnSortOnStartup(col, true);
        this.setRowSelection();
        this.printTable();
    }

    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        if (rowIndices.length > 0) {
            this.updateDiskGraphicViewPanel(rowIndices[0]);
        }
    }

    private void updateDiskGraphicViewPanel(int row) {
        theLogger.trace(SrLogCategories.LEGACY, "VolOperStorageTable::: Start updating the Graphic panel....");
        SrVolOperStorageTableModel tableModel = (SrVolOperStorageTableModel)this.getModel();
        if (tableModel.getValueAt(row, 0) instanceof SubDirectAccessDeviceNode) {
            this.diskGraphicViewPanel.clear();
        }
        int col = tableModel.getColumnIndex(VolOperStorageTableHeader.TOTAL_SPACE.getColumnName());
        try {
            Object val = tableModel.getValueAt(row, col);
            if (val instanceof StorageDeviceSpace && this.diskGraphicViewPanel != null) {
                StorageDeviceSpace totalSpace = (StorageDeviceSpace)tableModel.getValueAt(row, col);
                this.diskGraphicViewPanel.setTotalSpace(totalSpace);
            }
            List splits = tableModel.getDiskSplits(row);
            StorageDeviceNode parent = tableModel.getDisk(row);
            if (this.diskGraphicViewPanel != null) {
                this.diskGraphicViewPanel.setSubdisks(splits, parent);
                this.diskGraphicViewPanel.revalidate();
                this.diskGraphicViewPanel.repaint();
            }
            theLogger.trace(SrLogCategories.LEGACY, "VolOperStorageTable::: finish updating the Graphic panel....");
        }
        catch (Exception e) {
            theLogger.warn(SrLogCategories.LEGACY, e, "Could not update disk graphics.");
        }
    }

    @Override
    public StorageDeviceNode[] getSelectedDeviceNodes() {
        int[] aliasIndices = this.getSelectedRows();
        if (aliasIndices != null) {
            StorageDeviceNode[] nodes = new StorageDeviceNode[aliasIndices.length];
            for (int i = 0; i < aliasIndices.length; ++i) {
                int diskCol = ((SrVolOperStorageTableModel)this.getModel()).getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
                int subdiskCol = ((SrVolOperStorageTableModel)this.getModel()).getColumnIndex(VolOperStorageTableHeader.SUBDISK_ALIAS.getColumnName());
                Object alias = this.getModel().getValueAt(aliasIndices[i], subdiskCol);
                if (alias == null) {
                    alias = (AliasObject)this.getModel().getValueAt(aliasIndices[i], diskCol);
                }
                if (alias == null) continue;
                nodes[i] = (StorageDeviceNode)((AliasObject)alias).getValue();
            }
            return nodes;
        }
        return null;
    }

    @Override
    public Object[] getSelectedAliases() {
        int[] aliasIndices = this.getSelectedRows();
        Object[] aliases = new Object[aliasIndices.length];
        for (int i = 0; i < aliasIndices.length; ++i) {
            boolean isFree;
            SrVolOperStorageTableModel model = (SrVolOperStorageTableModel)this.getModel();
            AliasObject alias = model.getAlias(aliasIndices[i]);
            StorageDeviceNode node = (StorageDeviceNode)alias.getValue();
            boolean isExposed = node.isExposed();
            boolean hasSubdisks = node.hasSubdisks();
            boolean hasVolumeParent = this.hasVolumeParent(node);
            boolean bl = isFree = !hasSubdisks && !hasVolumeParent;
            if (isExposed || !isFree) continue;
            aliases[i] = alias;
        }
        return aliases;
    }

    private boolean hasVolumeParent(StorageDeviceNode node) {
        TreeNode parent = node.getParent();
        return parent instanceof VolumeTreeNode;
    }

    private View<StorageDeviceNode> getOperView() {
        if (this.operVolView == null) {
            this.operVolView = new SrTableView<StorageDeviceNode>((JTable)this.getTable()){

                @Override
                public Collection<StorageDeviceNode> getValue() {
                    return Arrays.asList(SrVolOperStorageTablePanel.this.getSelectedDeviceNodes());
                }
            };
        }
        return this.operVolView;
    }

    @Override
    public DeleteAction getDeleteAction() {
        OperationController deleteConroller = new OperationController(){

            @Override
            public void fail(String message) {
                ((VolumeOperationFrame)SrVolOperStorageTablePanel.this.myOwner).fail(message);
            }

            @Override
            public void inProcess(String message) {
                ((VolumeOperationFrame)SrVolOperStorageTablePanel.this.myOwner).inProcess(message);
            }

            @Override
            public void success(SrAction action) {
            }
        };
        return new DeleteAction<StorageDeviceNode>(this.getOperView(), deleteConroller, new DeleteAction.Confirmator());
    }

    @Override
    public void removeListeners() {
        AlarmsManager.getInstance().removeAlarmSourceSelectionListener(this.m_storageAlarmSelection);
    }

    @Override
    protected Class getTableHeaderClass() {
        return VolOperStorageTableHeader.class;
    }

    private class EditorListener
    extends TableCellEditAdapter {
        private EditorListener() {
        }

        @Override
        public void tableEditingStopped(TableCellEditEvent e) {
            String s = (String)e.getEditorValue();
            Object val = e.getTableCellOldValue();
            if (s.trim().length() == 0) {
                StatusPanel.getInstance().setText("Alias is not valid.", SrVolOperStorageTablePanel.this);
            }
            if (val != null) {
                Object node = ((AliasObject)val).getValue();
                HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>();
                if (node instanceof SubDirectAccessDeviceNode) {
                    String alias = ((SubDirectAccessDeviceNode)node).getAlias();
                    if (alias.equalsIgnoreCase(s.trim())) {
                        return;
                    }
                    params.put(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, s.trim());
                    ((VolumeOperationFrame)SrVolOperStorageTablePanel.this.myOwner).setNotDisposeOnSuccess();
                    SrAction.blockActions(Collections.singleton(SubDirectAccessDeviceManager.getInstance().editSubDirectAccessDevice((SubDirectAccessDeviceNode)node, params)), (VolumeOperationFrame)SrVolOperStorageTablePanel.this.myOwner);
                } else if (node instanceof DirectAccessDeviceNode) {
                    DirectAccessDeviceNode diskNode = (DirectAccessDeviceNode)node;
                    String alias = diskNode.getAlias();
                    if (alias.equals(s.trim())) {
                        return;
                    }
                    params.put(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS, s.trim());
                    ((VolumeOperationFrame)SrVolOperStorageTablePanel.this.myOwner).setNotDisposeOnSuccess();
                    SrAction.blockActions(Collections.singleton(DirectAccessDeviceManager.getInstance().renameStorageDevice(diskNode, params)), (VolumeOperationFrame)SrVolOperStorageTablePanel.this.myOwner);
                }
            }
        }
    }

    class VolOperMouseAdapter
    extends MouseAdapter {
        VolOperMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!e.isControlDown()) {
                VolumeCreationSelectionEvent event = new VolumeCreationSelectionEvent(this);
                SrVolOperStorageTablePanel.this.m_listeners.fireEvent(VolumeCreationSelectionListener.class, event, SrVolOperStorageTablePanel.this.clearTreeSelectionInformer);
            }
        }
    }

    class StorageAlarmSelection
    extends AlarmSourceSelectionAdapter {
        StorageAlarmSelection() {
        }

        @Override
        public void directAccessDeviceSelected(AlarmSourceSelectionEvent event) {
            DirectAccessDeviceNode node = (DirectAccessDeviceNode)event.getNode();
            this.select(node);
        }

        @Override
        public void subDirectAccessDeviceSelected(AlarmSourceSelectionEvent event) {
            SubDirectAccessDeviceNode node = (SubDirectAccessDeviceNode)event.getNode();
            DirectAccessDeviceNode parent = node.getDirectAccessDeviceParent();
            if (parent != null) {
                theLogger.trace(SrLogCategories.LEGACY, "VolOperStorageTable::: Selecting the subdisk source ....");
                this.select(parent);
            }
        }

        private void select(SrTreeNode node) {
            int rowCount = SrVolOperStorageTablePanel.this.getTable().getRowCount();
            SrVolOperStorageTableModel model = (SrVolOperStorageTableModel)SrVolOperStorageTablePanel.this.getTable().getModel();
            int col = model.getColumnIndex(VolOperStorageTableHeader.DISK_ALIAS.getColumnName());
            for (int i = 0; i < rowCount; ++i) {
                AliasObject obj = (AliasObject)model.getValueAt(i, col);
                DirectAccessDeviceNode disk = (DirectAccessDeviceNode)obj.getValue();
                if (!disk.equals(node)) continue;
                SrVolOperStorageTablePanel.this.setRowSelectionSet(i, i);
                SrVolOperStorageTablePanel.this.scrollToRow(i);
                return;
            }
        }
    }
}

