/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.ResizeVolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.data.volume.copy.OfflineCopyOperationHandler;
import com.sanrad.nms.client.event.DirectAccessDeviceAdapter;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.DirectAccessDeviceListener;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrDefaultPopupMenu;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.EmptyAction;
import com.sanrad.nms.client.gui.actions.ExposeInternalVolumeAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.SynchronizeElementAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.storage.SrStorageComponentInterface;
import com.sanrad.nms.client.gui.storage.dialogs.DirectAccessDevicePropertiesDialog;
import com.sanrad.nms.client.gui.storage.dialogs.NewSubdiskDialog;
import com.sanrad.nms.client.gui.storage.dialogs.SubdiskPropertiesDialog;
import com.sanrad.nms.client.gui.volume.VolumeOperationFramePool;
import com.sanrad.nms.server.license.SrFeatureNameConstant;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.actions.ViewDecorator;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;

public abstract class SrStorageTablePopupMenu<T extends StorageDeviceNode>
extends SrDefaultPopupMenu {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static final SrLicenseTreePath m_resizePath = new SrLicenseTreePath(SrLicenseTreePath.STORAGE_PATH, SrFeatureNameConstant.RESIZE);
    private static final SrLicenseTreePath subdiskPath = new SrLicenseTreePath(SrLicenseTreePath.SUBDISK_PATH, SrFeatureNameConstant.CREATE);
    private final String BLINK = "Blink...";
    private final String ABORT = "Stop Blinking";
    private final String COPY = "Copy...";
    private final String SNAPSHOT = "Snapshot";
    private final String SHOW = "Show...";
    private final String SHOW_COPY = "Show...";
    private final String CREATE = "Create...";
    private final String CREATE_SUB_DISK = "Create Subdisk...";
    private final String COPY_MENU = "Copy";
    private final String RESIZE_MENU = "Resize";
    private final String RESIZE = "Resize...";
    private final String EXPAND = "Expand";
    private final String RETRACT = "Retract";
    protected SrStorageComponentInterface m_storageComInter;
    protected SrAction m_delete;
    private static final String NO_REASON = "";

    public SrStorageTablePopupMenu(SrStorageComponentInterface workWith, final View<T> view, final JFrame owner) {
        super(workWith.getMyComponent());
        Vector<Serializable> actions = new Vector<Serializable>(14);
        actions.add(new SrClientAction<T, Void>("Create Subdisk...", null, true, true, view, subdiskPath, true, false){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
                SrLogger.getLogger().trace(SrLogCategories.LEGACY, "user selected: create new subdisk...");
                DirectAccessDeviceNode selectedDisk = (DirectAccessDeviceNode)arg.iterator().next();
                ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(selectedDisk);
                new NewSubdiskDialog(owner, selectedDisk, clusterNode);
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                for (StorageDeviceNode storageDeviceNode : this.myView.getValue()) {
                    if (storageDeviceNode.isExposed()) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CREATE_SUBDISK_VALIDAION_THE_DISK_IS_EXPOSED);
                    }
                    if (DRPairManager.getPairContainingVolume(storageDeviceNode) != null) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CREATE_SUBDISK_VALIDAION_THE_SOURCE_INVOLVED_IN_DR_PAIR);
                    }
                    if (storageDeviceNode.hasVolumeParent()) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CREATE_SUBDISK_VALIDAION_THE_DISK_PARENT_IS_VOLUME);
                    }
                    if (!AlarmsManager.getInstance().isLegitimateForVolumeCreation(storageDeviceNode)) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CREATE_SUBDISK_VALIDAION_THE_DISK_IS_MISSING);
                    }
                    DirectAccessDeviceNode diskNode = (DirectAccessDeviceNode)storageDeviceNode;
                    if (diskNode.getNonAllocatedSpace() != null && diskNode.getNonAllocatedSpace().doubleValue() == 0.0 && !storageDeviceNode.isConfigured()) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CREATE_SUBDISK_VALIDAION_THE_DISK_HAS_NO_FREE_SPACE);
                    }
                    if (CopyOperManager.getInstance().isExistActiveCopyInHeirarchy(storageDeviceNode) || CopyOperManager.getInstance().isExistAbortedCopyInHeirarchy(storageDeviceNode)) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CREATE_SUBDISK_VALIDAION_THE_SOURCE_INVOLVED_IN_A_COPY_OR_MIRROR_SYNC_OPERATION);
                    }
                    ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(storageDeviceNode);
                    if (!VolumeManager.getInstance().getClusterSnapshotMap().isSourceOfSnapshot(clusterNode, storageDeviceNode)) continue;
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SUBDISK_CAN_NOT_BE_CREATED_DISK_SOURCE_OF_SNAPSHOT);
                }
                return null;
            }

            @Override
            protected boolean shouldClientActionBeVisible() {
                for (StorageDeviceNode storageDeviceNode : this.myView.getValue()) {
                    if (storageDeviceNode.isDisk()) continue;
                    return false;
                }
                return true;
            }
        });
        class BlinkAction
        extends SrClientAction<T, Void> {
            private boolean doBlink;
            private DirectAccessDeviceListener listener;

            public BlinkAction(SrStorageComponentInterface workWith, View<T> view) {
                super("Blink...", null, true, true, view, SrLicenseTreePath.GENERAL_PATH, false, false);
                this.listener = new DirectAccessDeviceAdapter(){

                    @Override
                    public void directAccessDeviceBlinkStateChange(DirectAccessDeviceEvent event) {
                        this.updateEnabled();
                    }
                };
                DirectAccessDeviceManager.getInstance().addDirectAccessDeviceListener(this.listener);
                if (workWith instanceof OperationController) {
                    this.addControllerAsListener((OperationController)((Object)workWith));
                }
            }

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
                StorageDeviceNode[] strgNodes = arg.toArray(new StorageDeviceNode[arg.size()]);
                if (this.doBlink) {
                    HashMap<ClientParameterCode, Comparable<Boolean>> params = new HashMap<ClientParameterCode, Comparable<Boolean>>();
                    params.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE, new Boolean(true));
                    params.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_DURATION, new Integer(0));
                    return DirectAccessDeviceManager.getInstance().blinkDisks(strgNodes, params);
                }
                HashMap<ClientParameterCode, Boolean> params = new HashMap<ClientParameterCode, Boolean>();
                params.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE, new Boolean(false));
                return DirectAccessDeviceManager.getInstance().blinkDisks(strgNodes, params);
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                boolean isFirst = true;
                for (StorageDeviceNode storage : this.myView.getValue()) {
                    if (storage.isConfigured()) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.BLINK_VALIDAION_THE_SOURCE_IS_CONFIGURED);
                    }
                    if (VolumeManager.getInstance().canBeDeleted(storage, new StringBuffer())) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.BLINK_VALIDAION_THE_SOURCE_IS_REMOVEABLE_DISK);
                    }
                    if (!isFirst && this.doBlink == storage.isBlinking()) {
                        return "Some selected disks are blinking and the others are not";
                    }
                    this.doBlink = !storage.isBlinking();
                    String name = this.doBlink ? "Blink..." : "Stop Blinking";
                    this.setName(name);
                    isFirst = false;
                }
                return null;
            }

            @Override
            protected boolean shouldClientActionBeVisible() {
                for (StorageDeviceNode storage : this.myView.getValue()) {
                    if (storage.isDisk()) continue;
                    return false;
                }
                return true;
            }
        }
        actions.add(new BlinkAction(workWith, view));
        ExposeInternalVolumeAction<T> exposeAction = new ExposeInternalVolumeAction<T>(owner, view, SrLicenseTreePath.GENERAL_PATH);
        actions.add(exposeAction);
        actions.add(new JPopupMenu.Separator());
        Vector<SrClientAction> copyMenu = new Vector<SrClientAction>(3);
        actions.add(copyMenu);
        copyMenu.add(new SrClientAction<T, Void>("Copy", true, true, view, SrLicenseTreePath.VOLUME_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "SrStorageTablePopupMenu.copyMenu action invoked, although it is empty");
                return null;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                StorageDeviceNode storageDeviceNode = (StorageDeviceNode)this.myView.getValue().iterator().next();
                if (storageDeviceNode.isTape() || storageDeviceNode.isProcessor()) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_STORAGE_IS_NOT_A_DISK_OR_SUBDISK);
                }
                DRPairNode drPair = DRPairManager.getPairContainingVolume(storageDeviceNode);
                if (drPair != null) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_DISK_IS_USED_BY_A_PAIR);
                }
                return null;
            }
        });
        copyMenu.add(new SrClientAction<T, Void>("Copy...", true, true, view, SrLicenseTreePath.VOLUME_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
                StorageDeviceNode node = (StorageDeviceNode)arg.iterator().next();
                VolumeOperationFramePool.getInstance().openVolumeOperationFrame(node, new OfflineCopyOperationHandler(node));
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                StorageDeviceNode storageDeviceNode = (StorageDeviceNode)this.myView.getValue().iterator().next();
                boolean isDisk = storageDeviceNode.isDisk();
                if (!(!AlarmsManager.getInstance().isRemovableDisk(storageDeviceNode) || isDisk && AlarmsManager.getInstance().hasConfiguredAlarmOnly(storageDeviceNode))) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_PARENT_IS_MISSING_OR_INVALID);
                }
                if (storageDeviceNode.getProblemOnDeletion() == null && !storageDeviceNode.isSubDisk()) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPERATION_VALIDAION_THE_SOURCE_IS_REMOVEABLE_DISK);
                }
                StringBuffer reason = new StringBuffer(SrStorageTablePopupMenu.NO_REASON);
                if (!CopyOperManager.getInstance().isLegitimateForCopyOper(storageDeviceNode, reason)) {
                    return reason.toString();
                }
                return null;
            }
        });
        copyMenu.add(new MainFrame.ShowAndSelectCopyOperationAction("Show...", new ViewDecorator<CopyOperationNode, T>(view){

            @Override
            public Collection<CopyOperationNode> getValue() {
                Collection decoratedValue = this.myView.getValue();
                ArrayList<CopyOperationNode> retVal = new ArrayList<CopyOperationNode>();
                for (StorageDeviceNode item : decoratedValue) {
                    retVal.addAll(CopyOperManager.getInstance().getOfflineCopyOperations(item));
                }
                return retVal;
            }
        }, owner){

            @Override
            protected String getContextMismatchTooltip() {
                return view.getValue().isEmpty() ? super.getContextMismatchTooltip() : ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_VALIDAION_THE_DISK_IS_NOT_INVOLVED_IN_OFFLINE_COPY);
            }
        });
        Vector<SrClientAction> resizeMenu = new Vector<SrClientAction>(4);
        actions.add(resizeMenu);
        resizeMenu.add(new EmptyAction("Resize", true, true, m_resizePath));
        resizeMenu.add(new SrClientAction<T, Void>("Resize...", true, true, view, SrLicenseTreePath.GENERAL_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
                StorageDeviceNode node = (StorageDeviceNode)arg.iterator().next();
                VolumeOperationFramePool.getInstance().openVolumeOperationFrame(node, new ResizeVolumeOperationHandler(node));
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                DirectAccessDeviceNode disk;
                StorageDeviceNode storageDeviceNode = (StorageDeviceNode)this.myView.getValue().iterator().next();
                if (storageDeviceNode.isTape() || storageDeviceNode.isProcessor()) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RESIZE_VALIDATION_THE_STORAGE_IS_NOT_A_DISK_OR_SUBDISK);
                }
                if (storageDeviceNode.isSubDisk()) {
                    DirectAccessDeviceNode parentDisk = ((SubDirectAccessDeviceNode)storageDeviceNode).getDirectAccessDeviceParent();
                    if (VolumeManager.getInstance().isMissingOrInvalidDisk(parentDisk)) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RESIZE_VALIDATION_THE_SUBDISK_PARENT_IS_MISSING_OR_INVALID);
                    }
                }
                if (storageDeviceNode.isDisk() && (disk = (DirectAccessDeviceNode)storageDeviceNode).hasSubdisks()) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RESIZE_VALIDATION_SPLITTED_DISK);
                }
                if (StorageManager.getInstance().isStorageNodeUsedByAPair(storageDeviceNode)) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RESIZE_VALIDATION_THE_STORAGE_IS_USED_BY_PAIR);
                }
                if (CopyOperManager.getInstance().isExistActiveCopyInHeirarchy(storageDeviceNode)) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_VOLUME_IS_PART_OF_COPY_OPR_OR_MIRROR_SYNC);
                }
                return null;
            }
        });
        resizeMenu.add(new EmptyAction("Expand", true, true, m_resizePath){

            @Override
            protected String derivedClientUpdateEnabled() {
                return "Cannot expand a physical storage device";
            }
        });
        resizeMenu.add(new EmptyAction("Retract", true, true, m_resizePath){

            @Override
            protected String derivedClientUpdateEnabled() {
                return "Cannot retract a physical storage device";
            }
        });
        actions.add(new JPopupMenu.Separator());
        actions.add(this.getSynchronizeAction());
        actions.add(new JPopupMenu.Separator());
        actions.add(this.getAlarmsMenu());
        actions.add(new JPopupMenu.Separator());
        this.m_delete = this.getDeleteAction();
        actions.add(this.m_delete);
        actions.add(new JPopupMenu.Separator());
        actions.add(SrStorageTablePopupMenu.asProperties(new PropertiesAction<T>(view)));
        this.attachActions(actions);
    }

    @Override
    protected void setWorkWith(JComponent workWith) {
        super.setWorkWith(workWith);
        this.m_storageComInter = (SrStorageComponentInterface)((Object)workWith);
    }

    @Override
    public SynchronizeElementAction getSynchronizeAction() {
        return null;
    }

    @Override
    public AlarmAction getSpecificAlarmsAction() {
        return this.m_storageComInter.getSpecificAlarmsAction();
    }

    @Override
    public AlarmAction getPropagatedAlarmsAction() {
        return this.m_storageComInter.getPropagatedAlarmsAction();
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.m_storageComInter.getDeleteAction();
    }

    private static class PropertiesAction<TT extends StorageDeviceNode>
    extends SrClientAction<TT, Void> {
        public PropertiesAction(View<TT> view) {
            super(true, true, view, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<TT> arg) {
            JFrame frame = new JFrame();
            frame.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
            int i = 0;
            for (StorageDeviceNode node : arg) {
                Object uo = node.getUserObject();
                if (uo == null) {
                    SrOKCancelDialog props = null;
                    props = node instanceof SubDirectAccessDeviceNode ? new SubdiskPropertiesDialog(frame, (SubDirectAccessDeviceNode)node) : new DirectAccessDevicePropertiesDialog(frame, node);
                    node.setUserObject(props);
                    int x = (int)props.getLocation().getX();
                    int y = (int)props.getLocation().getY();
                    props.setLocation(x + i * 5, y + i * 5);
                    ((Dialog)props).show();
                } else {
                    ((JDialog)uo).requestFocus();
                }
                ++i;
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }
}

