/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SrStorageTableModel;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceSpace;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.event.VolumeCreationSelectionListener;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionAdapter;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionEvent;
import com.sanrad.nms.client.event.storage.StorageTableModelEvent;
import com.sanrad.nms.client.event.storage.StorageTableModelListener;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.SrTableCellEditor;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SynchronizeElementAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.storage.DiskGraphicViewPanel;
import com.sanrad.nms.client.gui.storage.SrDRStorageTablePopupMenu;
import com.sanrad.nms.client.gui.storage.SrStorageComponentInterface;
import com.sanrad.nms.client.gui.storage.StorageTableCellRenderer;
import com.sanrad.nms.client.gui.storage.StorageTableHeader;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.table.event.TableCellEditAdapter;
import com.sanrad.swing.table.event.TableCellEditEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SrStorageTablePanel
extends SrClientTablePanel
implements StorageTableModelListener,
SrStorageComponentInterface {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected DiskGraphicViewPanel diskGraphicViewPanel = null;
    protected final int SELECTION = 3;
    protected JFrame myOwner;
    protected StorageAlarmSelection m_storageAlarmSelection = new StorageAlarmSelection();
    protected boolean DEBUG = true;
    protected Timer timer;
    private final View<StorageDeviceNode> myView = new SrTableView<StorageDeviceNode>((JTable)this.getTable()){

        @Override
        public Collection<StorageDeviceNode> getValue() {
            StorageDeviceNode[] selectedDeviceNodes = SrStorageTablePanel.this.getSelectedDeviceNodes();
            if (selectedDeviceNodes == null) {
                return Collections.EMPTY_LIST;
            }
            return Arrays.asList(selectedDeviceNodes);
        }
    };
    private final DeleteAction myDeleteAction = new DeleteAction<StorageDeviceNode>(this.myView, StatusPanel.getInstance(), new DeleteAction.Confirmator());
    public final AlarmAction myOpenSpecificAlarmsAction = new AlarmAction<StorageDeviceNode>(this.myView, true);
    public final AlarmAction myOpenPropagatedAlarmsAction = new AlarmAction<StorageDeviceNode>(this.myView, false);

    public SrStorageTablePanel(SrTableModel model, JFrame owner) {
        super(model);
        this.buildTable(model);
        this.setModel(model);
        this.myOwner = owner;
        this.activateTimerRefreshViewIfHasABlinkingStorageDevice(-1);
        this.getTable().setSelectionMode(2);
        this.setPopupMenu();
        this.getTable().setSelectionBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
        this.getTable().setSelectionForeground(Color.black);
        this.getTable().setShowGrid(true);
        this.getTable().setColumnSelectionAllowed(false);
        this.setRenderersAndEditors();
        AlarmsManager.getInstance().addAlarmSourceSelectionListener(this.m_storageAlarmSelection);
    }

    protected void setPopupMenu() {
        SrDRStorageTablePopupMenu<StorageDeviceNode> popup = new SrDRStorageTablePopupMenu<StorageDeviceNode>(this, this.myView, this.myOwner);
        this.setTablePopUpMenuObject(popup);
    }

    @Override
    public void setModel(SrTableModel model) {
        super.setModel(model);
        TableModelEvent event = new TableModelEvent(model);
        model.fireTableChanged(event);
        this.setRowSelection();
        this.activateTimerRefreshViewIfHasABlinkingStorageDevice(-1);
        if (model instanceof SrStorageTableModel) {
            ((SrStorageTableModel)model).addStorageTableModelListener(this);
        }
    }

    protected void setRowSelection() {
        Integer[] selectedRows = ((SrStorageTableModel)this.getModel()).getSelectedRowIndices();
        if (selectedRows != null && selectedRows.length > 0) {
            this.setRowSelectionSet(selectedRows[0], selectedRows[selectedRows.length - 1]);
            this.scrollToRow(selectedRows[0]);
        } else {
            this.getTable().clearSelection();
        }
    }

    protected void setRenderersAndEditors() {
        TableColumn tableColumn;
        int columnCount = this.getTable().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            tableColumn = this.getTable().getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new StorageTableCellRenderer(StorageTableHeader.DISK_ALIAS));
        }
        int ind = ((SrStorageTableModel)this.getModel()).getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        tableColumn = this.getTable().getColumnModel().getColumn(ind);
        tableColumn.setCellEditor(new SrTableCellEditor());
        this.getTable().addTableCellEditListener(new TableCellEditAdapter(){

            @Override
            public void tableEditingStopped(TableCellEditEvent e) {
                String oldVal = (String)e.getEditorOldValue();
                String newVal = (String)e.getEditorValue();
                StorageDeviceNode node = (StorageDeviceNode)((AliasObject)e.getTableCellOldValue()).getValue();
                if (oldVal.equals(newVal.trim())) {
                    return;
                }
                HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>();
                params.put(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS, newVal.trim());
                SrAction.blockActions(Collections.singleton(DirectAccessDeviceManager.getInstance().renameStorageDevice(node, params)), StatusPanel.getInstance());
            }
        });
    }

    protected void readStorageFromServer() {
        StorageManager.getInstance().readAllStorageDataFromServer();
    }

    protected void buildTable(TableModel model) {
        for (int k = 0; k < this.getModel().getColumnCount(); ++k) {
            TableColumn column = this.getTable().getColumnModel().getColumn(k);
            column.setPreferredWidth(75);
        }
        JTableHeader header = this.getTable().getTableHeader();
        header.setUpdateTableInRealTime(true);
        header.setFont(new Font("Verdana", 0, 9));
        this.getScrollPane().getViewport().setBackground(LookAndFill.TABLE_SCROLL_BACKGROUND_COLOR);
    }

    private void printTable() {
        if (this.DEBUG) {
            SrStorageTableModel model = (SrStorageTableModel)this.getTable().getModel();
            int col = model.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
            int size = model.getRowCount();
            theLogger.trace(SrLogCategories.LEGACY, "Storage table after sorting: ");
            for (int i = 0; i < size; ++i) {
                theLogger.trace(SrLogCategories.LEGACY, model.getValueAt(i, col));
            }
        }
    }

    @Override
    public void removeListeners() {
        ((SrStorageTableModel)this.getModel()).removeStorageTableModelListener(this);
        AlarmsManager.getInstance().removeAlarmSourceSelectionListener(this.m_storageAlarmSelection);
    }

    protected void finalize() throws Throwable {
        this.removeListeners();
        super.finalize();
    }

    @Override
    public void storageElementsInserted(StorageTableModelEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "StorageTable: storageElementsInserted. sorting table.");
        this.sortByAlias();
    }

    protected void activateTimerRefreshViewIfHasABlinkingStorageDevice(int row) {
        SrTableModel model = this.getModel();
        if (model instanceof SrStorageTableModel) {
            if (row > -1) {
                this.activateTimerRefreshView(true, row);
            } else {
                ArrayList nodes = ((SrStorageTableModel)model).getBlinkingStorageDevices();
                for (int i = 0; i < nodes.size(); ++i) {
                    this.activateTimerRefreshView(true, (Integer)nodes.get(i));
                }
            }
        }
    }

    @Override
    public void storageElementsBlinkingStateChanged(StorageTableModelEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "StorageTable: storageElementsBlinkingStateChanged.");
        StorageDeviceNode src = (StorageDeviceNode)e.getSource();
        int row = ((SrStorageTableModel)this.getModel()).getStorageDeviceNodeRow(src);
        if (src.isBlinking()) {
            this.activateTimerRefreshView(true, row);
        } else {
            this.activateTimerRefreshView(false, row);
        }
    }

    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        if (rowIndices != null && rowIndices.length > 0) {
            this.updateDiskGraphicViewPanel(rowIndices[0]);
            ((SrStorageTableModel)this.getModel()).setRowSelected(rowIndices[0], rowIndices[rowIndices.length - 1]);
            ((SrStorageTableModel)this.getModel()).setRowSelected(rowIndices[0], rowIndices[rowIndices.length - 1]);
        } else {
            this.clearDiskGraphicViewPanel();
            ((SrStorageTableModel)this.getModel()).setRowSelected(-1, -1);
        }
    }

    private void clearDiskGraphicViewPanel() {
        if (this.diskGraphicViewPanel != null) {
            this.diskGraphicViewPanel.clear();
        }
    }

    private void updateDiskGraphicViewPanel(int row) {
        theLogger.trace(SrLogCategories.LEGACY, "StorageTable::: Start updating the Graphic panel....");
        SrStorageTableModel tableModel = (SrStorageTableModel)this.getModel();
        if (tableModel.getValueAt(row, 0) instanceof SubDirectAccessDeviceNode) {
            this.clearDiskGraphicViewPanel();
        }
        int col = tableModel.getColumnIndex(StorageTableHeader.TOTAL_SPACE.getColumnName());
        try {
            Object storageSpace = tableModel.getValueAt(row, col);
            if (storageSpace instanceof StorageDeviceSpace) {
                StorageDeviceSpace totalSpace = (StorageDeviceSpace)tableModel.getValueAt(row, col);
                this.diskGraphicViewPanel.setTotalSpace(totalSpace);
            }
            List splits = tableModel.getDiskSplits(row);
            StorageDeviceNode parent = tableModel.getDisk(row);
            this.diskGraphicViewPanel.setSubdisks(splits, parent);
            this.diskGraphicViewPanel.revalidate();
            this.diskGraphicViewPanel.repaint();
            theLogger.trace(SrLogCategories.LEGACY, "StorageTable::: finish updating the Graphic panel....");
        }
        catch (Exception e) {
            theLogger.warn(SrLogCategories.LEGACY, e, "Could not update disk graphics.");
        }
    }

    public void setDiskGraphicViewPanel(DiskGraphicViewPanel diskGraphicViewPanel) {
        this.diskGraphicViewPanel = diskGraphicViewPanel;
    }

    private void sortByAlias() {
        SrStorageTableModel model = (SrStorageTableModel)this.getTable().getModel();
        int col = model.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        this.invokeColumnSortOnStartup(col, true);
        this.setRowSelection();
        this.printTable();
    }

    protected StorageDeviceNode[] getSelectedDeviceNodes() {
        int[] aliasIndices = this.getSelectedRows();
        if (aliasIndices != null) {
            ArrayList<StorageDeviceNode> nodeColl = new ArrayList<StorageDeviceNode>(aliasIndices.length);
            for (int i = 0; i < aliasIndices.length; ++i) {
                int col = ((SrStorageTableModel)this.getModel()).getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
                AliasObject alias = (AliasObject)this.getTable().getValueAt(aliasIndices[i], col);
                if (alias == null || alias.getValue() == null) continue;
                nodeColl.add((StorageDeviceNode)alias.getValue());
            }
            StorageDeviceNode[] nodes = new StorageDeviceNode[nodeColl.size()];
            nodeColl.toArray(nodes);
            return nodes;
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, "SrTablePanel.getSelectedRows() returned null");
        return new StorageDeviceNode[0];
    }

    public Object[] getSelectedAliases() {
        int[] aliasIndices = this.getSelectedRows();
        Object[] aliases = new Object[aliasIndices.length];
        int col = ((SrStorageTableModel)this.getModel()).getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
        for (int i = 0; i < aliasIndices.length; ++i) {
            boolean isFree;
            AliasObject alias = (AliasObject)this.getTable().getValueAt(aliasIndices[i], 0);
            StorageDeviceNode node = (StorageDeviceNode)alias.getValue();
            boolean isExposed = node.isExposed();
            boolean hasSubdisks = false;
            if (node instanceof DirectAccessDeviceNode) {
                hasSubdisks = ((DirectAccessDeviceNode)node).hasSubdisks();
            }
            boolean hasVolumeParent = node.hasVolumeParent();
            boolean bl = isFree = !hasSubdisks && !hasVolumeParent;
            if (isExposed || !isFree) continue;
            aliases[i] = this.getTable().getValueAt(aliasIndices[i], col);
        }
        return aliases;
    }

    public void clear() {
        this.removeAllRows();
        this.repaint();
    }

    public void refresh() {
        this.repaint();
    }

    protected void activateTimerRefreshView(boolean active, int row) {
        if (active) {
            if (this.timer == null) {
                ViewRefreshTimer refreshAct = new ViewRefreshTimer();
                refreshAct.addCellToBeRefresh(row, 0);
                this.timer = new Timer(1000, refreshAct);
                this.timer.setRepeats(true);
                this.timer.start();
            } else {
                ((ViewRefreshTimer)this.timer.getActionListeners()[0]).addCellToBeRefresh(row, 0);
            }
        } else if (this.timer != null) {
            ViewRefreshTimer refreshAct = (ViewRefreshTimer)this.timer.getActionListeners()[0];
            refreshAct.removeCellToBeRefresh(row, 0);
            if (!refreshAct.runTimer()) {
                this.timer.stop();
                this.timer = null;
            }
        }
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.myDeleteAction;
    }

    @Override
    public AlarmAction getSpecificAlarmsAction() {
        return this.myOpenSpecificAlarmsAction;
    }

    @Override
    public AlarmAction getPropagatedAlarmsAction() {
        return this.myOpenPropagatedAlarmsAction;
    }

    public SynchronizeElementAction getSynchronizeAction() {
        return null;
    }

    public void addVolumeCreationSelectionListener(VolumeCreationSelectionListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeVolumeCreationSelectionListener(VolumeCreationSelectionListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public Object getDevice(int index) {
        return ((SrStorageTableModel)this.getModel()).getDisk(index);
    }

    @Override
    public Object[] getSelectedFreeAndNotExposedAliases() {
        return this.getSelectedAliases();
    }

    @Override
    public int[] getSelectedIndexes() {
        return this.getSelectedRows();
    }

    @Override
    public JComponent getMyComponent() {
        return this;
    }

    @Override
    protected Class getTableHeaderClass() {
        return StorageTableHeader.class;
    }

    class StorageAlarmSelection
    extends AlarmSourceSelectionAdapter {
        StorageAlarmSelection() {
        }

        @Override
        public void directAccessDeviceSelected(AlarmSourceSelectionEvent event) {
            DirectAccessDeviceNode node = (DirectAccessDeviceNode)event.getNode();
            this.select(node);
        }

        @Override
        public void subDirectAccessDeviceSelected(AlarmSourceSelectionEvent event) {
            SubDirectAccessDeviceNode node = (SubDirectAccessDeviceNode)event.getNode();
            DirectAccessDeviceNode parent = node.getDirectAccessDeviceParent();
            if (parent != null) {
                theLogger.trace(SrLogCategories.LEGACY, "StorageTable::: Selecting the subdisk source ....");
                this.select(parent);
            }
        }

        private void select(SrTreeNode node) {
            SrStorageTableModel model = (SrStorageTableModel)SrStorageTablePanel.this.getTable().getModel();
            int rowCount = model.getRowCount();
            int col = model.getColumnIndex(StorageTableHeader.DISK_ALIAS.getColumnName());
            for (int i = 0; i < rowCount; ++i) {
                AliasObject obj = (AliasObject)model.getValueAt(i, col);
                DirectAccessDeviceNode disk = (DirectAccessDeviceNode)obj.getValue();
                if (!disk.equals(node)) continue;
                SrStorageTablePanel.this.setRowSelectionSet(i, i);
                SrStorageTablePanel.this.scrollToRow(i);
                return;
            }
        }
    }

    class ViewRefreshTimer
    implements ActionListener {
        private Vector m_cells = new Vector();

        public void addCellToBeRefresh(int row, int col) {
            if (this.getCellValue(row, col) == -1) {
                this.m_cells.add(new Integer[]{new Integer(row), new Integer(col)});
            }
        }

        public void removeCellToBeRefresh(int row, int col) {
            int index = this.getCellValue(row, col);
            if (index != -1) {
                this.m_cells.remove(index);
            }
        }

        public boolean runTimer() {
            return this.m_cells.size() > 0;
        }

        private int getCellValue(int row, int col) {
            int returnVal = -1;
            for (int i = 0; i < this.m_cells.size(); ++i) {
                Integer[] cell = (Integer[])this.m_cells.get(i);
                int currRow = cell[0];
                int currCol = cell[1];
                if (currRow != row || currCol != col) continue;
                returnVal = i;
                break;
            }
            return returnVal;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < this.m_cells.size(); ++i) {
                Integer[] cell = (Integer[])this.m_cells.get(i);
                ((SrTableModel)SrStorageTablePanel.this.getTable().getModel()).fireTableCellUpdated(cell[0], cell[1]);
            }
        }
    }
}

