/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceSpace;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SynchronizeElementAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.storage.DiskGraphicViewPanel;
import com.sanrad.nms.client.gui.storage.SrDRStorageTablePopupMenu;
import com.sanrad.nms.client.gui.storage.SrStorageComponentInterface;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.StorageSpace;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.StorageSize;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DiskViewComponent
extends JComponent
implements DragGestureListener,
DragSourceListener,
SrStorageComponentInterface {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final Color freeSpaceColor = new Color(235, 234, 248);
    private static final Color[] colors = new Color[]{new Color(190, 250, 249), new Color(137, 167, 239), new Color(205, 239, 93), new Color(32, 157, 201)};
    private static final int diskHeight = 150;
    private static final Dimension diskBaseDim = new Dimension(150, 50);
    private static final Color contourColor = Color.white;
    private static final Color hollowDiskBorderColor = Color.lightGray;
    private static final Color selectedSplitBorderColor = Color.red;
    private static final Color selectedTextColor = Color.red;
    private StorageDeviceSpace totalSpace = null;
    private BigInteger[] subdisksSize;
    private List<RemoteObject> subdisks;
    private SrDRStorageTablePopupMenu m_popup;
    private Color freeSpaceDetailsColor = new Color(114, 114, 200);
    private Font subdiskDetailsFont = new Font("Verdana", 0, 9);
    private Font freeSpaceDetailsFont = new Font("Verdana", 1, 9);
    private StorageDeviceNode parentDisk;
    private final String DELIM = ".";
    DragSource dragSource = null;
    private final DiskViewController controller = new DiskViewController();
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private DiskGraphicViewPanel myWorkWith;
    public final View<SubDirectAccessDeviceNode> myView = new SrTableView<SubDirectAccessDeviceNode>((ListSelectionModel)this.selectionModel){

        @Override
        public Collection<SubDirectAccessDeviceNode> getValue() {
            if (DiskViewComponent.this.subdisks == null) {
                return Collections.EMPTY_LIST;
            }
            int[] indexes = DiskViewComponent.this.getSelectedIndexes();
            ArrayList<SubDirectAccessDeviceNode> retVal = new ArrayList<SubDirectAccessDeviceNode>(indexes.length);
            for (int index : indexes) {
                RemoteObject stub = (RemoteObject)DiskViewComponent.this.subdisks.get(index);
                SubDirectAccessDeviceNode node = (SubDirectAccessDeviceNode)SystemRootNode.getInstance().getRefByStub(stub);
                if (node == null) continue;
                retVal.add(node);
            }
            return retVal;
        }
    };

    public DiskViewComponent(DiskGraphicViewPanel workWith) {
        this.myWorkWith = workWith;
        this.addMouseListener(new ViewMouseListener());
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DiskViewComponent.this.repaint();
            }
        });
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public void setPopup(JFrame owner) {
        this.m_popup = new SrDRStorageTablePopupMenu<SubDirectAccessDeviceNode>(this, this.myView, owner);
    }

    public void setParentDisk(StorageDeviceNode parent) {
        this.parentDisk = parent;
        if (parent instanceof DirectAccessDeviceNode || parent == null) {
            this.controller.m_disk = (DirectAccessDeviceNode)parent;
        }
    }

    private void showPopup(MouseEvent e) {
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.m_popup.show(e, SystemRootNode.getInstance().getClusterNodeOfSource(this.parentDisk));
    }

    private boolean isFree(DirectAccessDeviceNode node) {
        boolean isExposed = node.isExposed();
        boolean hasVolume = node.getParent() instanceof VolumeTreeNode;
        return !isExposed && !hasVolume;
    }

    public void setTotalSpace(StorageDeviceSpace totalSpace) {
        this.totalSpace = totalSpace;
    }

    public List<RemoteObject> getSubdisks() {
        return this.subdisks;
    }

    public void setSubdisks(List<RemoteObject> subdisks) {
        this.selectionModel.clearSelection();
        this.subdisks = subdisks;
        if (subdisks != null) {
            int len = subdisks.size();
            this.subdisksSize = new BigInteger[len];
            for (int i = 0; i < len; ++i) {
                try {
                    StorageSpace space = (StorageSpace)subdisks.get(i);
                    this.subdisksSize[i] = space.getSize();
                    continue;
                }
                catch (RemoteException re) {
                    theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                }
            }
        }
        this.repaint();
    }

    private void drawAllSubdisks(Graphics g) {
        boolean isEmpty;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean bl = isEmpty = this.subdisksSize == null || this.subdisksSize.length == 0;
        if (!isEmpty) {
            int i = this.subdisks.size();
            while (i-- > 0) {
                Color c = null;
                Color borderC = contourColor;
                c = this.subdisks.get(i) instanceof SubDirectAccessDevice ? colors[i % colors.length] : freeSpaceColor;
                this.drawCylinder(g, this.controller.getDiskSplitTop(i), this.controller.getDiskSplitHeight(i), c, borderC);
            }
        } else {
            this.drawCylinder(g, this.controller.getDiskY() + DiskViewComponent.diskBaseDim.height / 2, this.controller.getCylinderHeight(), this.getBackground(), hollowDiskBorderColor);
        }
    }

    private void drawCylinder(Graphics g, int y, int height, Color c, Color borderC) {
        g.setColor(c);
        g.fillOval(this.controller.getDiskX(), y - DiskViewComponent.diskBaseDim.height / 2, DiskViewComponent.diskBaseDim.width, DiskViewComponent.diskBaseDim.height);
        g.fillOval(this.controller.getDiskX(), y + height - DiskViewComponent.diskBaseDim.height / 2, DiskViewComponent.diskBaseDim.width, DiskViewComponent.diskBaseDim.height);
        g.fillRect(this.controller.getDiskX(), y, DiskViewComponent.diskBaseDim.width, height);
        g.setColor(borderC);
        g.drawLine(this.controller.getDiskX(), y, this.controller.getDiskX(), y + height);
        g.drawLine(this.controller.getDiskX() + DiskViewComponent.diskBaseDim.width, y, this.controller.getDiskX() + DiskViewComponent.diskBaseDim.width, y + height);
        g.drawOval(this.controller.getDiskX(), y - DiskViewComponent.diskBaseDim.height / 2, DiskViewComponent.diskBaseDim.width, DiskViewComponent.diskBaseDim.height);
        g.drawArc(this.controller.getDiskX(), y + height - DiskViewComponent.diskBaseDim.height / 2, DiskViewComponent.diskBaseDim.width, DiskViewComponent.diskBaseDim.height, 0, -180);
    }

    private void drawSubdiskSelection(Graphics g) {
        g.setColor(selectedSplitBorderColor);
        if (this.subdisksSize != null && this.subdisksSize.length > 0) {
            int i = this.subdisksSize.length;
            while (i-- > 0) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                int top = this.controller.getDiskSplitTop(i);
                int bottom = this.controller.getDiskSplitBottom(i);
                if (i == 0) {
                    g.drawOval(this.controller.getDiskX(), this.controller.getDiskY(), DiskViewComponent.diskBaseDim.width, DiskViewComponent.diskBaseDim.height);
                    g.drawArc(this.controller.getDiskX(), bottom - DiskViewComponent.diskBaseDim.height / 2, DiskViewComponent.diskBaseDim.width, DiskViewComponent.diskBaseDim.height, 0, -180);
                    continue;
                }
                g.drawArc(this.controller.getDiskX(), top - DiskViewComponent.diskBaseDim.height / 2, DiskViewComponent.diskBaseDim.width, DiskViewComponent.diskBaseDim.height, 0, -180);
                g.drawArc(this.controller.getDiskX(), bottom - DiskViewComponent.diskBaseDim.height / 2, DiskViewComponent.diskBaseDim.width, DiskViewComponent.diskBaseDim.height, 0, -180);
            }
        }
    }

    private void drawDiskDetails(Graphics g) {
        FontMetrics fm = g.getFontMetrics(this.subdiskDetailsFont);
        int fontHeight = fm.getHeight();
        int i = this.subdisksSize.length;
        while (i-- > 0) {
            if (this.subdisks.get(i) instanceof SubDirectAccessDevice) {
                g.setFont(this.subdiskDetailsFont);
                g.setColor(this.selectionModel.isSelectedIndex(i) ? selectedTextColor : Color.black);
            } else {
                g.setFont(this.freeSpaceDetailsFont);
                g.setColor(this.freeSpaceDetailsColor);
            }
            int strX = this.getSplitDetailsX(i, fontHeight);
            int strY = this.getSplitDetailsY(i, fontHeight);
            String detailsStr = this.getSplitDetailsString(i);
            g.drawString(detailsStr, strX, strY);
            g.setColor(hollowDiskBorderColor);
            int strW = fm.stringWidth(detailsStr);
            int lineY = strY - fm.getHeight() / 2;
            int lineEndX = this.controller.getDiskX() - 40;
            int lineStartX = strX + strW;
            int lineOriginOnDiskY = (this.controller.getDiskSplitTop(i) + this.controller.getDiskSplitBottom(i)) / 2;
            if (!this.areDetailsOnBothSides(fontHeight) || i % 2 == 0) {
                lineEndX = this.controller.getDiskX() - 40;
                lineStartX = strX + strW;
                g.drawLine(lineEndX, lineY, this.controller.getDiskX(), this.controller.getDiskSplitBottom(i));
            } else {
                lineEndX = strX - 2;
                lineStartX = lineEndX - 10;
                g.drawLine(lineStartX, lineY, this.controller.getDiskX() + DiskViewComponent.diskBaseDim.width, this.controller.getDiskSplitBottom(i));
            }
            if (lineEndX <= lineStartX) continue;
            g.drawLine(lineStartX, lineY, lineEndX, lineY);
        }
        g.setColor(Color.black);
        int y = this.getHeight() - 24;
        int offset = 1;
        String str = "Total: " + StorageSize.getSizeAsString(this.totalSpace.getSize());
        g.drawLine(0, y, fm.stringWidth(str + offset), y);
        g.setFont(this.subdiskDetailsFont);
        g.drawString(str, offset, y + fm.getHeight());
    }

    private int getSplitDetailsY(int splitIndex, int aFontHeight) {
        int fontHeight = aFontHeight + 2;
        int topOfDisk = this.controller.getDiskY() + DiskViewComponent.diskBaseDim.height / 2;
        int bottomOfDisk = topOfDisk + this.controller.getCylinderHeight();
        int centerOfDisk = (topOfDisk + bottomOfDisk) / 2;
        if (this.areDetailsOnBothSides(aFontHeight)) {
            int totalHeight = fontHeight * this.subdisks.size() / 2;
            int firstSplitY = centerOfDisk - totalHeight / 2;
            if (splitIndex % 2 == 0) {
                return firstSplitY + fontHeight * splitIndex / 2;
            }
            return firstSplitY + fontHeight * (splitIndex + 1) / 2;
        }
        int totalHeight = fontHeight * this.subdisks.size();
        int firstSplitY = centerOfDisk - totalHeight / 2;
        return firstSplitY + fontHeight * splitIndex;
    }

    private int getSplitDetailsX(int splitIndex, int fontHeight) {
        return this.areDetailsOnBothSides(fontHeight) && splitIndex % 2 != 0 ? this.controller.getDiskX() + DiskViewComponent.diskBaseDim.width + 50 : 10;
    }

    private String getSplitDetailsString(int i) {
        double totalSize = this.controller.getTotalSize();
        int percentage = (int)(this.subdisksSize[i].doubleValue() / totalSize * 100.0);
        String detailsStr = null;
        if (this.subdisks.get(i) instanceof SubDirectAccessDevice) {
            SubDirectAccessDeviceNode node = (SubDirectAccessDeviceNode)SystemRootNode.getInstance().getRefByStub(this.subdisks.get(i));
            if (node == null) {
                return "";
            }
            String[] args = new String[]{node.getAlias(), StorageSize.getSizeAsString(this.subdisksSize[i]), String.valueOf(percentage)};
            detailsStr = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_STORAGE_SUBDISK_DETAILS_FORMAT, args);
        } else {
            String[] args = new String[]{StorageSize.getSizeAsString(this.subdisksSize[i]), String.valueOf(percentage)};
            detailsStr = this.parentDisk.hasVolumeParent() || this.parentDisk.isExposed() ? ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_STORAGE_ALLOCATED_SPACE_DETAILS_FORMAT, args) : ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_STORAGE_FREE_SPACE_DETAILS_FORMAT, args);
        }
        return detailsStr;
    }

    private boolean areDetailsOnBothSides(int aFontHeight) {
        int fontHeight = aFontHeight + 2;
        return fontHeight * (this.subdisks.size() + 1) > this.getHeight();
    }

    private void drawDisk(Graphics g) {
        this.drawAllSubdisks(g);
        this.drawSubdiskSelection(g);
        this.drawDiskDetails(g);
    }

    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
        DirectAccessDevice parentStub = event.getParentStub();
        this.refreshView(parentStub);
    }

    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
    }

    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
        DirectAccessDevice parentStub = event.getParentStub();
        this.refreshView(parentStub);
    }

    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        DirectAccessDevice parentStub = event.getParentStub();
        this.refreshView(parentStub);
    }

    public void directAccessDeviceChanged(DirectAccessDeviceEvent event) {
        this.refreshView(event.getStub());
    }

    public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
        this.refreshView(event.getStub());
    }

    public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
        this.refreshView(event.getStub());
    }

    private void refreshView(Object parentStub) {
        DirectAccessDeviceNode parent;
        if (this.parentDisk != null && (parent = (DirectAccessDeviceNode)this.parentDisk).getStub().equals(parentStub)) {
            StorageDeviceSpace totalSpace;
            this.totalSpace = totalSpace = new StorageDeviceSpace(parent.getTotalSpace());
            List<RemoteObject> splitsVector = parent.getSplits();
            this.setSubdisks(splitsVector);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawDisk(g);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess()) {
            // empty if block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        String selected;
        StringBuffer selectedBuffer = new StringBuffer();
        int[] selectedDisks = this.getSelectedIndexes();
        if (selectedDisks != null) {
            for (int i = 0; i < selectedDisks.length; ++i) {
                if (selectedDisks[i] <= 0) continue;
                selectedBuffer.append(Integer.toString(selectedDisks[i]) + ".");
            }
        }
        if ((selected = selectedBuffer.toString()) == null || selected.equals("")) {
            theLogger.trace(SrLogCategories.LEGACY, "nothing was selected");
            return;
        }
        if (selected == null) {
            theLogger.trace(SrLogCategories.LEGACY, "nothing was selected");
        }
    }

    private void setSelectedDisk(int diskNum) {
        this.selectionModel.setSelectionInterval(diskNum, diskNum);
    }

    private void setSelectedSubDisk(int diskNum) {
        this.selectionModel.setSelectionInterval(diskNum, diskNum);
    }

    public void select(SubDirectAccessDeviceNode node) {
        int index = this.subdisks.indexOf(node.getStub());
        if (index >= 0) {
            this.selectionModel.setSelectionInterval(index, index);
        }
    }

    @Override
    public Object getDevice(int index) {
        return SystemRootNode.getInstance().getRefByStub(this.subdisks.get(index));
    }

    @Override
    public JComponent getMyComponent() {
        return this;
    }

    @Override
    public Object[] getSelectedFreeAndNotExposedAliases() {
        ArrayList<SubDirectAccessDeviceNode> selectedNodes = new ArrayList<SubDirectAccessDeviceNode>();
        int[] selection = this.getSelectedIndexes();
        for (int i = 0; i < selection.length; ++i) {
            SubDirectAccessDeviceNode node;
            StorageSpace split = (StorageSpace)this.subdisks.get(selection[i]);
            if (!(split instanceof SubDirectAccessDevice) || (node = (SubDirectAccessDeviceNode)SystemRootNode.getInstance().getRefByStub(split)) == null || !this.isFree(node)) continue;
            selectedNodes.add(node);
        }
        return selectedNodes.toArray();
    }

    @Override
    public int[] getSelectedIndexes() {
        ArrayList<Integer> selectionList = new ArrayList<Integer>();
        if (this.subdisksSize == null) {
            return new int[0];
        }
        for (int i = 0; i < this.subdisksSize.length; ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            selectionList.add(i);
        }
        int[] selectionArray = new int[selectionList.size()];
        int i = selectionArray.length;
        while (i-- > 0) {
            selectionArray[i] = (Integer)selectionList.get(i);
        }
        return selectionArray;
    }

    private static boolean isInArcRange(Point aPoint, int aX, int aY, int aWidth, int aHeight, int aDistance) {
        boolean insideDownReq;
        int x = aPoint.x;
        int y = aPoint.y;
        double x_2 = Math.pow(x - aX - aWidth / 2, 2.0);
        double y_2 = Math.pow(y - aY - aHeight / 2, 2.0);
        double a_2 = Math.pow(aWidth / 2, 2.0);
        double b_2 = Math.pow(aHeight / 2, 2.0);
        double y2_2 = Math.pow(y - aY - aHeight / 2 + aDistance, 2.0);
        boolean insideLowOval = x_2 / a_2 + y_2 / b_2 < 1.0;
        boolean insideUpReq = x > aX && x < aX + aWidth && y < aY + aHeight / 2;
        boolean outsideHighOval = x_2 / a_2 + y2_2 / b_2 > 1.0;
        boolean bl = insideDownReq = x > aX && x < aX + aWidth && y > aY + aHeight / 2 - aDistance;
        return (insideLowOval || insideUpReq) && outsideHighOval && insideDownReq;
    }

    private static boolean isInOval(Point aPoint, int aX, int aY, int aWidth, int aHeight) {
        double b_2;
        int x = aPoint.x;
        int y = aPoint.y;
        double x_2 = Math.pow(x - aX - aWidth / 2, 2.0);
        double y_2 = Math.pow(y - aY - aHeight / 2, 2.0);
        double a_2 = Math.pow(aWidth / 2, 2.0);
        return x_2 / a_2 + y_2 / (b_2 = Math.pow(aHeight / 2, 2.0)) < 1.0;
    }

    @Override
    public AlarmAction getSpecificAlarmsAction() {
        return this.myWorkWith.myOpenSpecificAlarmsAction;
    }

    @Override
    public AlarmAction getPropagatedAlarmsAction() {
        return this.myWorkWith.myOpenPropagatedAlarmsAction;
    }

    public SynchronizeElementAction getSynchronizeAction() {
        return null;
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.myWorkWith.myDeleteAction;
    }

    private class DiskViewController {
        DirectAccessDeviceNode m_disk;

        private DiskViewController() {
        }

        boolean isHollowDisk() {
            if (this.m_disk != null) {
                return this.m_disk.isConfigured();
            }
            return true;
        }

        int getDiskSplitTop(int splitIndex) {
            int effectiveCylinderHeight = this.getCylinderHeight();
            double sizeToSplitNotIncluding = this.totalSizeUpTo(splitIndex) - DiskViewComponent.this.subdisksSize[splitIndex].doubleValue();
            return (int)((double)this.getZeroHeight() + (double)effectiveCylinderHeight * sizeToSplitNotIncluding / this.getTotalSize());
        }

        int getDiskSplitBottom(int splitIndex) {
            int effectiveCylinderHeight = this.getCylinderHeight();
            return (int)((double)this.getZeroHeight() + (double)effectiveCylinderHeight * this.totalSizeUpTo(splitIndex) / this.getTotalSize());
        }

        int getDiskSplitHeight(int splitIndex) {
            int effectiveCylinderHeight = this.getCylinderHeight();
            return (int)((double)effectiveCylinderHeight * DiskViewComponent.this.subdisksSize[splitIndex].doubleValue() / this.getTotalSize());
        }

        int getDiskX() {
            return DiskViewComponent.this.getWidth() / 2 - diskBaseDim.width / 2;
        }

        int getDiskY() {
            return DiskViewComponent.this.getHeight() / 2 - this.getCylinderHeight() / 2 - diskBaseDim.height / 2;
        }

        int getZeroHeight() {
            return this.getDiskY() + diskBaseDim.height / 2;
        }

        int getCylinderHeight() {
            return 150;
        }

        int getCylinderWidth() {
            return diskBaseDim.width;
        }

        double getTotalSize() {
            return this.isHollowDisk() ? this.totalSizeUpTo(DiskViewComponent.this.subdisksSize.length - 1) : DiskViewComponent.this.totalSpace.getSize().doubleValue();
        }

        private double totalSizeUpTo(int subDiskIndex) {
            double d = 0.0;
            if (DiskViewComponent.this.subdisksSize != null) {
                for (int i = 0; i <= subDiskIndex; ++i) {
                    if (DiskViewComponent.this.subdisksSize[i] == null) continue;
                    d += DiskViewComponent.this.subdisksSize[i].doubleValue();
                }
            }
            return d;
        }

        int getSplitIndexAt(Point aPoint) {
            FontMetrics fm = DiskViewComponent.this.getFontMetrics(DiskViewComponent.this.subdiskDetailsFont);
            int i = DiskViewComponent.this.subdisksSize.length;
            while (i-- > 0) {
                int top = this.getDiskSplitTop(i);
                int bottom = this.getDiskSplitBottom(i);
                if (i == 0 && DiskViewComponent.isInOval(aPoint, this.getDiskX(), this.getDiskY(), diskBaseDim.width, diskBaseDim.height)) {
                    return i;
                }
                if (DiskViewComponent.isInArcRange(aPoint, this.getDiskX(), bottom - diskBaseDim.height / 2, diskBaseDim.width, diskBaseDim.height, bottom - top)) {
                    return i;
                }
                int x = aPoint.x;
                int y = aPoint.y;
                String detailsStr = DiskViewComponent.this.getSplitDetailsString(i);
                int fontH = fm.getHeight();
                int detailsBottom = DiskViewComponent.this.getSplitDetailsY(i, fontH);
                int detailsTop = detailsBottom - fontH;
                int detailsLeft = DiskViewComponent.this.getSplitDetailsX(i, fontH);
                int detailsRight = detailsLeft + fm.stringWidth(detailsStr);
                if (x <= detailsLeft || x >= detailsRight || y <= detailsTop || y >= detailsBottom) continue;
                return i;
            }
            return -1;
        }
    }

    class ViewMouseListener
    extends MouseAdapter {
        ViewMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int selectedIndex = DiskViewComponent.this.controller.getSplitIndexAt(e.getPoint());
            if (!SwingUtilities.isRightMouseButton(e)) {
                if (e.isControlDown()) {
                    if (selectedIndex >= 0 && DiskViewComponent.this.subdisks.get(selectedIndex) instanceof SubDirectAccessDevice) {
                        if (DiskViewComponent.this.selectionModel.isSelectedIndex(selectedIndex)) {
                            DiskViewComponent.this.selectionModel.removeSelectionInterval(selectedIndex, selectedIndex);
                        } else {
                            DiskViewComponent.this.selectionModel.addSelectionInterval(selectedIndex, selectedIndex);
                        }
                    }
                } else if (selectedIndex >= 0 && DiskViewComponent.this.subdisks.get(selectedIndex) instanceof SubDirectAccessDevice) {
                    DiskViewComponent.this.selectionModel.setSelectionInterval(selectedIndex, selectedIndex);
                } else {
                    DiskViewComponent.this.selectionModel.clearSelection();
                }
            } else if (DiskViewComponent.this.selectionModel.isSelectedIndex(selectedIndex)) {
                DiskViewComponent.this.showPopup(e);
            } else if (selectedIndex >= 0 && DiskViewComponent.this.subdisks.get(selectedIndex) instanceof SubDirectAccessDevice) {
                if (e.isControlDown()) {
                    DiskViewComponent.this.selectionModel.addSelectionInterval(selectedIndex, selectedIndex);
                } else {
                    DiskViewComponent.this.selectionModel.setSelectionInterval(selectedIndex, selectedIndex);
                }
                DiskViewComponent.this.showPopup(e);
            } else {
                DiskViewComponent.this.selectionModel.clearSelection();
            }
        }
    }
}

