/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.storage;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceSpace;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceAdapter;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceListener;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionAdapter;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionEvent;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.storage.DiskViewComponent;
import com.sanrad.nms.client.gui.storage.dialogs.DirectAccessDevicePropertiesDialog;
import com.sanrad.swing.StatusPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DiskGraphicViewPanel
extends JPanel
implements SubDirectAccessDeviceListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private DiskViewComponent diskViewComp = new DiskViewComponent(this);
    private DiskListener myDiskListener = new DiskListener();
    private JFrame myOwner;
    private SubDiskAlarmSourceSelection m_subdiskSelection = new SubDiskAlarmSourceSelection();
    private static DiskGraphicViewPanel instance;
    private List subdisks;
    public final AlarmAction myOpenSpecificAlarmsAction;
    public final AlarmAction<SubDirectAccessDeviceNode> myOpenPropagatedAlarmsAction;
    public final DeleteAction myDeleteAction;

    private DiskGraphicViewPanel(JFrame owner) {
        this.myOpenSpecificAlarmsAction = new AlarmAction<SubDirectAccessDeviceNode>(this.diskViewComp.myView, true);
        this.myOpenPropagatedAlarmsAction = new AlarmAction<SubDirectAccessDeviceNode>(this.diskViewComp.myView, false);
        this.myDeleteAction = new DeleteAction<SubDirectAccessDeviceNode>(this.diskViewComp.myView, StatusPanel.getInstance(), null, true);
        this.myOwner = owner;
        this.myDeleteAction.setConfirmationString("Do you want to delete the selected subdisk?");
        this.myDeleteAction.setConfirmationTitle("Delete Subdisk");
        this.diskViewComp.setPopup(owner);
        this.setLayout(new BorderLayout());
        this.add((Component)this.diskViewComp, "Center");
        this.setBackground(Color.white);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this);
        DirectAccessDeviceManager.getInstance().addDirectAccessDeviceListener(this.myDiskListener);
    }

    public static synchronized DiskGraphicViewPanel getInstance(JFrame owner) {
        if (instance == null) {
            instance = new DiskGraphicViewPanel(owner);
        }
        return instance;
    }

    public void addAlarmSourceSelectionListener() {
        AlarmsManager.getInstance().addAlarmSourceSelectionListener(this.m_subdiskSelection);
    }

    public void removeListeners() {
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this);
        DirectAccessDeviceManager.getInstance().removeDirectAccessDeviceListener(this.myDiskListener);
        AlarmsManager.getInstance().addAlarmSourceSelectionListener(this.m_subdiskSelection);
    }

    @Override
    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
        this.diskViewComp.subDirecetAccessDeviceCreated(event);
    }

    @Override
    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
        this.diskViewComp.subDirecetAccessDeviceRemoved(event);
    }

    @Override
    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        this.diskViewComp.subDirecetAccessDeviceAliasChanged(event);
    }

    @Override
    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
    }

    public void setSubdisks(List subdisks, StorageDeviceNode parent) {
        this.subdisks = subdisks;
        if (subdisks != null) {
            this.diskViewComp.setSubdisks(subdisks);
            this.diskViewComp.setParentDisk(parent);
        }
    }

    public void clear() {
        this.subdisks = new ArrayList();
        this.setSubdisks(this.subdisks, null);
        this.setTotalSpace(new StorageDeviceSpace(new BigInteger("0")));
    }

    private boolean isFree(SubDirectAccessDeviceNode node) {
        boolean isExposed = node.isExposed();
        boolean bpar = node.getParent() instanceof VolumeTreeNode;
        return !isExposed && !bpar;
    }

    public void setTotalSpace(StorageDeviceSpace totalSpace) {
        this.diskViewComp.setTotalSpace(totalSpace);
    }

    public void setSubdisksSize(int[] sizes) {
    }

    public void newClusterHasBeenSelected() {
        this.clear();
    }

    private class DiskListener
    extends DirectAccessDeviceAdapter {
        private DiskListener() {
        }

        @Override
        public void directAccessDeviceChanged(DirectAccessDeviceEvent event) {
            DiskGraphicViewPanel.this.diskViewComp.directAccessDeviceChanged(event);
        }

        @Override
        public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
            DiskGraphicViewPanel.this.diskViewComp.directAccessDeviceDeExposed(event);
        }

        @Override
        public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
            DiskGraphicViewPanel.this.diskViewComp.directAccessDeviceExposed(event);
        }
    }

    class SubDiskAlarmSourceSelection
    extends AlarmSourceSelectionAdapter {
        SubDiskAlarmSourceSelection() {
        }

        @Override
        public void subDirectAccessDeviceSelected(AlarmSourceSelectionEvent e) {
            SubDirectAccessDeviceNode node = (SubDirectAccessDeviceNode)e.getNode();
            DirectAccessDeviceNode parent = node.getDirectAccessDeviceParent();
            JFrame frame = new JFrame();
            frame.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
            Object uo = parent.getUserObject();
            if (uo == null) {
                DirectAccessDevicePropertiesDialog props = new DirectAccessDevicePropertiesDialog(frame, parent, node);
                parent.setUserObject(props);
                props.show();
            } else {
                ((JDialog)uo).requestFocus();
            }
            DiskGraphicViewPanel.this.diskViewComp.select(node);
        }
    }
}

