/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.srv.radius;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.srv.radius.RadiusServersTableModelCollection;
import com.sanrad.nms.client.data.srv.radius.SrRadiusServersTableModel;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.srv.ExternalServersDialog;
import com.sanrad.nms.client.gui.srv.SrExternalServersTablePanel;
import com.sanrad.nms.client.gui.srv.radius.NewRadiusServerDialog;
import com.sanrad.nms.client.gui.srv.radius.SrRadiusServersTablePanel;
import com.sanrad.swing.actions.OperationController;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RadiusServersDialog
extends ExternalServersDialog {
    public static final int MAX_RADIUS_SERVERS_IN_SYSTEM = 2;

    public RadiusServersDialog(JFrame owner, ClusterNode clusterNode) {
        super(owner, clusterNode);
        this.controlButtons();
    }

    @Override
    protected void setTitle() {
        this.setTitle("RADIUS Servers");
    }

    @Override
    protected SrExternalServersTablePanel createTable() {
        SrRadiusServersTableModel model = (SrRadiusServersTableModel)RadiusServersTableModelCollection.getInstance().getCurrentModel();
        this.authServersTable = new SrRadiusServersTablePanel(model, (OperationController)this, this.owner);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                RadiusServersDialog.this.controlButtons();
            }
        });
        return this.authServersTable;
    }

    protected void controlButtons() {
        int rows = this.authServersTable.getModel().getRowCount();
        this.addBtn.setEnabled(rows < 2);
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.authServersTable.myDeleteAction;
    }

    @Override
    protected void addButtonPressed() {
        new NewRadiusServerDialog((JDialog)this, this.clusterNode).show();
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }
}

