/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.srv.radius;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.srv.radius.RadiusServerManager;
import com.sanrad.nms.client.data.srv.radius.RadiusServerValidator;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.srv.NewExternalServerDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrPasswordTextField;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JDialog;

public class NewRadiusServerDialog
extends NewExternalServerDialog {
    protected SrClientLabel serverIpLbl;
    protected SrClientLabel serverPortLbl;
    protected SrClientLabel serverKeyLbl;
    protected SrClientLabel secondServerKeyLbl;
    protected SrIntegerTextField serverPortFld;
    protected SrPasswordTextField serverKeyFld;
    protected SrPasswordTextField secondServerKeyFld;
    protected SrIPTextField serverIpFld;
    private SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String ip = NewRadiusServerDialog.this.serverIpFld.getText();
            String port = NewRadiusServerDialog.this.serverPortFld.getText();
            String key = new String(NewRadiusServerDialog.this.serverKeyFld.getPassword());
            String key2 = new String(NewRadiusServerDialog.this.secondServerKeyFld.getPassword());
            RadiusServerValidator validator = new RadiusServerValidator(ip, port, key, key2);
            ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
            if (validator.isValidForCreation()) {
                return Collections.singleton(RadiusServerManager.getInstance().addNewRadiusServer(clusterNode, ip, port, key));
            }
            return Collections.singleton(new FailedFuture(new IllegalValueException(validator.getErrorMessage()), "NewRadiusServerDialog.OKAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public NewRadiusServerDialog(JDialog owner, ClusterNode clusterNode) {
        super(owner, clusterNode, "New RADIUS Server");
        this.setOKAction(this.myOKAction);
    }

    @Override
    protected void fixSizes() {
        Dimension dim = this.serverIpLbl.getPreferredSize();
        this.secondServerKeyLbl.setPreferredSize(dim);
        this.serverPortLbl.setPreferredSize(dim);
        this.serverKeyLbl.setPreferredSize(dim);
        dim = this.serverIpFld.getPreferredSize();
        this.serverPortFld.setPreferredSize(dim);
        this.serverKeyFld.setPreferredSize(dim);
        this.secondServerKeyFld.setPreferredSize(dim);
    }

    @Override
    protected void initComponents() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(4, 1));
        SrPanel ipPanel = this.createIpPanel();
        SrPanel portPanel = this.createPortPanel();
        SrPanel keyPanel = this.createKeyPanel();
        SrPanel secondKeyPanel = this.createSecondKeyPanel();
        mainPanel.add(ipPanel);
        mainPanel.add(portPanel);
        mainPanel.add(keyPanel);
        mainPanel.add(secondKeyPanel);
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
        this.setSizeAndMoveToCenter(400, 250);
    }

    private SrPanel createSecondKeyPanel() {
        this.secondServerKeyLbl = new SrClientLabel("Reenter the Key: ");
        this.secondServerKeyFld = new SrPasswordTextField(15);
        SrPanel keyPanel = this.createSrPanel(this.secondServerKeyLbl, this.secondServerKeyFld);
        return keyPanel;
    }

    private SrPanel createIpPanel() {
        this.serverIpLbl = new SrClientLabel("RADIUS Server IP:");
        this.serverIpFld = new SrIPTextField();
        return this.createSrPanel(this.serverIpLbl, this.serverIpFld);
    }

    private SrPanel createPortPanel() {
        this.serverPortLbl = new SrClientLabel("Port:");
        this.serverPortFld = new SrIntegerTextField();
        this.serverPortFld.setText("1812");
        return this.createSrPanel(this.serverPortLbl, this.serverPortFld);
    }

    private SrPanel createKeyPanel() {
        this.serverKeyLbl = new SrClientLabel("Key:");
        this.serverKeyFld = new SrPasswordTextField(15);
        this.serverKeyFld.setMaxLength(RadiusServerValidator.MAX_KEY_LENGTH);
        SrClientLabel limitLbl = new SrClientLabel("[" + RadiusServerValidator.MIN_KEY_LENGTH + " - " + RadiusServerValidator.MAX_KEY_LENGTH + " characters]");
        SrPanel panel = this.createSrPanel(this.serverKeyLbl, this.serverKeyFld);
        panel.add(limitLbl);
        return panel;
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }
}

