/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.srv.isns;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.srv.isns.ISNSServerManager;
import com.sanrad.nms.client.data.srv.isns.ISNSServerValidator;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.srv.NewExternalServerDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JDialog;

public class NewISNSServerDialog
extends NewExternalServerDialog {
    private SrClientLabel serverIpLbl;
    private SrIPTextField serverIpFld;
    private SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String ip = NewISNSServerDialog.this.serverIpFld.getText();
            ISNSServerValidator validator = new ISNSServerValidator(ip);
            if (validator.isValidForCreation()) {
                return Collections.singleton(ISNSServerManager.getInstance().addNewISNSServer(NewISNSServerDialog.this.clusterNode, ip));
            }
            return Collections.singleton(new FailedFuture(new IllegalValueException(validator.getErrorMessage()), "NewISNSServerDialog.OKAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public NewISNSServerDialog(JDialog owner, ClusterNode clusterNode) {
        super(owner, clusterNode, "New iSNS Server");
        this.setOKAction(this.myOKAction);
    }

    @Override
    protected void fixSizes() {
    }

    @Override
    protected void initComponents() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(1, 1));
        SrPanel ipPanel = this.createIpPanel();
        mainPanel.add(ipPanel);
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
        this.setSizeAndMoveToCenter(300, 200);
    }

    private SrPanel createIpPanel() {
        this.serverIpLbl = new SrClientLabel("iSNS Server IP:");
        this.serverIpFld = new SrIPTextField();
        return this.createSrPanel(this.serverIpLbl, this.serverIpFld);
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }
}

