/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.srv.isns;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.srv.isns.ISNSServersTableModelCollection;
import com.sanrad.nms.client.data.srv.isns.SrISNSServersTableModel;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.srv.ExternalServersDialog;
import com.sanrad.nms.client.gui.srv.SrExternalServersTablePanel;
import com.sanrad.nms.client.gui.srv.isns.NewISNSServerDialog;
import com.sanrad.nms.client.gui.srv.isns.SrISNSServersTablePanel;
import com.sanrad.swing.actions.OperationController;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ISNSServersDialog
extends ExternalServersDialog {
    public static final int MAX_ISNS_SERVERS_IN_SYSTEM = 2;

    public ISNSServersDialog(JFrame owner, ClusterNode clusterNode) {
        super(owner, clusterNode);
        this.controlButtons();
    }

    @Override
    protected void setTitle() {
        this.setTitle("iSNS Servers");
    }

    @Override
    protected SrExternalServersTablePanel createTable() {
        SrISNSServersTableModel model = (SrISNSServersTableModel)ISNSServersTableModelCollection.getInstance().getCurrentModel();
        this.authServersTable = new SrISNSServersTablePanel(model, (OperationController)this, this.owner);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ISNSServersDialog.this.controlButtons();
            }
        });
        return this.authServersTable;
    }

    protected void controlButtons() {
        int rows = this.authServersTable.getModel().getRowCount();
        this.addBtn.setEnabled(rows < 2);
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.authServersTable.myDeleteAction;
    }

    @Override
    protected void addButtonPressed() {
        new NewISNSServerDialog((JDialog)this, this.clusterNode).show();
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }
}

