/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.srv;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.srv.ExternalServerNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.RendererPanel;
import com.sanrad.swing.LookAndFill;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ServerTableRenderer
extends DefaultTableCellRenderer {
    private RendererPanel m_rendererPanel = new RendererPanel();

    public ServerTableRenderer() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setText(value.toString());
        if (hasFocus) {
            this.setBorder(null);
        }
        if (isSelected) {
            this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
        } else {
            this.setBackground(LookAndFill.TABLE_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_FOREGROUND);
        }
        if (value instanceof ExternalServerNode) {
            this.setIcon(ClientImageObject.EXTERNAL_SERVER.getImageIcon());
            this.m_rendererPanel.restorePanel(this, (SrTreeNode)value);
            if (isSelected) {
                this.m_rendererPanel.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            } else {
                this.m_rendererPanel.setBackground(Color.white);
            }
            return this.m_rendererPanel;
        }
        return this;
    }
}

