/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.site;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableModel;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDefaultPopupMenu;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.EmptyAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.SynchronizeElementAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.dr.wizards.recover.SrRecoverWizardFrame;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.TreeView;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.wizard.SrWizardFrame;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JPopupMenu;

public class SrSitePopupMenu
extends SrDefaultPopupMenu {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private SrMainTreePanel myMainTree;
    private final AlarmAction myPropagatedAlarmsAction;
    private final AlarmAction mySpecificAlarmsAction;

    public SrSitePopupMenu(SrMainTreePanel workWith) {
        super(workWith);
        TreeView<SiteNode> siteView = new TreeView<SiteNode>(workWith.getTreeObject(), SiteNode.class);
        this.mySpecificAlarmsAction = new AlarmAction<SiteNode>((View<SiteNode>)siteView, true);
        this.myPropagatedAlarmsAction = new AlarmAction<SiteNode>((View<SiteNode>)siteView, false);
        this.myMainTree = workWith;
        Vector<Serializable> actions = new Vector<Serializable>(8);
        Vector<SrClientAction> newActions = new Vector<SrClientAction>(3);
        newActions.addElement(new EmptyAction(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_NEW_LBL), true, true, SrLicenseTreePath.GENERAL_PATH));
        TreeView<SiteNode> treeView = new TreeView<SiteNode>(workWith.getTreeObject(), SiteNode.class);
        newActions.addElement(new SrMainTreePanel.NewClusterAction(treeView, this.myMainTree.getOwner()));
        newActions.addElement(new SrMainTreePanel.NewVswitchAction(workWith, true, true));
        actions.addElement(newActions);
        actions.addElement(new JPopupMenu.Separator());
        actions.addElement(this.myMainTree.rediscoverSiteAction);
        actions.addElement(new JPopupMenu.Separator());
        Vector<SrClientAction> replicateActions = new Vector<SrClientAction>(4);
        replicateActions.addElement(new EmptyAction(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_REPLICATE), true, true, SrLicenseTreePath.GDR_PATH));
        SrClientAction<SiteNode, Void> startReplicate = new SrClientAction<SiteNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_START_REPLICATE), true, true, treeView, SrLicenseTreePath.GDR_PATH, true){
            private SrTreeNode[] myElementsForReplicate;
            {
                this.myElementsForReplicate = null;
            }

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SiteNode> arg) {
                SiteNode site = arg.iterator().next();
                this.myElementsForReplicate = SrSitePopupMenu.this.getElementsForReplicate(site);
                return SrSitePopupMenu.this.replicateStart(site, this.myElementsForReplicate);
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                SiteNode siteNode = (SiteNode)this.myView.getValue().iterator().next();
                if (SrSitePopupMenu.this.getElementsForReplicate(siteNode).length == 0) {
                    return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_NO_ELEMENT_FOR_REPLICATE_TOOLTIP, siteNode.getAlias());
                }
                return null;
            }
        };
        startReplicate.addControllerAsListener(StatusPanel.getInstance());
        replicateActions.addElement(startReplicate);
        SrClientAction<SiteNode, Void> replicateAbortAct = new SrClientAction<SiteNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_ABORT_REPLICATE), true, true, treeView, SrLicenseTreePath.GDR_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SiteNode> arg) {
                Set<SrFuture<Void>> retVal = Collections.singleton(SiteManager.getInstance().abortReplication(arg.iterator().next()));
                ClientLoader.getMainFrame().selectTreeNode(SrMainTreeModel.getInstance().getDRRootNode());
                return retVal;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                SiteNode siteNode = (SiteNode)this.myView.getValue().iterator().next();
                if (SrSitePopupMenu.this.getPrimaryPairs(siteNode).length + SrSitePopupMenu.this.getPrimaryCGs(siteNode).size() + SrSitePopupMenu.this.getSecondaryPairs(siteNode).length + SrSitePopupMenu.this.getSecondaryCGs(siteNode).length == 0) {
                    return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_NO_ELEMENT_FOR_ABORT_REPLICATE_TOOLTIP, siteNode.getAlias());
                }
                return null;
            }
        };
        replicateAbortAct.setConfirmationTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_ABORT_REPLICATE_CONFIRM_TITLE));
        replicateAbortAct.setConfirmationString(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_ABORT_REPLICATE_CONFIRM_MSG));
        replicateActions.addElement(replicateAbortAct);
        actions.addElement(replicateActions);
        actions.addElement(new SrClientAction<SiteNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_PANNED_FAILOVER_LBL), true, true, treeView, SrLicenseTreePath.GDR_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SiteNode> arg) {
                SiteManager.getInstance().plannedFailover(SrSitePopupMenu.this.getElementsForPlannedFailover(arg.iterator().next()), SrSitePopupMenu.this.myMainTree.getOwner());
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                SiteNode siteNode = (SiteNode)this.myView.getValue().iterator().next();
                if (SrSitePopupMenu.this.getElementsForPlannedFailover(siteNode).length == 0) {
                    return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_NO_ELEMENT_FOR_FAILOVER_TOOLTIP, siteNode.getAlias());
                }
                return null;
            }
        });
        actions.addElement(new SrClientAction<SiteNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_FALLBACK_LBL), true, true, treeView, SrLicenseTreePath.GDR_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SiteNode> arg) {
                SiteManager.getInstance().fallback(SrSitePopupMenu.this.getElementsForFallback((SiteNode)this.myView.getValue().iterator().next()), SrSitePopupMenu.this.myMainTree.getOwner());
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                SiteNode siteNode = (SiteNode)this.myView.getValue().iterator().next();
                if (SrSitePopupMenu.this.getElementsForFallback(siteNode).length == 0) {
                    return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_NO_ELEMENT_FOR_FALLBACK_TOOLTIP, siteNode.getAlias());
                }
                return null;
            }
        });
        actions.addElement(new SrClientAction<SiteNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_DISASTER_OCCURRED_LBL), true, true, treeView, SrLicenseTreePath.GDR_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SiteNode> arg) {
                SiteManager.getInstance().disasterOccurred(SrSitePopupMenu.this.getElementsForDisaster(arg.iterator().next()), SrSitePopupMenu.this.myMainTree.getOwner());
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                SiteNode siteNode = (SiteNode)this.myView.getValue().iterator().next();
                if (SrSitePopupMenu.this.getElementsForDisaster((SiteNode)this.myView.getValue().iterator().next()).length == 0) {
                    return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_NO_ELEMENT_FOR_DISASTER_TOOLTIP, siteNode.getAlias());
                }
                return null;
            }
        });
        actions.addElement(new SrClientAction<SiteNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_RECOVER_LBL), true, true, treeView, SrLicenseTreePath.GDR_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SiteNode> arg) {
                if (SrWizardFrame.isAlreadyRunningWizard(SrRecoverWizardFrame.class)) {
                    SrWizardFrame.bringToFront(SrRecoverWizardFrame.class);
                    return Collections.EMPTY_LIST;
                }
                SiteNode selectedSite = arg.iterator().next();
                SrRecoverWizardFrame frm = new SrRecoverWizardFrame(SrSitePopupMenu.this.myMainTree.getOwner(), SrSitePopupMenu.this.getElementsForRecover(selectedSite), selectedSite);
                frm.runWizard();
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                if (SrSitePopupMenu.this.getElementsForRecover((SiteNode)this.myView.getValue().iterator().next()).length == 0) {
                    return "No pairs to recover";
                }
                return null;
            }
        });
        actions.add(new JPopupMenu.Separator());
        actions.add(this.getAlarmsMenu());
        actions.add(new JPopupMenu.Separator());
        actions.addElement(this.myMainTree.startEditAction);
        actions.add(this.getDeleteAction());
        this.attachActions(actions);
    }

    private DRPairNode[] getElementsForRecover(SiteNode node) {
        ArrayList<DRPairNode> listForRecover = new ArrayList<DRPairNode>();
        for (DRPairNode secondaryPair : this.getSecondaryPairs(node)) {
            if (!DRModeConstant.SWITCHED.equals(secondaryPair.getMode()) || !secondaryPair.isPartial()) continue;
            listForRecover.add(secondaryPair);
        }
        return listForRecover.toArray(new DRPairNode[listForRecover.size()]);
    }

    @Override
    protected List validateActions(MouseEvent e) {
        SiteNode selectedSite = (SiteNode)this.myMainTree.getSelectedNode();
        if (!(selectedSite instanceof SystemRootNode)) {
            return super.validateActions(e);
        }
        return null;
    }

    private SrTreeNode[] getElementsForReplicate(SiteNode aSite) {
        return DRManager.getInstance().getElementsForReplicate(aSite);
    }

    private SrTreeNode[] getElementsForPlannedFailover(SiteNode node) {
        ArrayList<SrTreeNode> listForPlannedFailover = new ArrayList<SrTreeNode>();
        for (DRPairNode primaryPair : this.getPrimaryPairs(node)) {
            if (!(primaryPair instanceof DRSyncPairNode) || primaryPair.isPartial() || !DRModeConstant.NORMAL.equals(primaryPair.getMode()) || primaryPair.isInCopy() || primaryPair.getReplicationState().contains(DRReplicationStateConstant.PLANNED_FAILOVER) || DRInitialSyncStateConstant.IN_PROGRESS.equals(primaryPair.getInitialSyncState()) || CFStateConstant.CF_WAIT.equals(primaryPair.getControlFunctionState())) continue;
            listForPlannedFailover.add(primaryPair);
        }
        for (ExtendedElementNode primaryCG : this.getPrimaryCGs(node)) {
            boolean isInProgress = false;
            DRASyncPairNode[] pairs = primaryCG.getPairs();
            int j = pairs.length;
            while (j-- > 0) {
                if (!DRInitialSyncStateConstant.IN_PROGRESS.equals(pairs[j].getInitialSyncState())) continue;
                isInProgress = true;
                break;
            }
            if (primaryCG.isPartial() || !DRModeConstant.NORMAL.equals(primaryCG.getMode()) || primaryCG.getReplicationState().contains(DRReplicationStateConstant.PLANNED_FAILOVER) || isInProgress || CFStateConstant.CF_WAIT.equals(primaryCG.getControlFunctionState())) continue;
            listForPlannedFailover.add(primaryCG);
        }
        return listForPlannedFailover.toArray(new SrTreeNode[listForPlannedFailover.size()]);
    }

    private SrTreeNode[] getElementsForFallback(SiteNode node) {
        ArrayList<SrTreeNode> listForFallback = new ArrayList<SrTreeNode>();
        for (DRPairNode dRPairNode : this.getSecondaryPairs(node)) {
            if (dRPairNode instanceof DRASyncPairNode || dRPairNode.isPartial() || !DRModeConstant.SWITCHED.equals(dRPairNode.getMode()) || dRPairNode.getReplicationState().contains(DRReplicationStateConstant.FALLBACK) || dRPairNode.isInCopy() || DRInitialSyncStateConstant.IN_PROGRESS.equals(dRPairNode.getInitialSyncState()) || CFStateConstant.CF_WAIT.equals(dRPairNode.getControlFunctionState())) continue;
            listForFallback.add(dRPairNode);
        }
        for (SrTreeNode srTreeNode : this.getSecondaryCGs(node)) {
            boolean isInProgress = false;
            DRASyncPairNode[] pairs = ((ExtendedElementNode)srTreeNode).getPairs();
            int j = pairs.length;
            while (j-- > 0) {
                if (!DRInitialSyncStateConstant.IN_PROGRESS.equals(pairs[j].getInitialSyncState())) continue;
                isInProgress = true;
                break;
            }
            if (((ExtendedElementNode)srTreeNode).isPartial() || !DRModeConstant.SWITCHED.equals(((ExtendedElementNode)srTreeNode).getMode()) || ((ExtendedElementNode)srTreeNode).getReplicationState().contains(DRReplicationStateConstant.FALLBACK) || isInProgress || CFStateConstant.CF_WAIT.equals(((ExtendedElementNode)srTreeNode).getControlFunctionState())) continue;
            listForFallback.add(srTreeNode);
        }
        return listForFallback.toArray(new SrTreeNode[listForFallback.size()]);
    }

    private SrTreeNode[] getElementsForDisaster(SiteNode node) {
        ClusterNode localClusterNode;
        ArrayList<SrTreeNode> listForDisaster = new ArrayList<SrTreeNode>();
        for (DRPairNode dRPairNode : this.getSecondaryPairs(node)) {
            if (!(dRPairNode instanceof DRSyncPairNode) || (localClusterNode = dRPairNode.getLocalCluster()) != null && localClusterNode.getConnectedVSwitches().length != 0) continue;
            listForDisaster.add(dRPairNode);
        }
        for (SrTreeNode srTreeNode : this.getSecondaryCGs(node)) {
            localClusterNode = ((ExtendedElementNode)srTreeNode).getLocalCluster();
            if (localClusterNode != null && localClusterNode.getConnectedVSwitches().length != 0) continue;
            listForDisaster.add(srTreeNode);
        }
        return listForDisaster.toArray(new SrTreeNode[listForDisaster.size()]);
    }

    private List<ExtendedElementNode> getPrimaryCGs(SiteNode selectedSite) {
        return SrConsistencyGroupsTableModel.getInstance().getAllGroupsPrimaryOnSite(selectedSite);
    }

    private DRPairNode[] getPrimaryPairs(SiteNode selectedSite) {
        return SrPairDetailsTableModel.getInstance().getPairsPrimaryOnSite(selectedSite);
    }

    private ExtendedElementNode[] getSecondaryCGs(SiteNode selectedSite) {
        return SrConsistencyGroupsTableModel.getInstance().getNodesSecondaryOnSite(selectedSite);
    }

    private DRPairNode[] getSecondaryPairs(SiteNode selectedSite) {
        return SrPairDetailsTableModel.getInstance().getPairsSecondaryOnSite(selectedSite);
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.myMainTree.myRemoveSiteAction;
    }

    private Collection<SrFuture<Void>> replicateStart(SiteNode site, SrTreeNode[] elementsForStartReplicate) {
        ArrayList<ExtendedElementNode> cgsList = new ArrayList<ExtendedElementNode>();
        ArrayList<DRPairNode> syncList = new ArrayList<DRPairNode>();
        int i = elementsForStartReplicate.length;
        while (i-- > 0) {
            if (elementsForStartReplicate[i] instanceof ExtendedElementNode) {
                cgsList.add((ExtendedElementNode)elementsForStartReplicate[i]);
                continue;
            }
            if (elementsForStartReplicate[i] instanceof DRPairNode) {
                syncList.add((DRPairNode)elementsForStartReplicate[i]);
                continue;
            }
            theLogger.logAndAssert(SrLogCategories.ERROR, "SrSitePopupMenu.replicateStart() received unsupported class " + elementsForStartReplicate[i].getClass());
        }
        Collection<SrFuture<Void>> retVal = DRManager.getInstance().startReplicate(cgsList.toArray(new ExtendedElementNode[cgsList.size()]), syncList.toArray(new DRSyncPairNode[syncList.size()]));
        return retVal;
    }

    @Override
    public AlarmAction getPropagatedAlarmsAction() {
        return this.myPropagatedAlarmsAction;
    }

    @Override
    public AlarmAction getSpecificAlarmsAction() {
        return this.mySpecificAlarmsAction;
    }

    @Override
    public SynchronizeElementAction getSynchronizeAction() {
        return null;
    }

    @Override
    protected void innerReset() {
    }
}

