/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.site;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class NewSiteDialog
extends SrOKCancelDialog<SystemRootNode> {
    private SiteNode parent;
    private JTextField aliasFld;
    private SrPanel mainPanel = new SrPanel();
    private SrLabelField aliasLbl;

    public NewSiteDialog(JFrame owner, SiteNode parent) {
        super(owner, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_NEW_SITE_DLG_TITLE), true, SystemRootNode.getInstance().getClusterNodeOfSource(parent));
        this.parent = parent;
        this.initialize();
        this.pack();
        this.setSizeAndMoveToCenter(this.getWidth() + 50, this.getHeight());
        this.setOKAction();
        this.show();
    }

    private void initialize() {
        this.mainPanel.setLayout(new GridLayout(2, 1));
        this.setComponentBgColor(this.mainPanel);
        SrPanel aliasPanel = new SrPanel();
        this.setComponentBgColor(aliasPanel);
        aliasPanel.setLayout(new FlowLayout(0));
        this.aliasFld = new JTextField(10);
        this.aliasFld.setFont(LookAndFill.GENERAL_FONT);
        this.aliasLbl = new SrLabelField(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_NEW_SITE_DLG_ALIAS_LABEL));
        this.aliasLbl.setFont(LookAndFill.GENERAL_FONT);
        aliasPanel.add(this.aliasLbl);
        aliasPanel.add(this.aliasFld);
        this.mainPanel.add(aliasPanel);
        this.setComponentBgColor(this.buttonsPanel);
        this.addCenterPanel(this.mainPanel);
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    protected void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                String alias = NewSiteDialog.this.aliasFld.getText();
                StatusPanel.getInstance().setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_NEW_SITE_DLG_SUCCESS_MSG) + alias + " ...", this);
                return Collections.singleton(SiteManager.getInstance().addSite(alias, NewSiteDialog.this.parent));
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String alias = NewSiteDialog.this.aliasFld.getText();
                if (alias == null || alias.trim().equals("")) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_NEW_SITE_DLG_FAIL_MANDATORY);
                }
                if (SiteManager.getInstance().getSiteByName(alias) != null) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_NEW_SITE_DLG_FAIL_UNIQUE);
                }
                return null;
            }
        };
        this.aliasFld.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.setOKAction(myOKAction);
    }

    @Override
    public void removeListeners() {
    }
}

