/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.login;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.login.UsersManager;
import com.sanrad.nms.client.data.login.dialogs.SrUsersTableModel;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.login.AddUserDialog;
import com.sanrad.nms.client.gui.login.SrUsersTablePanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class UsersDialog
extends OKCancelDialog {
    private SrUsersTablePanel usersTable;
    private JButton addBtn;
    private JButton deleteBtn;
    private static SrLogger theLogger = SrLogger.getLogger();

    public UsersDialog(JFrame owner) {
        super(owner, "Users");
        this.initComponents();
        this.setSizeAndMoveToCenter(300, 300);
        CloseAction myOKAction = new CloseAction();
        this.setOKAction(myOKAction);
        this.show();
    }

    private void initComponents() {
        SrUsersTableModel usersModel = new SrUsersTableModel();
        this.usersTable = new SrUsersTablePanel(usersModel);
        SrPanel listPanel = this.createTablePanel();
        this.addBtn = new JButton("Add");
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersDialog.this.openAddUserDialog();
            }
        });
        this.deleteBtn = new JButton("Delete");
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersDialog.this.deleteSelectedUsers();
            }
        });
        SrPanel btnPanel = this.createButtonsPanel();
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)listPanel, "Center");
        mainPanel.add((Component)btnPanel, "South");
        mainPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.addCenterPanel(mainPanel);
        this.buttonsPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.btnCancel.setVisible(false);
    }

    private void deleteSelectedUsers() {
        int conf;
        Vector selectedValues = this.usersTable.getselectedValues();
        if (!selectedValues.isEmpty() && (conf = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the selected users?", "Confirm", 0, 3)) == 0) {
            SrAction.blockActions(Collections.singleton(UsersManager.getInstance().removeUsers(selectedValues)), this);
        }
    }

    private void openAddUserDialog() {
        new AddUserDialog(this);
    }

    private SrPanel createTablePanel() {
        SrPanel tablePanel = new SrPanel();
        tablePanel.setBackground(LookAndFill.DIALOG_COLOR);
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)this.usersTable, "Center");
        tablePanel.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.usersTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                UsersDialog.this.enableDeleteButton();
            }
        });
        this.usersTable.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                UsersDialog.this.enableDeleteButton();
            }
        });
        return tablePanel;
    }

    private void enableDeleteButton() {
        int selectedRows = this.usersTable.getTable().getSelectedRowCount();
        int rows = this.usersTable.getTable().getRowCount();
        this.deleteBtn.setEnabled(selectedRows > 0 && rows > 1);
    }

    private SrPanel createButtonsPanel() {
        SrPanel panel = new SrPanel();
        panel.setBackground(LookAndFill.DIALOG_COLOR);
        panel.setLayout(new FlowLayout(0));
        panel.add(this.addBtn);
        panel.add(this.deleteBtn);
        return panel;
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
        this.usersTable.getModel().removeListeners();
    }

    private class CloseAction
    extends SrClientAction<Void, Void> {
        public CloseAction() {
            super(SrLicenseTreePath.GENERAL_PATH);
            this.setName("Close");
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }
}

