/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.login;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.Client;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.login.LoginValidator;
import com.sanrad.nms.client.data.login.UsersManager;
import com.sanrad.nms.client.event.login.UserEvent;
import com.sanrad.nms.client.event.login.UserListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientCheckBox;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrButton;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrPasswordTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;

public class LoginDialog
extends OKCancelDialog
implements UserListener {
    private static final String SHOW_OPTIONS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_LOGIN_DIALOG_SHOW_OPTIONS);
    private static final String HIDE_OPTIONS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_LOGIN_DIALOG_HIDE_OPTIONS);
    private SrClientLabel userNameLbl;
    private SrClientLabel passwordLbl;
    private SrTextField userFld;
    private SrPasswordTextField passwordFld;
    private boolean success = false;
    private ClientLoader loader;
    private static SrLogger theLogger = SrLogger.getLogger();
    private SrClientLabel serverHostLbl;
    private SrClientLabel serverPortLbl;
    private SrTextField serverHostFld;
    private SrIntegerTextField serverPortFld;
    private SrClientCheckBox m_saveDefaults;
    private boolean isUserManagerRegistered = false;
    private SrButton myOptionsButton = new SrButton(SHOW_OPTIONS);
    private SrPanel myOptionsPanel = new SrPanel(new GridBagLayout());
    private boolean myIsOptionsShown = false;
    private SrPanel myMainPanel = new SrPanel(new GridBagLayout());
    private GridBagConstraints myMainConstraints = new GridBagConstraints();

    public LoginDialog(JFrame owner, ClientLoader loader) {
        super(owner, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_LOGIN_DIALOG_TITLE));
        this.setModal(true);
        this.loader = loader;
        this.initComponents(loader.isApplet());
        this.fixSizes();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoginDialog.this.doOnCancel();
            }
        });
        MyOKAction myOKAction = new MyOKAction();
        View.ViewTextListener listener = new View.ViewTextListener(myOKAction);
        this.userFld.getDocument().addDocumentListener(listener);
        this.passwordFld.getDocument().addDocumentListener(listener);
        if (this.serverHostFld != null) {
            this.serverHostFld.getDocument().addDocumentListener(listener);
            this.serverPortFld.getDocument().addDocumentListener(listener);
        }
        this.setOKAction(myOKAction);
        this.setVisible(true);
    }

    @Override
    public void removeListeners() {
        if (this.isUserManagerRegistered) {
            UsersManager.getInstance().removeUserListener(this);
        }
    }

    private void initComponents(boolean isApplet) {
        this.userNameLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_LOGIN_DIALOG_USER_NAME));
        this.userFld = new SrTextField(15);
        SrPanel userPanel = this.createPanel(this.userNameLbl, this.userFld);
        this.passwordLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_LOGIN_DIALOG_PASSWORD));
        this.passwordFld = new SrPasswordTextField(15);
        SrPanel passwordPanel = this.createPanel(this.passwordLbl, this.passwordFld);
        this.myMainConstraints.anchor = 17;
        this.myMainConstraints.fill = 1;
        this.myMainConstraints.weightx = 1.0;
        this.myMainConstraints.weighty = 1.0;
        this.myMainConstraints.gridy = 0;
        this.myMainConstraints.gridx = 0;
        this.myMainConstraints.insets = new Insets(10, 10, 0, 10);
        this.addCenterPanel(this.myMainPanel);
        SrPanel loginPassPanel = new SrPanel(new GridLayout(2, 1));
        loginPassPanel.add(userPanel);
        loginPassPanel.add(passwordPanel);
        loginPassPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        if (isApplet) {
            this.myMainConstraints.weighty = 0.0;
        }
        this.myMainPanel.add((Component)loginPassPanel, this.myMainConstraints);
        ++this.myMainConstraints.gridy;
        this.myMainConstraints.insets.bottom = 10;
        if (!isApplet) {
            this.setHostFields(this.myMainPanel, this.myMainConstraints);
        }
    }

    private void saveHostFields(String serverHost, String serverPort) {
        if (!this.loader.isApplet()) {
            Client.setHost(serverHost, serverPort);
        }
    }

    private void setHostFields(SrPanel mainPanel, GridBagConstraints mainConstraints) {
        this.serverHostLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_LOGIN_DIALOG_SERVER_HOST));
        this.serverHostFld = new SrTextField(15);
        this.serverHostFld.setText(Client.getHost());
        SrPanel serverHostPanel = this.createPanel(this.serverHostLbl, this.serverHostFld);
        this.serverPortLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_LOGIN_DIALOG_SERVER_PORT));
        this.serverPortFld = new SrIntegerTextField(15);
        this.serverPortFld.setMaxValue(65535);
        this.serverPortFld.setText(Integer.toString(Client.getRMIRgistryPort()));
        SrPanel serverPortPanel = this.createPanel(this.serverPortLbl, this.serverPortFld);
        this.myOptionsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_saveDefaults = new SrClientCheckBox(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_LOGIN_DIALOG_SAVE_DEFAULT_CHECKBOX));
        this.m_saveDefaults.setSelected(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.myOptionsPanel.add((Component)serverHostPanel, constraints);
        ++constraints.gridy;
        this.myOptionsPanel.add((Component)serverPortPanel, constraints);
        ++constraints.gridy;
        this.myOptionsPanel.add((Component)this.m_saveDefaults, constraints);
        this.myOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LoginDialog.this.myIsOptionsShown) {
                    LoginDialog.this.hideOptionsPanel();
                } else {
                    LoginDialog.this.showOptionsPanel();
                }
            }
        });
        this.buttonsPanel.add(this.myOptionsButton);
    }

    private void showOptionsPanel() {
        Point currentLocation = this.getLocation();
        this.myIsOptionsShown = true;
        this.myMainPanel.add((Component)this.myOptionsPanel, this.myMainConstraints);
        this.myOptionsButton.setText(HIDE_OPTIONS);
        this.pack();
        this.setLocation(currentLocation);
    }

    private void hideOptionsPanel() {
        Point currentLocation = this.getLocation();
        this.myIsOptionsShown = false;
        this.myMainPanel.remove(this.myOptionsPanel);
        this.myOptionsButton.setText(SHOW_OPTIONS);
        this.pack();
        this.setLocation(currentLocation);
    }

    private void fixSizes() {
        Dimension dim1 = null;
        Dimension dim2 = null;
        if (this.serverHostLbl != null) {
            dim1 = this.serverHostLbl.getPreferredSize();
            dim2 = this.serverHostFld.getPreferredSize();
            this.serverPortLbl.setPreferredSize(dim1);
            this.userNameLbl.setPreferredSize(dim1);
            this.serverPortFld.setPreferredSize(dim2);
            this.userFld.setPreferredSize(dim2);
        } else {
            dim1 = this.userNameLbl.getPreferredSize();
            dim2 = this.userFld.getPreferredSize();
        }
        this.passwordLbl.setPreferredSize(dim1);
        this.passwordFld.setPreferredSize(dim2);
    }

    @Override
    public void doOnCancel() {
        this.dispose();
        this.loader.terminate();
    }

    @Override
    public void loginSucceed(UserEvent e) {
        this.success = true;
    }

    @Override
    public void userCreated(UserEvent e) {
    }

    @Override
    public void userRemoved(UserEvent e) {
    }

    @Override
    public void userPasswordChanged(UserEvent e) {
    }

    public boolean isLoginSuccessful() {
        return this.success;
    }

    @Override
    public void success(SrAction action) {
        if (action instanceof MyOKAction) {
            this.success = true;
        }
        super.success(action);
    }

    @Override
    public void fail(String msg) {
        this.success = false;
        super.fail(msg);
        this.passwordFld.setText("");
        this.passwordFld.grabFocus();
    }

    @Override
    public void inProcess(String message) {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private String getPassword() {
        return new String(this.passwordFld.getPassword());
    }

    private String getUsername() {
        return this.userFld.getText();
    }

    private String getServerHost() {
        return this.serverHostFld != null ? this.serverHostFld.getText() : ClientLoader.getHostname();
    }

    private String getServerPort() {
        return this.serverPortFld != null ? this.serverPortFld.getText() : Integer.toString(ClientLoader.getHostPort());
    }

    @Override
    protected boolean isStatusBarInUse() {
        return true;
    }

    private class MyOKAction
    extends SrClientAction<Void, Void> {
        public MyOKAction() {
            super(false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String host = LoginDialog.this.getServerHost();
            String port = LoginDialog.this.getServerPort();
            if (LoginDialog.this.m_saveDefaults != null && LoginDialog.this.m_saveDefaults.isSelected()) {
                LoginDialog.this.saveHostFields(host, port);
            }
            String username = LoginDialog.this.getUsername();
            String password = LoginDialog.this.getPassword();
            UsersManager usersManager = UsersManager.getInstance();
            usersManager.addUserListener(LoginDialog.this);
            LoginDialog.this.isUserManagerRegistered = true;
            return Collections.singleton(ClientAOImpl.init(username, password, host, Integer.parseInt(port)));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            String password;
            String username = LoginDialog.this.getUsername();
            LoginValidator validator = new LoginValidator(username, password = LoginDialog.this.getPassword());
            if (!validator.isValidForCreation()) {
                return validator.getErrorMessage();
            }
            if (!LoginDialog.this.loader.isApplet() && LoginDialog.this.getServerHost().equals("")) {
                return "The server host is missing";
            }
            if (!LoginDialog.this.loader.isApplet()) {
                String portStr = LoginDialog.this.getServerPort();
                if (portStr.equals("")) {
                    return "The server port is missing";
                }
                int port = Integer.parseInt(portStr);
                int min = 1024;
                int max = 65535;
                if (port < 1024 || port > 65535) {
                    return "The server port is not in range [1024-65535]";
                }
            }
            return null;
        }
    }
}

