/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.login;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.login.LoginValidator;
import com.sanrad.nms.client.data.login.UsersManager;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrPasswordTextField;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;

public class ChangePasswordDialog
extends OKCancelDialog {
    private SrClientLabel oldPassLbl;
    private SrPasswordTextField oldPassFld;
    private SrClientLabel newPassLbl;
    private SrPasswordTextField newPassFld;
    private SrClientLabel reNewPassLbl;
    private SrPasswordTextField reNewPassFld;
    private static SrLogger theLogger = SrLogger.getLogger();

    public ChangePasswordDialog(JFrame owner) {
        super(owner, "Change Password");
        this.initComponents();
        this.setSizeAndMoveToCenter(320, 300);
        this.fixSizes();
        SrClientAction<Void, Void> okAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                String oldPassword = new String(ChangePasswordDialog.this.oldPassFld.getPassword());
                String newPassword = new String(ChangePasswordDialog.this.newPassFld.getPassword());
                if (UsersManager.getInstance().getAllUsers().isEmpty()) {
                    return Collections.singleton(new FailedFuture(new IllegalValueException("You cannot change default user."), "ChangePasswordDialog.OKAction, No user"));
                }
                return Collections.singleton(UsersManager.getInstance().changePassword(oldPassword, newPassword));
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String oldPassword = new String(ChangePasswordDialog.this.oldPassFld.getPassword());
                String newPassword = new String(ChangePasswordDialog.this.newPassFld.getPassword());
                String reNewPassword = new String(ChangePasswordDialog.this.reNewPassFld.getPassword());
                if (oldPassword.equals("")) {
                    return "Please enter your old password.";
                }
                if (!ChangePasswordDialog.this.validatePasswordLength(newPassword.length())) {
                    return "The new Password length is invalid, must be [" + LoginValidator.MIN_PASSWORD_LENGTH + " - " + LoginValidator.MAX_PASSWORD_LENGTH + "] characters long.";
                }
                if (!newPassword.equalsIgnoreCase(reNewPassword)) {
                    return "The new passwords don't match. Please reenter your new Password again.";
                }
                return null;
            }
        };
        this.oldPassFld.getDocument().addDocumentListener(new View.ViewTextListener(okAction));
        this.newPassFld.getDocument().addDocumentListener(new View.ViewTextListener(okAction));
        this.reNewPassFld.getDocument().addDocumentListener(new View.ViewTextListener(okAction));
        this.setOKAction(okAction);
        this.show();
    }

    private void initComponents() {
        this.oldPassLbl = new SrClientLabel("Old Password: ");
        this.oldPassFld = new SrPasswordTextField(15);
        SrPanel oldPassPanel = this.createPanel(this.oldPassLbl, this.oldPassFld);
        oldPassPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.newPassLbl = new SrClientLabel("New Password: ");
        this.newPassFld = new SrPasswordTextField(15);
        SrPanel newPassPanel = this.createPanel(this.newPassLbl, this.newPassFld);
        newPassPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.reNewPassLbl = new SrClientLabel("Reenter New Password: ");
        this.reNewPassFld = new SrPasswordTextField(15);
        SrPanel reNewPassPanel = this.createPanel(this.reNewPassLbl, this.reNewPassFld);
        reNewPassPanel.setBackground(LookAndFill.DIALOG_COLOR);
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(4, 1));
        SrPanel p = new SrPanel();
        p.setBackground(LookAndFill.DIALOG_COLOR);
        mainPanel.add(p);
        mainPanel.add(oldPassPanel);
        mainPanel.add(newPassPanel);
        mainPanel.add(reNewPassPanel);
        mainPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.buttonsPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.addCenterPanel(mainPanel);
    }

    private void fixSizes() {
        Dimension dim = this.reNewPassLbl.getPreferredSize();
        this.oldPassLbl.setPreferredSize(dim);
        this.newPassLbl.setPreferredSize(dim);
    }

    private boolean validatePasswordLength(int len) {
        return len >= LoginValidator.MIN_PASSWORD_LENGTH && len <= LoginValidator.MAX_PASSWORD_LENGTH;
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }
}

