/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.login;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.login.LoginValidator;
import com.sanrad.nms.client.data.login.UsersManager;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrPasswordTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JDialog;

public class AddUserDialog
extends OKCancelDialog {
    private SrClientLabel userLbl;
    private SrTextField userFld;
    private SrClientLabel passLbl;
    private SrPasswordTextField passFld;
    private SrClientLabel reNewPassLbl;
    private SrPasswordTextField reNewPassFld;
    private static SrLogger theLogger = SrLogger.getLogger();

    public AddUserDialog(JDialog owner) {
        super(owner, "Add User");
        this.initComponents();
        this.setSizeAndMoveToCenter(320, 250);
        this.fixSizes();
        SrClientAction<Void, Void> okAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                String username = AddUserDialog.this.userFld.getText();
                String password = new String(AddUserDialog.this.passFld.getPassword());
                return Collections.singleton(UsersManager.getInstance().addUser(username, password));
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String rePassword;
                String username = AddUserDialog.this.userFld.getText();
                String password = new String(AddUserDialog.this.passFld.getPassword());
                if (!password.equalsIgnoreCase(rePassword = new String(AddUserDialog.this.reNewPassFld.getPassword()))) {
                    return "Passwords don't match. Please reenter your password.";
                }
                LoginValidator validator = new LoginValidator(username, password);
                if (!validator.isValidForCreation()) {
                    return validator.getErrorMessage();
                }
                return null;
            }
        };
        this.setOKAction(okAction);
        this.userFld.getDocument().addDocumentListener(new View.ViewTextListener(okAction));
        this.passFld.getDocument().addDocumentListener(new View.ViewTextListener(okAction));
        this.reNewPassFld.getDocument().addDocumentListener(new View.ViewTextListener(okAction));
        this.setVisible(true);
    }

    private void initComponents() {
        this.userLbl = new SrClientLabel("User Name: ");
        this.userFld = new SrTextField(15);
        SrPanel userPanel = this.createPanel(this.userLbl, this.userFld);
        userPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.passLbl = new SrClientLabel("Password: ");
        this.passFld = new SrPasswordTextField(15);
        SrPanel passPanel = this.createPanel(this.passLbl, this.passFld);
        passPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.reNewPassLbl = new SrClientLabel("Reenter Password: ");
        this.reNewPassFld = new SrPasswordTextField(15);
        SrPanel reNewPassPanel = this.createPanel(this.reNewPassLbl, this.reNewPassFld);
        reNewPassPanel.setBackground(LookAndFill.DIALOG_COLOR);
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(4, 1));
        SrPanel p = new SrPanel();
        p.setBackground(LookAndFill.DIALOG_COLOR);
        mainPanel.add(p);
        mainPanel.add(userPanel);
        mainPanel.add(passPanel);
        mainPanel.add(reNewPassPanel);
        mainPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.buttonsPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.addCenterPanel(mainPanel);
    }

    private void fixSizes() {
        Dimension dim = this.reNewPassLbl.getPreferredSize();
        this.userLbl.setPreferredSize(dim);
        this.passLbl.setPreferredSize(dim);
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }
}

