/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.log;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.log.LogParameterMgr;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrMultiLineLabel;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import org.apache.log4j.Level;

public class LogParameterConfigDialog
extends OKCancelDialog {
    private LogParameterMgr myManager = null;
    private static final String EXPLANATORY_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.LOG_CFG_GUI_EXP_MSG);
    private SrMultiLineLabel myExplanLabel;
    private SrPanel mySpecificPanel;
    private SrComboBox myClientSysLevelCombo;
    private SrComboBox myServerSysLevelCombo;
    private SrClientLabel myClientLabel;
    private SrClientLabel myServerLabel;
    private static final String CLIENT_LOG_PROP_NAME = "log4j.logger.com.sanrad.nms.client";
    private static final String SERVER_LOG_PROP_NAME = "log4j.logger.com.sanrad.nms.server";
    private SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String clientLevel = null;
            String serverLevel = null;
            clientLevel = SrLogger.sanradStringRepToLog4jStringRep((String)LogParameterConfigDialog.this.myClientSysLevelCombo.getValue());
            serverLevel = SrLogger.sanradStringRepToLog4jStringRep((String)LogParameterConfigDialog.this.myServerSysLevelCombo.getValue());
            return Collections.singleton(LogParameterConfigDialog.this.myManager.replaceLoggingLevels(LogParameterConfigDialog.CLIENT_LOG_PROP_NAME, clientLevel, LogParameterConfigDialog.SERVER_LOG_PROP_NAME, serverLevel));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public LogParameterConfigDialog(JFrame aOwner, LogParameterMgr aManager) {
        super(aOwner, "Log Configuration");
        if (aManager == null) {
            throw new IllegalArgumentException("The given manager should not be null.");
        }
        this.myManager = aManager;
        this.createComponents();
        this.pack();
        this.setOKAction(this.myOKAction);
    }

    @Override
    public void doOnCancel() {
    }

    private SrPanel createSpecificPanel() {
        Level convLevel;
        String curLevel;
        SrPanel specificPanel = new SrPanel();
        specificPanel.setLayout(new GridLayout(2, 2));
        List<Level> levels = SrLogger.getLogLevels();
        this.myClientLabel = new SrClientLabel("Client:");
        ArrayList<String> levelStrs = new ArrayList<String>(SrLogger.getLevelStrings(levels));
        this.myClientSysLevelCombo = new SrComboBox<Object>((T[])levelStrs.toArray());
        if (levels.size() == 0) {
            this.myClientSysLevelCombo.addItem("INVALID");
            this.myClientSysLevelCombo.setValue("INVALID");
            this.myClientSysLevelCombo.setEnabled(false);
        } else {
            curLevel = this.myManager.getClientLevel();
            convLevel = Level.toLevel(curLevel);
            if (curLevel.equals("") || !convLevel.toString().equals(curLevel)) {
                this.myClientSysLevelCombo.setValue(Level.OFF.toString());
            } else {
                this.myClientSysLevelCombo.setValue(SrLogger.log4jStringRepToSanradStringRep(curLevel));
            }
        }
        this.myServerLabel = new SrClientLabel("Server:");
        this.myServerSysLevelCombo = new SrComboBox<Object>((T[])levelStrs.toArray());
        if (levels.size() == 0) {
            this.myServerSysLevelCombo.addItem("INVALID");
            this.myServerSysLevelCombo.setValue("INVALID");
            this.myServerSysLevelCombo.setEnabled(false);
        } else {
            curLevel = this.myManager.getServerLevel();
            convLevel = Level.toLevel(curLevel);
            if (curLevel.equals("") || !convLevel.toString().equals(curLevel)) {
                this.myServerSysLevelCombo.setValue(Level.OFF.toString());
            } else {
                this.myServerSysLevelCombo.setValue(SrLogger.log4jStringRepToSanradStringRep(curLevel));
            }
        }
        specificPanel.add(this.myClientLabel);
        specificPanel.add(this.myClientSysLevelCombo);
        specificPanel.add(this.myServerLabel);
        specificPanel.add(this.myServerSysLevelCombo);
        if (levels.size() == 0) {
            this.myServerSysLevelCombo.setEnableComponent(false);
            this.myClientSysLevelCombo.setEnableComponent(false);
            this.setStatusStr("The logging levels are invalid.");
        }
        return specificPanel;
    }

    private void addToGrid(SrPanel p, Component comp, GridBagConstraints c, int x, int y) {
        int oldX = c.gridx;
        int oldY = c.gridy;
        c.gridx = x;
        c.gridy = y;
        p.add(comp, c);
        c.gridx = oldX;
        c.gridy = oldY;
    }

    private void createComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets.right = 5;
        c.insets.left = 5;
        c.insets.top = 7;
        c.insets.bottom = 7;
        c.anchor = 18;
        c.fill = 2;
        c.weightx = 0.0;
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridBagLayout());
        this.myExplanLabel = new SrMultiLineLabel(EXPLANATORY_TEXT);
        this.myExplanLabel.setSize(550, 200);
        this.addToGrid(mainPanel, this.myExplanLabel, c, 0, 1);
        this.mySpecificPanel = this.createSpecificPanel();
        this.addToGrid(mainPanel, this.mySpecificPanel, c, 0, 3);
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
        this.setBtnActions();
    }

    private void setBtnActions() {
    }

    @Override
    public void removeListeners() {
    }
}

