/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.session.statistics;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionStatisticsNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.SrISCSISessionsStatisticsTableModel;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsStatisticsRowSelectionEvent;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsStatisticsRowSelectionListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.iscsi.session.statistics.ISCSISessionsStatisticsTableHeader;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.util.SrEventListenerManager;

public abstract class SrISCSISessionsStatisticsTablePanel
extends SrTablePanel {
    protected String INITIATOR_HEADER_GROUP_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_CONNECTIONS_INITIATOR_LABEL);
    protected String TARGET_HEADER_GROUP_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_CONNECTIONS_TARGET_LABEL);
    SrEventListenerManager.Informer<ISCSISessionsStatisticsRowSelectionListener, ISCSISessionsStatisticsRowSelectionEvent> sessionStatisticsRowSelectedInformer = new SrEventListenerManager.Informer<ISCSISessionsStatisticsRowSelectionListener, ISCSISessionsStatisticsRowSelectionEvent>(){

        @Override
        public void inform(ISCSISessionsStatisticsRowSelectionListener listener, ISCSISessionsStatisticsRowSelectionEvent event) {
            listener.sessionStatisticsRowSelected(event);
        }
    };

    protected SrISCSISessionsStatisticsTablePanel(SrISCSISessionsStatisticsTableModel model) {
        super(model);
        this.initTableColumnsInvisible();
        this.initTableColumnsGroups();
        this.setColumnUnEditable(ISCSISessionsStatisticsTableHeader.INITIATOR_NAME);
    }

    public void addSessionsSelectionListener(ISCSISessionsStatisticsRowSelectionListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeSessionsSelectionListener(ISCSISessionsStatisticsRowSelectionListener listener) {
        this.m_listeners.remove(listener);
    }

    protected abstract void initTableColumnsGroups();

    protected void initTableColumnsInvisible() {
        this.hideTableColumn(ISCSISessionsStatisticsTableHeader.SESSION_STUB.getColumnName());
        this.hideTableColumn(ISCSISessionsStatisticsTableHeader.SESSION_STATISTICS_STUB.getColumnName());
        this.hideTableColumn(ISCSISessionsStatisticsTableHeader.VSWITCH_STUB.getColumnName());
    }

    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        if (rowIndices != null && rowIndices.length > 0) {
            int selectedRow = rowIndices[0];
            if (selectedRow >= 0) {
                SrISCSISessionsStatisticsTableModel model = (SrISCSISessionsStatisticsTableModel)this.getModel();
                int rowStubCol = model.getColumnIndex(ISCSISessionsStatisticsTableHeader.SESSION_STATISTICS_STUB.getColumnName());
                Object selectedSessionStub = model.getValueAt(selectedRow, rowStubCol);
                ISCSISessionStatisticsNode[] sessionStatisticsTableNodes = model.getSessionStatisticsNodes();
                for (int index1 = 0; index1 < sessionStatisticsTableNodes.length; ++index1) {
                    ISCSISessionStatisticsNode node = sessionStatisticsTableNodes[index1];
                    if (!selectedSessionStub.equals(node.getStub())) continue;
                    ISCSISessionsStatisticsRowSelectionEvent event = new ISCSISessionsStatisticsRowSelectionEvent(this, node);
                    this.m_listeners.fireEvent(ISCSISessionsStatisticsRowSelectionListener.class, event, this.sessionStatisticsRowSelectedInformer);
                    break;
                }
            }
        } else {
            ISCSISessionsStatisticsRowSelectionEvent event = new ISCSISessionsStatisticsRowSelectionEvent(this, null);
            this.m_listeners.fireEvent(ISCSISessionsStatisticsRowSelectionListener.class, event, this.sessionStatisticsRowSelectedInformer);
        }
    }
}

