/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.session.statistics;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionStatisticsNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionsStatisticsManager;
import com.sanrad.nms.client.data.iscsi.session.statistics.SrISCSISessionsStatisticsTableModel;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsStatisticsListener;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsStatisticsRowSelectionEvent;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsStatisticsRowSelectionListener;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticChart;
import com.sanrad.nms.client.gui.iscsi.session.statistics.SrISCSISessionsStatisticsTablePanel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class SrISCSISessionsStatisticsChart
extends SrStatisticChart
implements ISCSISessionsStatisticsListener,
ISCSISessionsStatisticsRowSelectionListener {
    private static final String SERIES_CMD_PDUS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_SESSIONS_CHART_CMD_PDUS);
    private static final String SERIES_RSP_PDUS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_SESSIONS_CHART_RSP_PDUS);
    private SrISCSISessionsStatisticsTablePanel m_statTable;
    private ISCSISessionStatisticsNode m_currentSession;

    public SrISCSISessionsStatisticsChart(SrISCSISessionsStatisticsTablePanel statTable, int aPollingInterval) {
        super(aPollingInterval);
        this.addSeries(SERIES_CMD_PDUS);
        this.addSeries(SERIES_RSP_PDUS);
        ISCSISessionsStatisticsManager.getInstance().addISCSISessionsStatisticsListener(this);
        this.m_statTable = statTable;
        this.m_statTable.addSessionsSelectionListener(this);
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        ISCSISessionStatisticsNode statisticsNode = (ISCSISessionStatisticsNode)e.getStatisticsNode();
        HashMap values = statisticsNode.getChangedValues();
        List<HashMap> sessionValues = null;
        if (!this.getItem2RatesMap().containsKey(statisticsNode)) {
            sessionValues = new ArrayList();
            this.getItem2RatesMap().put(statisticsNode, sessionValues);
        } else {
            sessionValues = (List)this.getItem2RatesMap().get(statisticsNode);
        }
        sessionValues.add(values);
        Date time = new Date();
        values.put("PointInTime", time);
        if (this.m_currentSession != null && ((ISCSISessionStatistics)statisticsNode.getStub()).equals(this.m_currentSession.getStub())) {
            this.updateStatisticsChart(values);
        }
    }

    private void selectFirstRowStatistics() {
        ISCSISessionStatisticsNode[] sessionsNodes = ((SrISCSISessionsStatisticsTableModel)this.m_statTable.getModel()).getSessionStatisticsNodes();
        this.sessionStatisticsRowSelected(new ISCSISessionsStatisticsRowSelectionEvent(this, sessionsNodes[0]));
    }

    @Override
    public void iscsiSessionStatisticsCreated(StatisticsEvent e) {
    }

    @Override
    public void iscsiSessionStatisticsRemoved(StatisticsEvent e) {
        ISCSISessionStatisticsNode statisticsNode = (ISCSISessionStatisticsNode)e.getStatisticsNode();
        if (this.getItem2RatesMap().containsKey(statisticsNode)) {
            this.getItem2RatesMap().remove(statisticsNode);
        }
        if (this.m_currentSession != null && ((ISCSISessionStatistics)statisticsNode.getStub()).equals(this.m_currentSession.getStub())) {
            if (this.m_statTable.getTable().getRowCount() > 0) {
                this.selectFirstRowStatistics();
            } else {
                this.getChartPanel().getChart().setTitle("");
                for (int i = 0; i < this.m_dataset.getSeriesCount(); ++i) {
                    this.m_dataset.getSeries(i).clear();
                }
            }
        }
    }

    @Override
    public void removeListeners() {
        ISCSISessionsStatisticsManager.getInstance().addISCSISessionsStatisticsListener(this);
        this.m_statTable.removeSessionsSelectionListener(this);
    }

    @Override
    public void sessionStatisticsRowSelected(ISCSISessionsStatisticsRowSelectionEvent event) {
        this.m_currentSession = event.getISCSISessionStatisticsNode();
        if (this.m_currentSession != null) {
            String chartTitle = this.createChartTitle(this.m_currentSession);
            this.getChartPanel().getChart().setTitle(chartTitle);
            List data = null;
            data = this.getItem2RatesMap().containsKey(this.m_currentSession) ? (List)this.getItem2RatesMap().get(this.m_currentSession) : new Vector(0);
            this.switchItemChartDisplay(data);
        } else {
            this.getChartPanel().getChart().setTitle("");
            this.clearData();
        }
    }

    private String createChartTitle(ISCSISessionStatisticsNode session) {
        StringBuffer sb = new StringBuffer();
        sb.append(session.getInitiatorName());
        sb.append(",");
        sb.append(session.getISID());
        sb.append(" <-> ");
        sb.append(session.getTargetName());
        sb.append(",");
        sb.append(session.getTSIH());
        return sb.toString();
    }

    @Override
    protected void updateStatisticsChart(HashMap newItem) {
        Date time = (Date)newItem.get("PointInTime");
        Long cmdPdus = (Long)newItem.get(ClientParameterCode.ISCSI_SESSION_STATISTICS_CMD_PDUS_PER_SEC);
        Long rspPdus = (Long)newItem.get(ClientParameterCode.ISCSI_SESSION_STATISTICS_RSP_PDUS_PER_SEC);
        if (cmdPdus != null) {
            this.setSeriesValue(SERIES_CMD_PDUS, time, cmdPdus);
        }
        if (rspPdus != null) {
            this.setSeriesValue(SERIES_RSP_PDUS, time, rspPdus);
        }
    }
}

