/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.session.statistics;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionsStatisticsManager;
import com.sanrad.nms.client.data.iscsi.session.statistics.SrISCSISessionsStatisticsClusterViewTableModel;
import com.sanrad.nms.client.data.iscsi.session.statistics.SrISCSISessionsStatisticsTableModel;
import com.sanrad.nms.client.data.iscsi.session.statistics.SrISCSISessionsStatisticsTargetViewTableModel;
import com.sanrad.nms.client.data.iscsi.session.statistics.SrISCSISessionsStatisticsVswitchViewTableModel;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsStatisticsListener;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticsDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.iscsi.session.statistics.SrISCSISessionsStatisticsChart;
import com.sanrad.nms.client.gui.iscsi.session.statistics.SrISCSISessionsStatisticsClusterViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.session.statistics.SrISCSISessionsStatisticsTablePanel;
import com.sanrad.nms.client.gui.iscsi.session.statistics.SrISCSISessionsStatisticsTargetViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.session.statistics.SrISCSISessionsStatisticsVswitchViewTablePanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;

public class ISCSISessionsStatisticsDialog
extends SrStatisticsDialog<ClusterNode>
implements ISCSISessionsStatisticsListener {
    public static final SrLogger theLogger = SrLogger.getLogger();
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_SESSIONS_STATISTICS_DIALOG_SPECIFIC_TITLE);

    public ISCSISessionsStatisticsDialog(JFrame owner, ClusterNode aCluster) {
        this(owner, aCluster, 1);
        String comboLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_SESSIONS_STATISTICS_DIALOG_CONTEXT_BOX_LABEL);
        this.addTopContextBox(comboLabel, SystemRootNode.getInstance(), ClusterNode.class);
        this.setTopContextBoxSelection(aCluster);
    }

    public ISCSISessionsStatisticsDialog(JFrame owner, VSwitchNode aVswitch) {
        this(owner, aVswitch, 2);
    }

    public ISCSISessionsStatisticsDialog(JFrame owner, TargetNode aTarget) {
        this(owner, aTarget, 3);
    }

    private ISCSISessionsStatisticsDialog(JFrame owner, SrTreeNode aTreeNode, int aMode) {
        super(owner, DIALOG_SPECIFIC_TITLE, null, aTreeNode, aMode);
        this.m_scrollChartPanel.setPreferredSize(new Dimension(this.m_scrollChartPanel.getPreferredSize().width, this.m_scrollChartPanel.getPreferredSize().height - 50));
        SrClientAction.blockActions(this.activateDeactivateStatisticsUpdate(true), this);
        this.pack();
    }

    @Override
    protected void systemNodeSelected(ClusterNode aSysNode) {
        SrClientAction.blockActions(this.activateDeactivateStatisticsUpdate(false), this);
        this.setCluster(aSysNode);
        SrClientAction.blockActions(this.activateDeactivateStatisticsUpdate(true), this);
    }

    @Override
    public void addListeners() {
        ISCSISessionsStatisticsManager.getInstance().addISCSISessionsStatisticsListener(this);
    }

    private void setCluster(ClusterNode aCluster) {
        if (this.myMode != 1) {
            throw new UnsupportedOperationException("Cannot set cluster" + aCluster + ", the mode is not CLUSTER_MODE, mode = " + this.myMode);
        }
        this.myTreeNode = aCluster;
        ((SrISCSISessionsStatisticsClusterViewTableModel)this.m_statisticsTablePanel.getModel()).initModel(aCluster);
    }

    @Override
    public void removeListeners() {
        super.removeListeners();
        ISCSISessionsStatisticsManager.getInstance().removeISCSISessionsStatisticsListener(this);
        if (this.m_statisticsTablePanel != null) {
            SrISCSISessionsStatisticsTableModel model = (SrISCSISessionsStatisticsTableModel)((SrISCSISessionsStatisticsTablePanel)this.m_statisticsTablePanel).getModel();
            model.removeAllRows();
            model.removeListeners();
        }
        if (this.m_statisticChart != null) {
            ((SrISCSISessionsStatisticsChart)this.m_statisticChart).removeListeners();
        }
    }

    @Override
    public void doOnCancel() {
        this.activateDeactivateStatisticsUpdate(false);
    }

    @Override
    protected void initDialogPanels() {
    }

    private Collection<SrFuture<Void>> activateDeactivateStatisticsUpdate(boolean mode) {
        if (this.myTreeNode instanceof ClusterNode) {
            return this.activateISCSISessionStatisticsInAllGroupNodes(mode);
        }
        if (this.myTreeNode instanceof VSwitchNode) {
            Set<SrFuture<Void>> retVal = Collections.singleton(StatisticsManager.activateDeactivateStatistics(((VSwitchNode)this.myTreeNode).getISCSISessionsGroupNode(), mode));
            if (!mode) {
                ISCSISessionsStatisticsManager.getInstance().clearISCSISessionStatisticNodeParamsList((VSwitchNode)this.myTreeNode);
            }
            return retVal;
        }
        if (this.myTreeNode instanceof TargetNode) {
            return this.activateISCSISessionStatisticsInTargetGroupNodes(mode);
        }
        return Collections.EMPTY_LIST;
    }

    private Collection<SrFuture<Void>> activateISCSISessionStatisticsInTargetGroupNodes(boolean mode) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches(clusterNode);
        ArrayList<SrFuture<Void>> retVal = new ArrayList<SrFuture<Void>>();
        for (int index = 0; index < clusterVswitches.size(); ++index) {
            String vswitchName;
            VSwitchNode vswitchNode = clusterVswitches.elementAt(index);
            String vswitchNameExposedOn = ((TargetNode)this.myTreeNode).getExposedOnVSwitchName();
            if (!vswitchNameExposedOn.equalsIgnoreCase(vswitchName = vswitchNode.getName())) continue;
            retVal.add(StatisticsManager.activateDeactivateStatistics(vswitchNode.getISCSISessionsGroupNode(), mode));
            if (mode) break;
            ISCSISessionsStatisticsManager.getInstance().clearISCSISessionStatisticNodeParamsList(vswitchNode);
            break;
        }
        return retVal;
    }

    private Collection<SrFuture<Void>> activateISCSISessionStatisticsInAllGroupNodes(boolean mode) {
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches((ClusterNode)this.myTreeNode);
        ArrayList<SrFuture<Void>> retVal = new ArrayList<SrFuture<Void>>();
        for (int index = 0; index < clusterVswitches.size(); ++index) {
            VSwitchNode vswitchNode = clusterVswitches.elementAt(index);
            retVal.add(StatisticsManager.activateDeactivateStatistics(vswitchNode.getISCSISessionsGroupNode(), mode));
            if (mode) continue;
            ISCSISessionsStatisticsManager.getInstance().clearISCSISessionStatisticNodeParamsList(vswitchNode);
        }
        return retVal;
    }

    private SrTablePanel createISCSISessionsStatisticsTablePanel() {
        if (this.myMode == 1) {
            return new SrISCSISessionsStatisticsClusterViewTablePanel(new SrISCSISessionsStatisticsClusterViewTableModel((ClusterNode)this.myTreeNode));
        }
        if (this.myMode == 2) {
            return new SrISCSISessionsStatisticsVswitchViewTablePanel(new SrISCSISessionsStatisticsVswitchViewTableModel((VSwitchNode)this.myTreeNode));
        }
        if (this.myMode == 3) {
            return new SrISCSISessionsStatisticsTargetViewTablePanel(new SrISCSISessionsStatisticsTargetViewTableModel((TargetNode)this.myTreeNode));
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, "Unsupported type for ISCSI session statistics dialog");
        return null;
    }

    @Override
    protected ChartPanel getStatisticsChartPanel() {
        int interval = 60;
        if (this.m_vswitchNode != null) {
            interval = this.m_vswitchNode.getStatisticsPollInterval();
        } else {
            Vector<ClusterNode> clusters = SystemRootNode.getInstance().getClusterNodes();
            if (clusters.isEmpty()) {
                throw new IllegalStateException("Statistics were requested but there are no clusters in the system");
            }
            VSwitchNode curVs = null;
            for (ClusterNode curCluster : clusters) {
                VSwitchNode[] vsArr = curCluster.getVSwitches();
                if (vsArr == null && vsArr.length <= 0) continue;
                curVs = vsArr[0];
                break;
            }
            if (curVs == null) {
                throw new IllegalStateException("Statistics were requested but there are no VSs in the system");
            }
            interval = curVs.getStatisticsPollInterval();
        }
        this.m_statisticChart = new SrISCSISessionsStatisticsChart((SrISCSISessionsStatisticsTablePanel)this.m_statisticsTablePanel, interval);
        return this.m_statisticChart.packChartToPanel();
    }

    @Override
    protected SrPanel getStatisticsDetailsPanel() {
        return null;
    }

    @Override
    protected SrTablePanel getStatisticsExtendedTablePanel() {
        return null;
    }

    @Override
    protected SrTablePanel getStatisticsTablePanel() {
        SrTablePanel table = this.createISCSISessionsStatisticsTablePanel();
        Dimension dim = table.getPreferredSize();
        table.setPreferredSize(new Dimension(750, dim.height / 2));
        return table;
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        this.setLastUpdateTime(new GregorianCalendar());
    }

    @Override
    public void iscsiSessionStatisticsCreated(StatisticsEvent e) {
    }

    @Override
    public void iscsiSessionStatisticsRemoved(StatisticsEvent e) {
    }

    @Override
    protected void setClusterTitle() {
    }
}

