/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.session.show;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.iscsi.session.show.SrISCSISessionsTableModel;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionRowSelectionEvent;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionRowSelectionListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.iscsi.session.show.ISCSISessionsTableHeader;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.util.SrEventListenerManager;
import java.util.Vector;

public abstract class SrISCSISessionsTablePanel
extends SrTablePanel {
    protected String INITIATOR_HEADER_GROUP_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_CONNECTIONS_INITIATOR_LABEL);
    protected String TARGET_HEADER_GROUP_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_CONNECTIONS_TARGET_LABEL);
    SrEventListenerManager.Informer<ISCSISessionRowSelectionListener, ISCSISessionRowSelectionEvent> iscsiSessionRowSelectedInformer = new SrEventListenerManager.Informer<ISCSISessionRowSelectionListener, ISCSISessionRowSelectionEvent>(){

        @Override
        public void inform(ISCSISessionRowSelectionListener listener, ISCSISessionRowSelectionEvent event) {
            listener.iscsiSessionRowSelected(event);
        }
    };
    SrEventListenerManager.Informer<ISCSISessionRowSelectionListener, ISCSISessionRowSelectionEvent> iscsiSessionRowEmptySelectionInformer = new SrEventListenerManager.Informer<ISCSISessionRowSelectionListener, ISCSISessionRowSelectionEvent>(){

        @Override
        public void inform(ISCSISessionRowSelectionListener listener, ISCSISessionRowSelectionEvent event) {
            if (event != null) {
                throw new IllegalArgumentException("event (" + event + ") must be null, it is disregarded!");
            }
            listener.iscsiSessionRowEmptySelection();
        }
    };

    protected SrISCSISessionsTablePanel(SrISCSISessionsTableModel model) {
        super(model);
        this.initSelectionMode();
        this.initTableColumnsInvisible();
        this.initTableColumnsGroups();
        this.setColumnUnEditable(ISCSISessionsTableHeader.INITIATOR_NAME);
    }

    protected void initSelectionMode() {
        if (this.getTable().getRowCount() > 0) {
            this.getTable().getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    public void removeListeners() {
        ((SrISCSISessionsTableModel)this.getModel()).removeListeners();
    }

    public void addISCSISessionSelectionListener(ISCSISessionRowSelectionListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeISCSISessionSelectionListener(ISCSISessionRowSelectionListener listener) {
        this.m_listeners.remove(listener);
    }

    protected void initTableColumnsInvisible() {
        this.hideTableColumn(ISCSISessionsTableHeader.SESSION_STUB.getColumnName());
        this.hideTableColumn(ISCSISessionsTableHeader.VSWITCH_STUB.getColumnName());
    }

    protected abstract void initTableColumnsGroups();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        if (rowIndices != null && rowIndices.length > 0) {
            try {
                int selectedRow = rowIndices[0];
                if (selectedRow < 0) return;
                SrISCSISessionsTableModel model = (SrISCSISessionsTableModel)this.getModel();
                Object selectedSessionStub = model.getSelectedSessionStub(selectedRow);
                Vector iscsiSessionsTableNodes = model.getISCSISessionsTableNodes();
                for (int index1 = 0; index1 < iscsiSessionsTableNodes.size(); ++index1) {
                    ISCSISessionNode sessionNode = (ISCSISessionNode)iscsiSessionsTableNodes.elementAt(index1);
                    if (!((ISCSISession)sessionNode.getStub()).equals(selectedSessionStub)) continue;
                    ISCSISessionRowSelectionEvent event = new ISCSISessionRowSelectionEvent(this, sessionNode);
                    this.m_listeners.fireEvent(ISCSISessionRowSelectionListener.class, event, this.iscsiSessionRowSelectedInformer);
                    return;
                }
                return;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                return;
            }
        } else {
            this.m_listeners.fireEvent(ISCSISessionRowSelectionListener.class, null, this.iscsiSessionRowEmptySelectionInformer);
        }
    }
}

