/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.session.show;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.connection.SrISCSISessionConnectionsModelsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.session.show.SrISCSISessionsClusterViewTableModel;
import com.sanrad.nms.client.data.iscsi.session.show.SrISCSISessionsRemoteTargetViewTableModel;
import com.sanrad.nms.client.data.iscsi.session.show.SrISCSISessionsTargetViewTableModel;
import com.sanrad.nms.client.data.iscsi.session.show.SrISCSISessionsVswitchViewTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrCloseDialog;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.iscsi.connection.SrISCSISessionConnectionsTablePanel;
import com.sanrad.nms.client.gui.iscsi.session.show.SrISCSISessionsClusterViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.session.show.SrISCSISessionsRemoteTargetViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.session.show.SrISCSISessionsTablePanel;
import com.sanrad.nms.client.gui.iscsi.session.show.SrISCSISessionsTargetViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.session.show.SrISCSISessionsVswitchViewTablePanel;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.util.SrResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Locale;
import javax.swing.JFrame;

public class ISCSISessionsShowDialog
extends SrCloseDialog {
    private int m_dialogView = 0;
    protected SrTreeNode m_treeNode = null;
    protected static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_SESSIONS_DIALOG_SPECIFIC_TITLE);
    protected SrISCSISessionsTablePanel m_sessionsTablePanel;
    private SrISCSISessionConnectionsTablePanel m_sessionConnectionsTablePanel;
    private SrISCSISessionConnectionsModelsManager m_modelManager;
    protected SrClientLabel m_connectionsTitleLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_SESSIONS_CONNECTIONS_SPECIFIC_TITLE));

    public ISCSISessionsShowDialog(JFrame owner, SrTreeNode treeNode, int dialogView) {
        super(owner, "", SystemRootNode.getInstance().getCurrentClusterNode());
        this.m_treeNode = treeNode;
        this.m_dialogView = dialogView;
        this.setDialogTitle();
        this.initDialogPanels();
        this.initConnectionTablePanelTitle();
        this.initDialogLayout();
        this.pack();
    }

    public ISCSISessionsShowDialog(JFrame owner, String siteName, String clusterAlias, SrTreeNode treeNode, int dialogView) {
        super(owner, "", SystemRootNode.getInstance().getCurrentClusterNode());
        this.m_treeNode = treeNode;
        this.m_dialogView = dialogView;
        this.setDialogTitle(siteName, clusterAlias);
        this.initDialogPanels();
        this.initConnectionTablePanelTitle();
        this.initDialogLayout();
        this.pack();
    }

    @Override
    public void removeListeners() {
        if (this.m_modelManager != null) {
            this.m_modelManager.removeListeners();
        }
    }

    @Override
    public void addListeners() {
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void dispose() {
        this.m_sessionsTablePanel.removeListeners();
        if (this.m_sessionConnectionsTablePanel != null) {
            this.m_sessionConnectionsTablePanel.removeListeners();
        }
        super.dispose();
    }

    protected void setDialogTitle() {
        String title = "";
        switch (this.m_dialogView) {
            case 0: {
                title = ClientLoader.CLUSTER_DISPLAY_STRING + " " + ((ClusterNode)this.m_treeNode).getAlias();
                break;
            }
            case 1: {
                title = ClientLoader.VSWITCH_DISPLAY_STRING + " " + ((VSwitchNode)this.m_treeNode).getName();
                break;
            }
            case 2: {
                title = "Target " + (TargetNode)this.m_treeNode;
            }
        }
        this.setTitle(title + " - " + DIALOG_SPECIFIC_TITLE);
    }

    protected void setDialogTitle(String siteName, String clusterAlias) {
        StringBuffer sbTitle = new StringBuffer();
        sbTitle.append(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DLG_TITLE_SITE) + " " + siteName + "; ");
        sbTitle.append(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DLG_TITLE_CLUSTER) + " " + clusterAlias + "; ");
        sbTitle.append(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DLG_TITLE_REMOTE_TARGET) + " " + ((SrISCSIRemoteTargetNode)this.m_treeNode).getAlias() + "; ");
        sbTitle.append(DIALOG_SPECIFIC_TITLE);
        this.setTitle(sbTitle.toString());
    }

    protected void initDialogPanels() {
        this.createISCSISessionsTablePanel();
        this.createISCSISessionConnectionsTablePanel();
        Dimension dim = this.m_sessionsTablePanel.getPreferredSize();
        this.m_sessionsTablePanel.setPreferredSize(new Dimension(dim.width + 100, 200));
        this.m_sessionConnectionsTablePanel.setPreferredSize(new Dimension(dim.width + 100, 200));
    }

    private void initConnectionTablePanelTitle() {
        Font titleFont = Font.decode(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getString(SrDefaultUIBundleKeys.PANEL_TITLE_LABEL_FONT));
        this.m_connectionsTitleLabel.setFont(titleFont);
    }

    private void createISCSISessionsTablePanel() {
        switch (this.m_dialogView) {
            case 0: {
                this.m_sessionsTablePanel = new SrISCSISessionsClusterViewTablePanel(new SrISCSISessionsClusterViewTableModel((ClusterNode)this.m_treeNode));
                break;
            }
            case 1: {
                this.m_sessionsTablePanel = new SrISCSISessionsVswitchViewTablePanel(new SrISCSISessionsVswitchViewTableModel((VSwitchNode)this.m_treeNode));
                break;
            }
            case 2: {
                this.m_sessionsTablePanel = new SrISCSISessionsTargetViewTablePanel(new SrISCSISessionsTargetViewTableModel((TargetNode)this.m_treeNode));
                break;
            }
            case 3: {
                this.m_sessionsTablePanel = new SrISCSISessionsRemoteTargetViewTablePanel(new SrISCSISessionsRemoteTargetViewTableModel((SrISCSIRemoteTargetNode)this.m_treeNode));
            }
        }
    }

    private void createISCSISessionConnectionsTablePanel() {
        this.m_modelManager = new SrISCSISessionConnectionsModelsManager(this.m_dialogView, this.m_treeNode, this.m_sessionsTablePanel);
        this.m_modelManager.createAllSessionsConnectionModels();
        this.m_sessionConnectionsTablePanel = new SrISCSISessionConnectionsTablePanel(this.m_modelManager, this.m_sessionsTablePanel);
        this.m_modelManager.setSessionConnectionsTablePanel(this.m_sessionConnectionsTablePanel);
    }

    protected void initDialogLayout() {
        SrPanel titlePanel = new SrPanel(new FlowLayout(0, 10, 10));
        titlePanel.add(this.m_connectionsTitleLabel);
        SrPanel mainPanel = new SrPanel(new BorderLayout());
        mainPanel.add((Component)this.m_sessionsTablePanel, "First");
        mainPanel.add((Component)titlePanel, "Before");
        mainPanel.add((Component)this.m_sessionConnectionsTablePanel, "Last");
        super.initDialogLayout(mainPanel);
    }
}

