/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.remotetarget;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrNewISCSIRemoteTargetPanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.JFrame;

public class SrNewISCSIRemoteTargetDialog
extends SrOKCancelDialog {
    private SrTextField myAliasTextField;
    private SrTextField myNameTextField;

    public SrNewISCSIRemoteTargetDialog(JFrame frm, String siteName, ClusterNode clusterNode) {
        super(frm, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_CREATE_DLG_SPECIFIC_TITLE), clusterNode);
        SrNewISCSIRemoteTargetPanel panel = new SrNewISCSIRemoteTargetPanel("NewISCSIRemoteTargetDialog");
        this.myAliasTextField = (SrTextField)panel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_CREATE_DLG_TARGET_ALIAS));
        this.myNameTextField = (SrTextField)panel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_CREATE_DLG_TARGET_NAME));
        this.addCenterPanel(panel);
        this.setOKAction();
        this.pack();
    }

    protected void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                String newRemoteTargetAlias = SrNewISCSIRemoteTargetDialog.this.myAliasTextField.getText().trim();
                String newRemoteTargetName = SrNewISCSIRemoteTargetDialog.this.myNameTextField.getText().trim();
                Set<SrFuture<Void>> retVal = Collections.singleton(ClientAOImpl.getInstance().createISCSIRemoteTarget(SrNewISCSIRemoteTargetDialog.this.m_workingCluster.getStorageID(), newRemoteTargetName, newRemoteTargetAlias));
                return retVal;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String alias = SrNewISCSIRemoteTargetDialog.this.myAliasTextField.getText().trim();
                if (alias.equals("")) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CREATE_REMOTE_TARGET_ALIAS_IS_MISSING);
                }
                String name = SrNewISCSIRemoteTargetDialog.this.myNameTextField.getText().trim();
                if (name.equals("")) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CREATE_REMOTE_TARGET_NAME_IS_MISSING);
                }
                StringBuffer msg = new StringBuffer("The name ");
                if (!TargetManager.getInstance().isTargetNameLegal(name, msg)) {
                    return msg.toString();
                }
                return null;
            }
        };
        this.myAliasTextField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.myNameTextField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.setOKAction(myOKAction);
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }
}

