/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.remotetarget;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetsRowSelectionEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetsRowSelectionListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetAddPortalDialog;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetClusterPopupMenu;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetDefaultPopupMenu;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetsShowDialog;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetsTableHeader;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrRemoteTargetTableCellRenderer;
import com.sanrad.nms.client.gui.iscsi.session.show.ISCSISessionsShowRemoteTargetViewDialog;
import com.sanrad.nms.client.gui.storage.dialogs.NewPhysStorageDeviceDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class SrISCSIRemoteTargetsTablePanel
extends SrTablePanel
implements View<SrISCSIRemoteTargetNode> {
    private SrISCSIRemoteTargetDefaultPopupMenu m_popup;
    protected SrISCSIRemoteTargetsShowDialog myParentDialog;
    protected JFrame m_frameOwner;
    private boolean m_isVswitchView = false;
    SrEventListenerManager.Informer<SrISCSIRemoteTargetsRowSelectionListener, SrISCSIRemoteTargetsRowSelectionEvent> iscsiRemoteTargetRowSelectedInformer = new SrEventListenerManager.Informer<SrISCSIRemoteTargetsRowSelectionListener, SrISCSIRemoteTargetsRowSelectionEvent>(){

        @Override
        public void inform(SrISCSIRemoteTargetsRowSelectionListener listener, SrISCSIRemoteTargetsRowSelectionEvent event) {
            listener.iscsiRemoteTargetRowSelected(event);
        }
    };
    public final SrClientAction addPortalAction = new SrClientAction<SrISCSIRemoteTargetNode, Void>(SrISCSIRemoteTargetClusterPopupMenu.ADD_PORTAL, true, true, (View)this, SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SrISCSIRemoteTargetNode> arg) {
            final SrISCSIRemoteTargetNode node = arg.iterator().next();
            final ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SrISCSIRemoteTargetAddPortalDialog dialog = new SrISCSIRemoteTargetAddPortalDialog(SrISCSIRemoteTargetsTablePanel.this.m_frameOwner, ((SiteNode)clusterNode.getParent()).getAlias(), clusterNode, node);
                    dialog.show();
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction addStorageAction = new SrClientAction<SrISCSIRemoteTargetNode, Void>(SrISCSIRemoteTargetClusterPopupMenu.ADD_STORAGE, true, true, (View)this, SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SrISCSIRemoteTargetNode> arg) {
            final SrISCSIRemoteTargetNode node = arg.iterator().next();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new NewPhysStorageDeviceDialog(SrISCSIRemoteTargetsTablePanel.this.m_frameOwner, node.getName(), PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI).show();
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final DeleteAction myDeleteAction;
    public final SrClientAction sessionLoginLogoutAction = new SrClientAction<SrISCSIRemoteTargetNode, Void>(true, true, (View)this, SrLicenseTreePath.GENERAL_PATH, true){
        private boolean myIsLogin;

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SrISCSIRemoteTargetNode> arg) {
            if (this.myIsLogin) {
                // empty if block
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            SrISCSIRemoteTargetNode selectedRemoteTargetNode = (SrISCSIRemoteTargetNode)this.myView.getValue().iterator().next();
            this.myIsLogin = !selectedRemoteTargetNode.isLoggedIn();
            this.setName(ClientLoader.BUNDLE.getString(this.myIsLogin ? SrClientBundleKeys.CLIENT_GUI_REMOTE_TARGET_POP_UP_MENU_LOGIN : SrClientBundleKeys.CLIENT_GUI_REMOTE_TARGET_POP_UP_MENU_LOGOUT));
            return "This action is not supported in the current version of StoragePro";
        }
    };
    public final SrClientAction sessionsShowAction = new SrClientAction<SrISCSIRemoteTargetNode, Void>(SrISCSIRemoteTargetDefaultPopupMenu.SHOW, true, true, (View)this, SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SrISCSIRemoteTargetNode> arg) {
            for (SrISCSIRemoteTargetNode selectedRemoteTargetNode : arg) {
                ISCSISessionsShowRemoteTargetViewDialog dialog = new ISCSISessionsShowRemoteTargetViewDialog(SrISCSIRemoteTargetsTablePanel.this.m_frameOwner, selectedRemoteTargetNode);
                dialog.show();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final AlarmAction myOpenSpecificAlarmsAction = new AlarmAction<SrISCSIRemoteTargetNode>(this, true);
    public final AlarmAction myOpenPropagatedAlarmsAction = new AlarmAction<SrISCSIRemoteTargetNode>(this, false);

    public SrISCSIRemoteTargetsTablePanel(JFrame frameOwner, SrISCSIRemoteTargetsShowDialog parentDialog, SrISCSIRemoteTargetsTableModel model, boolean isVswitchView) {
        super(model);
        this.m_frameOwner = frameOwner;
        this.myParentDialog = parentDialog;
        this.m_isVswitchView = isVswitchView;
        this.setSelectionMode(2);
        this.setRenderersAndEditors();
        this.myDeleteAction = new DeleteAction<SrISCSIRemoteTargetNode>(this, this.myParentDialog, new DeleteAction.Confirmator());
        this.setPopupMenu();
    }

    public void selectFirstRow() {
        this.getTable().getSelectionModel().setSelectionInterval(0, 0);
    }

    public void selectRemoteTarget(SrISCSIRemoteTargetNode remoteTargetNode) {
        SrISCSIRemoteTargetsTableModel model = (SrISCSIRemoteTargetsTableModel)this.getModel();
        int row = model.findRow(remoteTargetNode);
        if (row > -1) {
            this.getTable().getSelectionModel().setSelectionInterval(row, row);
        }
    }

    protected void setRenderersAndEditors() {
        int columnCount = this.getTable().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn tableColumn = this.getTable().getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new SrRemoteTargetTableCellRenderer());
        }
    }

    public boolean isVSwitchView() {
        return this.m_isVswitchView;
    }

    public void addISCSIRemoteTargetSelectionListener(SrISCSIRemoteTargetsRowSelectionListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeISCSIRemoteTargetSelectionListener(SrISCSIRemoteTargetsRowSelectionListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        if (rowIndices != null && rowIndices.length > 0) {
            int selectedRow = rowIndices[0];
            int nodeCol = SrISCSIRemoteTargetsTableHeader.REMOTE_TARGET_NODE.getIndexInModel();
            SrISCSIRemoteTargetNode remoteTargetNode = (SrISCSIRemoteTargetNode)this.getModel().getValueAt(selectedRow, nodeCol);
            SrISCSIRemoteTargetsRowSelectionEvent event = new SrISCSIRemoteTargetsRowSelectionEvent(this, remoteTargetNode);
            this.m_listeners.fireEvent(SrISCSIRemoteTargetsRowSelectionListener.class, event, this.iscsiRemoteTargetRowSelectedInformer);
        } else {
            SrISCSIRemoteTargetsRowSelectionEvent event = new SrISCSIRemoteTargetsRowSelectionEvent(this, null);
            this.m_listeners.fireEvent(SrISCSIRemoteTargetsRowSelectionListener.class, event, this.iscsiRemoteTargetRowSelectedInformer);
        }
    }

    protected void setPopupMenu() {
        this.m_popup = this.m_isVswitchView ? new SrISCSIRemoteTargetDefaultPopupMenu(this) : new SrISCSIRemoteTargetClusterPopupMenu(this);
        this.setTablePopUpMenuObject(this.m_popup);
    }

    @Override
    public Collection<SrISCSIRemoteTargetNode> getValue() {
        int[] selected = this.getSelectedRows();
        ArrayList<SrISCSIRemoteTargetNode> selectedRemoteTargetNodes = new ArrayList<SrISCSIRemoteTargetNode>(selected.length);
        SrISCSIRemoteTargetsTableModel model = (SrISCSIRemoteTargetsTableModel)this.getModel();
        for (int i = 0; i < selected.length; ++i) {
            int nodeCol = SrISCSIRemoteTargetsTableHeader.REMOTE_TARGET_NODE.getIndexInModel();
            SrISCSIRemoteTargetNode remoteTargetNode = (SrISCSIRemoteTargetNode)model.getValueAt(selected[i], nodeCol);
            selectedRemoteTargetNodes.add(remoteTargetNode);
        }
        return selectedRemoteTargetNodes;
    }

    @Override
    public void addListener(SrAction<SrISCSIRemoteTargetNode, ?> action) {
        this.getTable().getSelectionModel().addListSelectionListener(new View.ViewListSelectionListener(action));
    }

    @Override
    public void removeListener(SrAction<SrISCSIRemoteTargetNode, ?> action) {
        this.getTable().getSelectionModel().removeListSelectionListener(new View.ViewListSelectionListener(action));
    }

    public SrISCSIRemoteTargetsShowDialog getParentDialog() {
        return this.myParentDialog;
    }

    public void iscsiRemoteTargetPortalCreated(SrISCSIRemoteTargetNode remoteTargetNode) {
        SrISCSIRemoteTargetsTableModel model = (SrISCSIRemoteTargetsTableModel)this.getModel();
        model.updateRemoteTargetNumOfPortals(remoteTargetNode);
    }

    public void iscsiRemoteTargetPortalRemoved(SrISCSIRemoteTargetNode remoteTargetNode) {
        SrISCSIRemoteTargetsTableModel model = (SrISCSIRemoteTargetsTableModel)this.getModel();
        model.updateRemoteTargetNumOfPortals(remoteTargetNode);
    }
}

