/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.remotetarget;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalsModelsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsClusterViewTableModel;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsVswitchViewTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetPortalEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetPortalsListener;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrCloseDialog;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetDetailsPanel;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetPortalsClusterViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetPortalsTablePanel;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetsTablePanel;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.util.SrResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class SrISCSIRemoteTargetsShowDialog
extends SrCloseDialog
implements SrISCSIRemoteTargetsListener,
SrISCSIRemoteTargetPortalsListener {
    private int m_dialogView = 0;
    private SrTreeNode m_treeNode = null;
    private boolean m_isVswitchView = false;
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGETS_SHOW_DIALOG_SPECIFIC_TITLE);
    private static final String PORTALS_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGETS_PORTALS_SHOW_DIALOG_SPECIFIC_TITLE);
    private static final String DETAILS_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DETAILS_PANEL_SPECIFIC_TITLE);
    private SrISCSIRemoteTargetsTablePanel m_remoteTargetsTablePanel;
    private SrISCSIRemoteTargetPortalsTablePanel m_remoteTargetPortalsTablePanel;
    private SrISCSIRemoteTargetDetailsPanel m_remoteTargetDetailsPanel;
    private SrISCSIRemoteTargetPortalsModelsManager m_modelManager;
    private SrClientLabel m_portalsTableTitle = new SrClientLabel(PORTALS_SPECIFIC_TITLE);
    private SrClientLabel m_detailsTableTitle = new SrClientLabel(DETAILS_SPECIFIC_TITLE);
    private SrTreeNode m_operationOnNode;

    public SrISCSIRemoteTargetsShowDialog(JFrame owner, SrTreeNode treeNode, int dialogView) {
        super(owner, "", SystemRootNode.getInstance().getCurrentClusterNode());
        this.m_treeNode = treeNode;
        this.m_dialogView = dialogView;
        if (this.m_dialogView == 1) {
            this.m_isVswitchView = true;
        }
        this.setDialogTitle();
        this.initDialogPanels();
        this.initDialogLayout();
        this.pack();
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
        SrISCSIRemoteTargetsManager.getInstance().removeISCSIRemoteTargetsListener(this);
        SrISCSIRemoteTargetPortalsManager.getInstance().removeRemoteTargetPortalsListener(this);
        this.m_modelManager.removeListeners();
        this.m_remoteTargetsTablePanel.getModel().removeListeners();
        if (this.m_remoteTargetDetailsPanel != null) {
            this.m_remoteTargetDetailsPanel.removeListeners();
        }
    }

    @Override
    public void addListeners() {
        SrISCSIRemoteTargetsManager.getInstance().addISCSIRemoteTargetsListener(this);
        SrISCSIRemoteTargetPortalsManager.getInstance().addRemoteTargetPortalsListener(this);
        this.m_modelManager.addListeners();
        this.m_remoteTargetsTablePanel.getModel().addListeners();
        if (this.m_remoteTargetDetailsPanel != null) {
            this.m_remoteTargetDetailsPanel.addListeners();
        }
    }

    private void setDialogTitle() {
        String title = "";
        switch (this.m_dialogView) {
            case 0: {
                title = ClientLoader.CLUSTER_DISPLAY_STRING + " " + ((ClusterNode)this.m_treeNode).getAlias();
                break;
            }
            case 1: {
                title = ClientLoader.VSWITCH_DISPLAY_STRING + " " + ((VSwitchNode)this.m_treeNode).getName();
                break;
            }
            case 2: {
                title = "Target " + (TargetNode)this.m_treeNode;
            }
        }
        this.setTitle(title + " - " + DIALOG_SPECIFIC_TITLE);
    }

    private void initDialogPanels() {
        this.createISCSIRemoteTargetsTablePanel();
        this.createISCSIRemoteTargetPortalsTablePanel();
        if (this.m_isVswitchView) {
            this.createISCSIRemoteTargetDetailsPanel();
        }
        Dimension dim = this.m_remoteTargetsTablePanel.getPreferredSize();
        this.m_remoteTargetsTablePanel.setPreferredSize(new Dimension(dim.width + 100, 200));
        int remoteTargetPortalsTablePanelWidth = this.m_isVswitchView ? (dim.width + 100) / 2 : dim.width + 100;
        this.m_remoteTargetPortalsTablePanel.setPreferredSize(new Dimension(remoteTargetPortalsTablePanelWidth, 200));
        if (this.m_isVswitchView) {
            this.m_remoteTargetDetailsPanel.setPreferredSize(new Dimension((dim.width + 100) / 2, 200));
        }
        this.selectFirstRemoteTargetRow();
    }

    private void createISCSIRemoteTargetsTablePanel() {
        switch (this.m_dialogView) {
            case 0: {
                this.m_remoteTargetsTablePanel = new SrISCSIRemoteTargetsTablePanel((JFrame)this.getOwner(), this, new SrISCSIRemoteTargetsClusterViewTableModel((ClusterNode)this.m_treeNode), false);
                break;
            }
            case 1: {
                this.m_remoteTargetsTablePanel = new SrISCSIRemoteTargetsTablePanel((JFrame)this.getOwner(), this, new SrISCSIRemoteTargetsVswitchViewTableModel((VSwitchNode)this.m_treeNode), true);
            }
        }
    }

    private void selectFirstRemoteTargetRow() {
        this.m_remoteTargetsTablePanel.selectFirstRow();
    }

    private void createISCSIRemoteTargetPortalsTablePanel() {
        this.m_modelManager = new SrISCSIRemoteTargetPortalsModelsManager(this.m_dialogView, this.m_treeNode, this.m_remoteTargetsTablePanel);
        this.m_modelManager.createAllPortalsModels();
        switch (this.m_dialogView) {
            case 0: {
                this.m_remoteTargetPortalsTablePanel = new SrISCSIRemoteTargetPortalsClusterViewTablePanel(this.m_modelManager, this.m_remoteTargetsTablePanel);
                break;
            }
            case 1: {
                this.m_remoteTargetPortalsTablePanel = new SrISCSIRemoteTargetPortalsTablePanel(this.m_modelManager, this.m_remoteTargetsTablePanel);
            }
        }
        this.initPanelTitle(this.m_portalsTableTitle);
    }

    private void createISCSIRemoteTargetDetailsPanel() {
        this.m_remoteTargetDetailsPanel = new SrISCSIRemoteTargetDetailsPanel(SrISCSIRemoteTargetsShowDialog.class.getName(), (VSwitchNode)this.m_treeNode, this.m_remoteTargetsTablePanel);
        this.initPanelTitle(this.m_detailsTableTitle);
    }

    private void initPanelTitle(SrClientLabel label) {
        Font titleFont = Font.decode(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getString(SrDefaultUIBundleKeys.PANEL_TITLE_LABEL_FONT));
        label.setFont(new Font(titleFont.getName(), 1, titleFont.getSize()));
        label.setForeground(ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.TITLED_BORDER_FOREGROUND));
    }

    private void initDialogLayout() {
        SrPanel mainPanel = new SrPanel(new BorderLayout());
        mainPanel.add((Component)this.m_remoteTargetsTablePanel, "North");
        SrPanel bottomLeftPanel = new SrPanel(new BorderLayout(0, 7));
        bottomLeftPanel.add((Component)this.m_remoteTargetPortalsTablePanel, "Center");
        bottomLeftPanel.setBorder(BorderFactory.createTitledBorder(null, this.m_portalsTableTitle.getValue().toString(), 4, 2, this.m_portalsTableTitle.getFont(), this.m_portalsTableTitle.getForeground()));
        SrPanel bottomPanel = new SrPanel(new BorderLayout(this.m_isVswitchView ? 10 : 0, 0));
        bottomPanel.add((Component)bottomLeftPanel, "West");
        if (this.m_isVswitchView) {
            SrPanel bottomRightPanel = new SrPanel(new BorderLayout(0, 7));
            bottomRightPanel.add((Component)this.m_remoteTargetDetailsPanel, "Center");
            bottomRightPanel.setBorder(BorderFactory.createTitledBorder(null, this.m_detailsTableTitle.getValue().toString(), 4, 2, this.m_detailsTableTitle.getFont(), this.m_detailsTableTitle.getForeground()));
            bottomPanel.add((Component)bottomRightPanel, "Center");
        }
        mainPanel.add((Component)bottomPanel, "Center");
        super.initDialogLayout(mainPanel);
    }

    public SrISCSIRemoteTargetsTablePanel getRemoteTargetsTablePanel() {
        return this.m_remoteTargetsTablePanel;
    }

    public void setOperationNode(SrTreeNode node) {
        this.m_operationOnNode = node;
        this.setWaitCursor();
    }

    public SrTreeNode getOperationNode() {
        return this.m_operationOnNode;
    }

    @Override
    public void iscsiRemoteTargetCreated(SrISCSIRemoteTargetEvent e) {
    }

    @Override
    public void iscsiRemoteTargetRemoved(SrISCSIRemoteTargetEvent e) {
        Object stub = e.getISCSIRemoteTargetNode().getStub();
        if (this.getOperationNode() != null && this.getOperationNode().getStub().equals(stub)) {
            this.setDefaultCursor();
        }
    }

    @Override
    public void iscsiRemoteTargetChanged(SrISCSIRemoteTargetEvent e) {
    }

    @Override
    public void iscsiRemoteTargetPortalCreated(SrISCSIRemoteTargetPortalEvent e) {
    }

    @Override
    public void iscsiRemoteTargetPortalRemoved(SrISCSIRemoteTargetPortalEvent e) {
        Object stub = e.getISCSIRemoteTargetPortalNode().getStub();
        if (this.getOperationNode() != null && this.getOperationNode().getStub().equals(stub)) {
            this.setDefaultCursor();
        }
    }

    @Override
    public void iscsiRemoteTargetPortalChanged(SrISCSIRemoteTargetPortalEvent e) {
    }
}

