/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.remotetarget;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetsListener;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetsRowSelectionEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetsRowSelectionListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetsTablePanel;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComponent;
import java.awt.Color;

public class SrISCSIRemoteTargetDetailsPanel
extends SrPropertyPanel
implements SrISCSIRemoteTargetsRowSelectionListener,
SrISCSIRemoteTargetsListener {
    private SrISCSIRemoteTargetsTablePanel m_remoteTargetsTablePanel;
    private SrISCSIRemoteTargetNode m_currRemoteTargetDisplayed;
    private VSwitchNode m_vswitchNode;

    public SrISCSIRemoteTargetDetailsPanel(String parentName, VSwitchNode vswitchNode, SrISCSIRemoteTargetsTablePanel remoteTargetsTablePanel) {
        super(parentName, false, true, false);
        this.m_vswitchNode = vswitchNode;
        this.m_remoteTargetsTablePanel = remoteTargetsTablePanel;
        this.m_remoteTargetsTablePanel.addISCSIRemoteTargetSelectionListener(this);
        this.initPanelComponents();
    }

    public void addListeners() {
        SrISCSIRemoteTargetsManager.getInstance().addISCSIRemoteTargetsListener(this);
    }

    @Override
    public void removeListeners() {
        SrISCSIRemoteTargetsManager.getInstance().removeISCSIRemoteTargetsListener(this);
    }

    private void initPanelComponents() {
        Color whiteBackground = LookAndFill.TABLE_BACKGROUND;
        this.setBackground(whiteBackground);
        SrClientLabel keylf = this.initLabelField(whiteBackground, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DETAILS_PANEL_ALIAS));
        SrClientLabel valuelf = this.initLabelField(whiteBackground, "");
        this.addProperty(keylf, (SrComponent)valuelf);
        keylf = this.initLabelField(whiteBackground, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DETAILS_PANEL_DISCOVERED));
        valuelf = this.initLabelField(whiteBackground, "");
        this.addProperty(keylf, (SrComponent)valuelf);
        keylf = this.initLabelField(whiteBackground, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DETAILS_PANEL_CONFIGURED));
        valuelf = this.initLabelField(whiteBackground, "");
        this.addProperty(keylf, (SrComponent)valuelf);
        keylf = this.initLabelField(whiteBackground, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DETAILS_PANEL_FAILURE_TYPE));
        valuelf = this.initLabelField(whiteBackground, "");
        this.addProperty(keylf, (SrComponent)valuelf);
    }

    private SrClientLabel initLabelField(Color backgroundColor, String text) {
        SrClientLabel lf = new SrClientLabel();
        lf.setBackground(backgroundColor);
        lf.setText(text);
        return lf;
    }

    private void updateComponentsValues(SrISCSIRemoteTargetNode remoteTargetNode) {
        boolean isNullNode = remoteTargetNode == null;
        SrClientLabel tf = (SrClientLabel)this.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DETAILS_PANEL_ALIAS));
        tf.setValue(isNullNode ? "" : remoteTargetNode.getAlias());
        tf = (SrClientLabel)this.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DETAILS_PANEL_DISCOVERED));
        tf.setValue(isNullNode ? "" : remoteTargetNode.getIsDiscovered().toString());
        tf = (SrClientLabel)this.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DETAILS_PANEL_CONFIGURED));
        tf.setValue(isNullNode ? "" : remoteTargetNode.getIsConfigured().toString());
        tf = (SrClientLabel)this.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DETAILS_PANEL_FAILURE_TYPE));
        tf.setValue(isNullNode ? "" : remoteTargetNode.getFailureType(this.m_vswitchNode).toString());
        this.m_currRemoteTargetDisplayed = remoteTargetNode;
    }

    @Override
    public void iscsiRemoteTargetRowSelected(SrISCSIRemoteTargetsRowSelectionEvent event) {
        this.updateComponentsValues(event.getRemoteTargetNode());
    }

    @Override
    public void iscsiRemoteTargetCreated(SrISCSIRemoteTargetEvent e) {
    }

    @Override
    public void iscsiRemoteTargetRemoved(SrISCSIRemoteTargetEvent e) {
        SrISCSIRemoteTargetNode iscsiRemoteTargetNode = e.getISCSIRemoteTargetNode();
        if (iscsiRemoteTargetNode.equals(this.m_currRemoteTargetDisplayed)) {
            this.updateComponentsValues(null);
        }
    }

    @Override
    public void iscsiRemoteTargetChanged(SrISCSIRemoteTargetEvent e) {
        SrISCSIRemoteTargetNode iscsiRemoteTargetNode = e.getISCSIRemoteTargetNode();
        if (iscsiRemoteTargetNode.isConnectedToInitiator(this.m_vswitchNode.getISCSIInitiators()[0].getName())) {
            this.updateComponentsValues(iscsiRemoteTargetNode);
        } else {
            this.iscsiRemoteTargetRemoved(e);
        }
    }
}

