/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.remotetarget;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalsManager;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIAddPortalDialog;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetAddPortalPanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;

public class SrISCSIRemoteTargetAddPortalDialog
extends SrISCSIAddPortalDialog {
    private SrISCSIRemoteTargetNode m_parentRemoteTargetNode;
    private SrIPTextField myIpTextField;
    private SrIntegerTextField myPortTextField;
    private SrTextField myTagTextField;

    public SrISCSIRemoteTargetAddPortalDialog(JFrame frm, String siteName, ClusterNode aCluster, SrISCSIRemoteTargetNode remoteTargetNode) {
        super(frm, aCluster, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DLG_TITLE_SITE) + " " + siteName + "; " + ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DLG_TITLE_CLUSTER) + " " + aCluster + "; " + ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_TARGET_DLG_TITLE_REMOTE_TARGET) + " " + "remoteTargetNode.getAlias()" + "; " + ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_PORTAL_DLG_SPECIFIC_TITLE));
        SrISCSIRemoteTargetAddPortalPanel panel = new SrISCSIRemoteTargetAddPortalPanel("SrISCSIRemoteTargetAddPortalDialog", remoteTargetNode);
        this.myIpTextField = (SrIPTextField)panel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_PORTAL_DLG_IP));
        this.myPortTextField = (SrIntegerTextField)panel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_PORTAL_DLG_PORT));
        this.myTagTextField = (SrTextField)panel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_REMOTE_TARGET_ADD_PORTAL_DLG_GROUP_TAG));
        this.m_parentRemoteTargetNode = remoteTargetNode;
        this.addCenterPanel(panel);
        this.setOKAction();
        this.pack();
    }

    protected void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                String ip = SrISCSIRemoteTargetAddPortalDialog.this.myIpTextField.getText();
                String portStr = SrISCSIRemoteTargetAddPortalDialog.this.myPortTextField.getText();
                Integer port = Integer.valueOf(portStr);
                Integer groupTag = Integer.valueOf(SrISCSIRemoteTargetAddPortalDialog.this.myTagTextField.getText());
                return Collections.singleton(SrISCSIRemoteTargetPortalsManager.getInstance().createISCSIRemoteTargetPortal(ip, port, groupTag, SrISCSIRemoteTargetAddPortalDialog.this.m_parentRemoteTargetNode));
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String portStr = SrISCSIRemoteTargetAddPortalDialog.this.myPortTextField.getText();
                if (portStr.trim().equals("")) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.ADD_PORTAL_PORT_IS_MISSING);
                }
                String portTag = SrISCSIRemoteTargetAddPortalDialog.this.myTagTextField.getText();
                if (portTag.trim().equals("")) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.ADD_PORTAL_TAG_IS_MISSING);
                }
                return null;
            }
        };
        this.myPortTextField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.myTagTextField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.setOKAction(myOKAction);
    }
}

